/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.filter.FilteringResponseWrapper;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.apache.felix.webconsole.internal.misc.ConfigurationRender;
import org.apache.felix.webconsole.internal.servlet.ConfigurationListener;
import org.apache.felix.webconsole.internal.servlet.ConfigurationListener2;
import org.apache.felix.webconsole.internal.servlet.OsgiManagerHttpContext;
import org.apache.felix.webconsole.internal.servlet.PluginHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiManager
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_APP_ROOT_OLD = (class$org$apache$felix$webconsole$internal$servlet$OsgiManager == null ? (class$org$apache$felix$webconsole$internal$servlet$OsgiManager = OsgiManager.class$("org.apache.felix.webconsole.internal.servlet.OsgiManager")) : class$org$apache$felix$webconsole$internal$servlet$OsgiManager).getName() + ".appRoot";
    private static final String ATTR_LABEL_MAP_OLD = (class$org$apache$felix$webconsole$internal$servlet$OsgiManager == null ? (class$org$apache$felix$webconsole$internal$servlet$OsgiManager = OsgiManager.class$("org.apache.felix.webconsole.internal.servlet.OsgiManager")) : class$org$apache$felix$webconsole$internal$servlet$OsgiManager).getName() + ".labelMap";
    public static final String PARAM_NO_REDIRECT_AFTER_ACTION = "_noredir_";
    private static final String COOKIE_LOCALE = "felix.webconsole.locale";
    static final String PROP_MANAGER_ROOT = "manager.root";
    static final String PROP_DEFAULT_RENDER = "default.render";
    static final String PROP_REALM = "realm";
    static final String PROP_USER_NAME = "username";
    static final String PROP_PASSWORD = "password";
    static final String PROP_ENABLED_PLUGINS = "plugins";
    static final String PROP_LOG_LEVEL = "loglevel";
    static final String PROP_LOCALE = "locale";
    static final String PROP_HTTP_SERVICE_SELECTOR = "http.service.filter";
    public static final int DEFAULT_LOG_LEVEL = 2;
    static final String DEFAULT_PAGE = "bundles";
    static final String DEFAULT_REALM = "OSGi Management Console";
    static final String DEFAULT_USER_NAME = "admin";
    static final String DEFAULT_PASSWORD = "admin";
    static final String DEFAULT_HTTP_SERVICE_SELECTOR = "";
    static final String DEFAULT_MANAGER_ROOT = "/system/console";
    static final String[] PLUGIN_CLASSES = new String[]{"org.apache.felix.webconsole.internal.compendium.ComponentConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.ComponentsServlet", "org.apache.felix.webconsole.internal.compendium.ConfigManager", "org.apache.felix.webconsole.internal.compendium.ConfigurationAdminConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.LogServlet", "org.apache.felix.webconsole.internal.compendium.PreferencesConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.WireAdminConfigurationPrinter", "org.apache.felix.webconsole.internal.core.BundlesServlet", "org.apache.felix.webconsole.internal.core.PermissionsConfigurationPrinter", "org.apache.felix.webconsole.internal.core.ServicesConfigurationPrinter", "org.apache.felix.webconsole.internal.core.ServicesServlet", "org.apache.felix.webconsole.internal.deppack.DepPackServlet", "org.apache.felix.webconsole.internal.misc.LicenseServlet", "org.apache.felix.webconsole.internal.misc.ShellServlet", "org.apache.felix.webconsole.internal.misc.SystemPropertiesPrinter", "org.apache.felix.webconsole.internal.misc.ThreadPrinter", "org.apache.felix.webconsole.internal.obr.BundleRepositoryRender", "org.apache.felix.webconsole.internal.system.VMStatPlugin"};
    private BundleContext bundleContext;
    private HttpServiceTracker httpServiceTracker;
    private HttpService httpService;
    private PluginHolder holder;
    private ServiceTracker brandingTracker;
    private ServiceTracker securityProviderTracker;
    private ServiceRegistration configurationListener;
    private List osgiManagerPlugins = new ArrayList();
    private String webManagerRoot;
    private boolean httpServletRegistered;
    private boolean httpResourcesRegistered;
    private Dictionary configuration;
    private Locale configuredLocale;
    private Set enabledPlugins;
    ResourceBundleManager resourceBundleManager;
    private int logLevel = 2;
    private Map langMap;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$servlet$OsgiManager;
    static /* synthetic */ Class class$org$apache$felix$webconsole$WebConsoleSecurityProvider;
    static /* synthetic */ Class class$org$apache$felix$webconsole$BrandingPlugin;

    public OsgiManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.holder = new PluginHolder(bundleContext);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        for (int i = 0; i < PLUGIN_CLASSES.length; ++i) {
            String pluginClassName = PLUGIN_CLASSES[i];
            try {
                Class<?> pluginClass = classLoader.loadClass(pluginClassName);
                Object plugin = pluginClass.newInstance();
                if (this.isPluginDisabled(pluginClassName, plugin)) {
                    this.log(3, "Ignoring plugin " + pluginClassName + ": Disabled by configuration");
                    continue;
                }
                if (plugin instanceof OsgiManagerPlugin) {
                    ((OsgiManagerPlugin)plugin).activate(bundleContext);
                    this.osgiManagerPlugins.add(plugin);
                }
                if (plugin instanceof AbstractWebConsolePlugin) {
                    this.holder.addOsgiManagerPlugin((AbstractWebConsolePlugin)((Object)plugin));
                    continue;
                }
                if (!(plugin instanceof BrandingPlugin)) continue;
                AbstractWebConsolePlugin.setBrandingPlugin((BrandingPlugin)plugin);
                continue;
            }
            catch (NoClassDefFoundError ncdfe) {
                String message = ncdfe.getMessage();
                if (message == null) {
                    message = "Class definition not found (NoClassDefFoundError)";
                } else if (message.indexOf(32) < 0) {
                    message = "Class " + message + " missing";
                }
                this.log(3, pluginClassName + " not enabled. Reason: " + message);
                continue;
            }
            catch (Throwable t) {
                this.log(3, "Failed to instantiate plugin " + pluginClassName + ". Reason: " + t);
            }
        }
        this.resourceBundleManager = new ResourceBundleManager(this.getBundleContext());
        ConfigurationRender cr = new ConfigurationRender(this.resourceBundleManager);
        cr.activate(bundleContext);
        this.osgiManagerPlugins.add(cr);
        this.holder.addOsgiManagerPlugin(cr);
        this.holder.open();
        this.brandingTracker = new BrandingServiceTracker(this);
        this.brandingTracker.open();
        this.securityProviderTracker = new ServiceTracker(bundleContext, (class$org$apache$felix$webconsole$WebConsoleSecurityProvider == null ? (class$org$apache$felix$webconsole$WebConsoleSecurityProvider = OsgiManager.class$("org.apache.felix.webconsole.WebConsoleSecurityProvider")) : class$org$apache$felix$webconsole$WebConsoleSecurityProvider).getName(), null);
        this.securityProviderTracker.open();
        this.updateConfiguration(null);
        try {
            this.configurationListener = ConfigurationListener2.create(this);
        }
        catch (Throwable t2) {
            try {
                this.configurationListener = ConfigurationListener.create(this);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        this.holder.close();
        if (this.resourceBundleManager != null) {
            this.resourceBundleManager.dispose();
            this.resourceBundleManager = null;
        }
        if (this.brandingTracker != null) {
            this.brandingTracker.close();
            this.brandingTracker = null;
        }
        Iterator pi = this.osgiManagerPlugins.iterator();
        while (pi.hasNext()) {
            Object plugin = pi.next();
            ((OsgiManagerPlugin)plugin).deactivate();
        }
        this.osgiManagerPlugins.clear();
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        if (this.configurationListener != null) {
            this.configurationListener.unregister();
            this.configurationListener = null;
        }
        this.bundleContext = null;
    }

    public void init() {
        this.holder.setServletContext(this.getServletContext());
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.service((HttpServletRequest)req, (HttpServletResponse)res);
        res.flushBuffer();
    }

    private void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.equals("/")) {
            String path = request.getRequestURI();
            if (!path.endsWith("/")) {
                path = path.concat("/");
            }
            path = path.concat(this.holder.getDefaultPluginLabel());
            response.sendRedirect(path);
            return;
        }
        int slash = pathInfo.indexOf("/", 1);
        if (slash < 2) {
            slash = pathInfo.length();
        }
        Locale locale = this.getConfiguredLocale(request);
        String label = pathInfo.substring(1, slash);
        AbstractWebConsolePlugin plugin = this.getConsolePlugin(label);
        if (plugin != null) {
            Map labelMap = this.holder.getLocalizedLabelMap(this.resourceBundleManager, locale);
            request.setAttribute("felix.webconsole.langMap", (Object)this.getLangMap());
            request.setAttribute("felix.webconsole.labelMap", (Object)labelMap);
            request.setAttribute("felix.webconsole.appRoot", (Object)(request.getContextPath() + request.getServletPath()));
            request.setAttribute("felix.webconsole.pluginRoot", (Object)(request.getContextPath() + request.getServletPath() + '/' + label));
            request.setAttribute(ATTR_LABEL_MAP_OLD, (Object)labelMap);
            request.setAttribute(ATTR_APP_ROOT_OLD, (Object)(request.getContextPath() + request.getServletPath()));
            request = this.wrapRequest(request, locale);
            response = this.wrapResponse(request, response, plugin);
            plugin.service((ServletRequest)request, (ServletResponse)response);
        } else {
            String body404 = MessageFormat.format(this.resourceBundleManager.getResourceBundle(this.bundleContext.getBundle(), locale).getString("404"), request.getContextPath() + request.getServletPath() + '/' + DEFAULT_PAGE);
            response.setCharacterEncoding("utf-8");
            response.setContentType("text/html");
            response.setStatus(404);
            response.getWriter().println(body404);
        }
    }

    private final AbstractWebConsolePlugin getConsolePlugin(String label) {
        if ("install".equals(label)) {
            return this.holder.getPlugin(DEFAULT_PAGE);
        }
        return this.holder.getPlugin(label);
    }

    private final Locale getConfiguredLocale(HttpServletRequest request) {
        Locale locale = null;
        Cookie[] cookies = request.getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!COOKIE_LOCALE.equals(cookies[i].getName())) continue;
            locale = Util.parseLocaleString(cookies[i].getValue());
            break;
        }
        if (locale == null) {
            locale = this.configuredLocale;
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        return locale;
    }

    public void destroy() {
        this.holder.setServletContext(null);
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    String getConfigurationPid() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void log(int level, String message) {
        if (this.logLevel >= level) {
            this.log(message);
        }
    }

    private void log(int level, String message, Throwable t) {
        if (this.logLevel >= level) {
            this.log(message, t);
        }
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request, final Locale locale) {
        return new HttpServletRequestWrapper(request){

            public Locale getLocale() {
                return locale;
            }
        };
    }

    private HttpServletResponse wrapResponse(HttpServletRequest request, HttpServletResponse response, AbstractWebConsolePlugin plugin) {
        Locale locale = request.getLocale();
        ResourceBundle resourceBundle = this.resourceBundleManager.getResourceBundle(plugin.getBundle(), locale);
        return new FilteringResponseWrapper(response, resourceBundle, (ServletRequest)request);
    }

    protected synchronized void bindHttpService(HttpService httpService) {
        if (this.httpService != null) {
            this.log(4, "bindHttpService: Already bound to an HTTP Service, ignoring further services");
            return;
        }
        Dictionary config = this.getConfiguration();
        String realm = this.getProperty(config, PROP_REALM, DEFAULT_REALM);
        String userId = this.getProperty(config, PROP_USER_NAME, "admin");
        String password = this.getProperty(config, PROP_PASSWORD, "admin");
        try {
            OsgiManagerHttpContext httpContext = new OsgiManagerHttpContext(httpService, realm, new SecurityProvider(this.securityProviderTracker, userId, password));
            Dictionary servletConfig = this.toStringConfig(config);
            httpService.registerServlet(this.webManagerRoot, (Servlet)this, servletConfig, (HttpContext)httpContext);
            this.httpServletRegistered = true;
            httpService.registerResources(this.webManagerRoot + "/res", "/res", (HttpContext)httpContext);
            this.httpResourcesRegistered = true;
        }
        catch (Exception e) {
            this.log(1, "bindHttpService: Problem setting up", e);
        }
        this.httpService = httpService;
    }

    protected synchronized void unbindHttpService(HttpService httpService) {
        if (this.httpService != httpService) {
            this.log(4, "unbindHttpService: Ignoring unbind of an HttpService to which we are not registered");
            return;
        }
        this.httpService = null;
        if (this.httpResourcesRegistered) {
            try {
                httpService.unregister(this.webManagerRoot + "/res");
            }
            catch (Throwable t) {
                this.log(2, "unbindHttpService: Failed unregistering Resources", t);
            }
            this.httpResourcesRegistered = false;
        }
        if (this.httpServletRegistered) {
            try {
                httpService.unregister(this.webManagerRoot);
            }
            catch (Throwable t) {
                this.log(2, "unbindHttpService: Failed unregistering Servlet", t);
            }
            this.httpServletRegistered = false;
        }
    }

    private Dictionary getConfiguration() {
        return this.configuration;
    }

    synchronized void updateConfiguration(Dictionary config) {
        Object pluginValue;
        if (config == null) {
            config = new Hashtable();
        }
        this.configuration = config;
        Object locale = ((Dictionary)config).get(PROP_LOCALE);
        this.configuredLocale = locale == null || locale.toString().trim().length() == 0 ? null : Util.parseLocaleString(locale.toString().trim());
        this.logLevel = this.getProperty(config, PROP_LOG_LEVEL, 2);
        AbstractWebConsolePlugin.setLogLevel(this.logLevel);
        this.holder.setDefaultPluginLabel(this.getProperty(config, PROP_DEFAULT_RENDER, DEFAULT_PAGE));
        String newWebManagerRoot = this.getProperty(config, PROP_MANAGER_ROOT, DEFAULT_MANAGER_ROOT);
        if (!newWebManagerRoot.startsWith("/")) {
            newWebManagerRoot = "/" + newWebManagerRoot;
        }
        String newHttpServiceSelector = this.getProperty(config, PROP_HTTP_SERVICE_SELECTOR, DEFAULT_HTTP_SERVICE_SELECTOR);
        if (this.httpServiceTracker != null && !this.httpServiceTracker.isSameSelector(newHttpServiceSelector)) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        if ((pluginValue = ((Dictionary)config).get(PROP_ENABLED_PLUGINS)) == null) {
            this.enabledPlugins = null;
        } else if (pluginValue.getClass().isArray()) {
            Object[] names = (Object[])pluginValue;
            this.enabledPlugins = new HashSet();
            for (int i = 0; i < names.length; ++i) {
                this.enabledPlugins.add(String.valueOf(names[i]));
            }
        } else if (pluginValue instanceof Collection) {
            this.enabledPlugins = new HashSet();
            this.enabledPlugins.addAll((Collection)pluginValue);
        }
        HttpService httpService = this.httpService;
        if (httpService != null) {
            this.unbindHttpService(httpService);
            this.webManagerRoot = newWebManagerRoot;
            this.bindHttpService(httpService);
        } else {
            this.webManagerRoot = newWebManagerRoot;
        }
        if (this.httpServiceTracker == null) {
            this.httpServiceTracker = HttpServiceTracker.create(this, newHttpServiceSelector);
            this.httpServiceTracker.open();
        }
    }

    private String getProperty(Dictionary config, String name, String def) {
        Object value = config.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return def;
        }
        return String.valueOf(value);
    }

    private int getProperty(Dictionary config, String name, int def) {
        Object value = config.get(name);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return def;
    }

    private boolean isPluginDisabled(String pluginClass, Object plugin) {
        return this.enabledPlugins != null && !this.enabledPlugins.contains(pluginClass) && plugin instanceof AbstractWebConsolePlugin;
    }

    private Dictionary toStringConfig(Dictionary config) {
        Hashtable<String, String> stringConfig = new Hashtable<String, String>();
        Enumeration ke = config.keys();
        while (ke.hasMoreElements()) {
            Object key = ke.nextElement();
            ((Dictionary)stringConfig).put(key.toString(), String.valueOf(config.get(key)));
        }
        return stringConfig;
    }

    private final Map getLangMap() {
        if (null != this.langMap) {
            return this.langMap;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Bundle bundle = this.bundleContext.getBundle();
        Enumeration e = bundle.findEntries("res/flags", null, false);
        while (e != null && e.hasMoreElements()) {
            URL img = (URL)e.nextElement();
            String name = FilenameUtils.getBaseName((String)img.getFile());
            try {
                String locale = new Locale(name).getDisplayLanguage();
                map.put(name, null != locale ? locale : name);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.langMap = map;
        return this.langMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class SecurityProvider
    implements WebConsoleSecurityProvider {
        final ServiceTracker tracker;
        final String username;
        final String password;

        SecurityProvider(ServiceTracker tracker, String username, String password) {
            this.tracker = tracker;
            this.username = username;
            this.password = password;
        }

        public Object authenticate(String username, String password) {
            WebConsoleSecurityProvider provider = (WebConsoleSecurityProvider)this.tracker.getService();
            if (provider != null) {
                return provider.authenticate(username, password);
            }
            if (this.username.equals(username) && this.password.equals(password)) {
                return username;
            }
            return null;
        }

        public boolean authorize(Object user, String role) {
            return true;
        }
    }

    private static class BrandingServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        BrandingServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), (class$org$apache$felix$webconsole$BrandingPlugin == null ? (class$org$apache$felix$webconsole$BrandingPlugin = OsgiManager.class$("org.apache.felix.webconsole.BrandingPlugin")) : class$org$apache$felix$webconsole$BrandingPlugin).getName(), null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object plugin = super.addingService(reference);
            if (plugin instanceof BrandingPlugin) {
                AbstractWebConsolePlugin.setBrandingPlugin((BrandingPlugin)plugin);
            }
            return plugin;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof BrandingPlugin) {
                AbstractWebConsolePlugin.setBrandingPlugin(null);
            }
            super.removedService(reference, service);
        }
    }

    private static class HttpServiceTracker
    extends ServiceTracker {
        private static final String HTTP_SERVICE = "org.osgi.service.http.HttpService";
        private final OsgiManager osgiManager;
        private final String httpServiceSelector;

        static HttpServiceTracker create(OsgiManager osgiManager, String httpServiceSelector) {
            if (httpServiceSelector != null && httpServiceSelector.length() > 0) {
                try {
                    String filterString = "(&(objectClass=org.osgi.service.http.HttpService)(" + httpServiceSelector + "))";
                    Filter filter = osgiManager.getBundleContext().createFilter(filterString);
                    return new HttpServiceTracker(osgiManager, httpServiceSelector, filter);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
            return new HttpServiceTracker(osgiManager);
        }

        private HttpServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), HTTP_SERVICE, null);
            this.osgiManager = osgiManager;
            this.httpServiceSelector = null;
        }

        private HttpServiceTracker(OsgiManager osgiManager, String httpServiceSelector, Filter httpServiceFilter) {
            super(osgiManager.getBundleContext(), httpServiceFilter, null);
            this.osgiManager = osgiManager;
            this.httpServiceSelector = httpServiceSelector;
        }

        boolean isSameSelector(String newHttpServiceSelector) {
            if (newHttpServiceSelector != null) {
                return newHttpServiceSelector.equals(this.httpServiceSelector);
            }
            return this.httpServiceSelector == null;
        }

        public Object addingService(ServiceReference reference) {
            Object service = super.addingService(reference);
            if (service instanceof HttpService) {
                this.osgiManager.bindHttpService((HttpService)service);
            }
            return service;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof HttpService) {
                this.osgiManager.unbindHttpService((HttpService)service);
            }
            super.removedService(reference, service);
        }
    }
}

