/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.endpoints;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.EndpointComponentContext;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.AbstractEndpoint;

public abstract class SimpleEndpoint
extends AbstractEndpoint {
    private static final Log LOG = LogFactory.getLog(SimpleEndpoint.class);
    private DeliveryChannel channel;
    private MessageExchangeFactory exchangeFactory;
    private ComponentContext context;

    public SimpleEndpoint() {
    }

    public SimpleEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public SimpleEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component.getServiceUnit(), endpoint.getServiceName(), endpoint.getEndpointName());
    }

    public synchronized void activate() throws Exception {
        this.context = new EndpointComponentContext(this);
        this.channel = this.context.getDeliveryChannel();
        this.exchangeFactory = this.channel.createExchangeFactory();
    }

    public synchronized void deactivate() throws Exception {
    }

    public synchronized void start() throws Exception {
    }

    public synchronized void stop() throws Exception {
    }

    protected void send(MessageExchange me) throws MessagingException {
        this.channel.send(me);
    }

    protected void sendSync(MessageExchange me) throws MessagingException {
        if (!this.channel.sendSync(me)) {
            throw new MessagingException("SendSync failed");
        }
    }

    protected void done(MessageExchange me) throws MessagingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"SimpleEndpoint.done called: ");
        }
        me.setStatus(ExchangeStatus.DONE);
        this.send(me);
    }

    protected void fail(MessageExchange me, Exception error) throws MessagingException {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"SimpleEndpoint.fail called: ");
        }
        me.setError(error);
        this.send(me);
    }

    public MessageExchangeFactory getExchangeFactory() {
        return this.exchangeFactory;
    }

    public DeliveryChannel getChannel() {
        return this.channel;
    }

    public ComponentContext getContext() {
        return this.context;
    }
}

