/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.completer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.osgi.service.command.CommandSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionScopeCompleter
implements Completer {
    private final CommandSession session;
    private final Completer completer;

    public SessionScopeCompleter(CommandSession session, Completer completer) {
        this.session = session;
        this.completer = completer;
    }

    @Override
    public int complete(String buffer, int cursor, List<String> candidates) {
        assert (candidates != null);
        try {
            ArrayList<Completion> completions = new ArrayList<Completion>();
            String scope = (String)this.session.get("SCOPE");
            if (scope != null) {
                String[] segments = scope.split(":");
                int max = -1;
                for (String segment : segments) {
                    Completion completion = new Completion(segment, candidates);
                    completion.complete(this.completer, buffer, cursor);
                    max = Math.max(max, completion.cursor);
                    completions.add(completion);
                }
                for (Completion completion : completions) {
                    if (completion.cursor != max) continue;
                    candidates.addAll(completion.candidates);
                }
                return max;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return -1;
    }

    private class Completion {
        public final String scope;
        public final List<String> candidates;
        public int cursor;

        public Completion(String scope, List candidates) {
            assert (scope != null);
            assert (candidates != null);
            this.scope = scope;
            this.candidates = new LinkedList<String>(candidates);
        }

        public void complete(Completer completer, String buffer, int cursor) {
            assert (completer != null);
            buffer = this.scope + ":" + buffer;
            this.cursor = completer.complete(buffer, cursor += (this.scope + ":").length(), this.candidates);
            cursor -= (this.scope + ":").length();
            for (int i = 0; i < this.candidates.size(); ++i) {
                String s = this.candidates.get(i);
                s = s.substring((this.scope + ":").length());
                this.candidates.set(i, s);
            }
        }
    }
}

