/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.apache.felix.webconsole.internal.servlet.Base64;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

final class OsgiManagerHttpContext
implements HttpContext {
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    String realm;
    WebConsoleSecurityProvider securityProvider;
    private final HttpContext base;

    OsgiManagerHttpContext(HttpService httpService, String realm, WebConsoleSecurityProvider securityProvider) {
        this.base = httpService.createDefaultHttpContext();
        this.realm = realm;
        this.securityProvider = securityProvider;
    }

    public String getMimeType(String name) {
        return this.base.getMimeType(name);
    }

    public URL getResource(String name) {
        URL url = this.base.getResource(name);
        if (url == null && name.endsWith("/")) {
            return this.base.getResource(name.substring(0, name.length() - 1));
        }
        return url;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
        int blank;
        if (this.securityProvider == null) {
            return true;
        }
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (authHeader != null && authHeader.length() > 0 && (blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
            String authType = authHeader.substring(0, blank);
            String authInfo = authHeader.substring(blank).trim();
            if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
                try {
                    String srcString = OsgiManagerHttpContext.base64Decode(authInfo);
                    int i = srcString.indexOf(58);
                    String username = srcString.substring(0, i);
                    String password = srcString.substring(i + 1);
                    Object id = this.securityProvider.authenticate(username, password);
                    if (id != null) {
                        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"");
                        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                        return true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + this.realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return false;
    }

    public static String base64Decode(String srcString) {
        byte[] transformed = Base64.decodeBase64(srcString);
        try {
            return new String(transformed, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(transformed);
        }
    }
}

