/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class FileUtil {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private FileUtil() {
    }

    public static boolean buildDirectory(File file) {
        return file.exists() || file.mkdirs();
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackArchive(File theFile, File targetDir) throws IOException {
        if (!theFile.exists()) {
            throw new IOException(theFile.getAbsolutePath() + " does not exist");
        }
        FileInputStream is = new FileInputStream(theFile);
        try {
            FileUtil.unpackArchive(is, targetDir);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackArchive(URL url, File targetDir) throws IOException {
        InputStream is = url.openStream();
        try {
            FileUtil.unpackArchive(is, targetDir);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void unpackArchive(InputStream is, File targetDir) throws IOException {
        if (!FileUtil.buildDirectory(targetDir)) {
            throw new IOException("Could not create directory: " + targetDir);
        }
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(is));
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            File file = new File(targetDir, File.separator + entry.getName());
            if (!FileUtil.buildDirectory(file.getParentFile())) {
                throw new IOException("Could not create directory: " + file.getParentFile());
            }
            if (!entry.isDirectory()) {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                FileUtil.copyInputStream(zip, bos);
                bos.close();
            } else if (!FileUtil.buildDirectory(file)) {
                throw new IOException("Could not create directory: " + file);
            }
            entry = zip.getNextEntry();
        }
    }

    public static boolean deleteFile(File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        boolean result = true;
        if (fileToDelete.isDirectory()) {
            File[] files = fileToDelete.listFiles();
            if (files == null) {
                result = false;
            } else {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    if (file.isDirectory()) {
                        result &= FileUtil.deleteFile(file);
                        continue;
                    }
                    result &= file.delete();
                }
            }
        }
        return result &= fileToDelete.delete();
    }
}

