/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.felix.framework.BundleContextImpl;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.EntryFilterEnumeration;
import org.apache.felix.framework.ExportedPackageImpl;
import org.apache.felix.framework.ExtensionManager;
import org.apache.felix.framework.FelixResolverState;
import org.apache.felix.framework.InvokeHookCallback;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.framework.PackageAdminActivator;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.StartLevelActivator;
import org.apache.felix.framework.StartLevelImpl;
import org.apache.felix.framework.URLHandlersActivator;
import org.apache.felix.framework.URLHandlersBundleStreamHandler;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.ext.SecurityProvider;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Resolver;
import org.apache.felix.framework.resolver.ResolverImpl;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.EventDispatcher;
import org.apache.felix.framework.util.ListenerHookInfoImpl;
import org.apache.felix.framework.util.MapToDictionary;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.ShrinkableCollection;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.ThreadGate;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.R4LibraryClause;
import org.apache.felix.framework.util.manifestparser.RequirementImpl;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.launch.Framework;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Felix
extends BundleImpl
implements Framework {
    static final SecureAction m_secureAction = new SecureAction();
    ExtensionManager m_extensionManager;
    private final Logger m_logger;
    private final Map m_configMap;
    private final Map m_configMutableMap;
    private final FelixResolverState m_resolverState;
    private final FelixResolver m_felixResolver;
    private final Object[] m_bundleLock = new Object[0];
    private final List m_globalLockWaitersList = new ArrayList();
    private Thread m_globalLockThread = null;
    private int m_globalLockCount = 0;
    private final Map m_installRequestMap = new HashMap();
    private final Object[] m_installRequestLock_Priority1 = new Object[0];
    private volatile Map[] m_installedBundles;
    private static final int LOCATION_MAP_IDX = 0;
    private static final int IDENTIFIER_MAP_IDX = 1;
    private volatile List<BundleImpl> m_uninstalledBundles;
    private volatile int m_activeStartLevel = 0;
    private volatile int m_targetStartLevel = 0;
    private BundleCache m_cache = null;
    List m_activatorList = null;
    private long m_nextId = 1L;
    private final Object m_nextIdLock = new Object[0];
    private EventDispatcher m_dispatcher = null;
    private ServiceRegistry m_registry = null;
    private final URLStreamHandler m_bundleStreamHandler;
    private final String[] m_bootPkgs;
    private final boolean[] m_bootPkgWildcards;
    private Thread m_shutdownThread = null;
    private volatile ThreadGate m_shutdownGate = null;
    private SecurityManager m_securityManager = null;
    private volatile SecurityProvider m_securityProvider;
    private volatile URLHandlersActivator m_urlHandlersActivator;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;
    static /* synthetic */ Class class$org$osgi$framework$BundleListener;
    static /* synthetic */ Class class$org$osgi$framework$ServiceListener;
    static /* synthetic */ Class class$org$osgi$framework$FrameworkListener;
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$ListenerHook;
    static /* synthetic */ Class class$org$apache$felix$framework$Felix;

    public Felix(Map configMap) {
        this.m_configMutableMap = new StringMap(false);
        if (configMap != null) {
            for (Map.Entry entry : configMap.entrySet()) {
                this.m_configMutableMap.put(entry.getKey().toString(), entry.getValue());
            }
        }
        this.m_configMap = this.createUnmodifiableMap(this.m_configMutableMap);
        this.m_logger = this.m_configMutableMap.get("felix.log.logger") != null ? (Logger)this.m_configMutableMap.get("felix.log.logger") : new Logger();
        try {
            this.m_logger.setLogLevel(Integer.parseInt((String)this.m_configMutableMap.get("felix.log.level")));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        this.initializeFrameworkProperties();
        String s = this.m_configMap == null ? null : (String)this.m_configMap.get("org.osgi.framework.bootdelegation");
        s = s == null ? "java.*" : new StringBuffer().append(s).append(",java.*").toString();
        StringTokenizer st = new StringTokenizer(s, " ,");
        this.m_bootPkgs = new String[st.countTokens()];
        this.m_bootPkgWildcards = new boolean[this.m_bootPkgs.length];
        for (int i = 0; i < this.m_bootPkgs.length; ++i) {
            s = st.nextToken();
            if (s.equals("*") || s.endsWith(".*")) {
                this.m_bootPkgWildcards[i] = true;
                s = s.substring(0, s.length() - 1);
            }
            this.m_bootPkgs[i] = s;
        }
        this.m_bundleStreamHandler = new URLHandlersBundleStreamHandler(this);
        this.m_resolverState = new FelixResolverState(this.m_logger, (String)this.m_configMap.get("org.osgi.framework.executionenvironment"));
        this.m_felixResolver = new FelixResolver(new ResolverImpl(this.m_logger), this.m_resolverState);
        this.m_extensionManager = new ExtensionManager(this.m_logger, this);
        try {
            this.addModule(this.m_extensionManager.getModule());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    Logger getLogger() {
        return this.m_logger;
    }

    Map getConfig() {
        return this.m_configMap;
    }

    FelixResolver getResolver() {
        return this.m_felixResolver;
    }

    FelixResolverState getResolverState() {
        return this.m_resolverState;
    }

    URLStreamHandler getBundleStreamHandler() {
        return this.m_bundleStreamHandler;
    }

    String[] getBootPackages() {
        return this.m_bootPkgs;
    }

    boolean[] getBootPackageWildcards() {
        return this.m_bootPkgWildcards;
    }

    private Map createUnmodifiableMap(Map mutableMap) {
        Map result = Collections.unmodifiableMap(mutableMap);
        try {
            result.keySet().iterator();
        }
        catch (NoClassDefFoundError ex) {
            return mutableMap;
        }
        return result;
    }

    @Override
    Felix getFramework() {
        return this;
    }

    @Override
    public long getBundleId() {
        return 0L;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    void setLastModified(long l) {
    }

    @Override
    String _getLocation() {
        return "System Bundle";
    }

    @Override
    public int getPersistentState() {
        return 32;
    }

    @Override
    public void setPersistentStateInactive() {
    }

    @Override
    public void setPersistentStateActive() {
    }

    @Override
    public void setPersistentStateUninstalled() {
    }

    @Override
    int getStartLevel(int defaultLevel) {
        return 0;
    }

    @Override
    void setStartLevel(int level) {
        throw new IllegalArgumentException("Cannot set the system bundle's start level.");
    }

    @Override
    public boolean hasPermission(Object obj) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws BundleException {
        block27: {
            this.acquireBundleLock(this, 46);
            try {
                String clean;
                String security = (String)this.m_configMap.get("org.osgi.framework.security");
                if (security != null) {
                    if (System.getSecurityManager() != null) {
                        throw new SecurityException("SecurityManager already installed");
                    }
                    if ("osgi".equalsIgnoreCase(security = security.trim()) || security.length() == 0) {
                        this.m_securityManager = new SecurityManager(){

                            public void checkPermission(Permission perm) {
                                try {
                                    super.checkPermission(perm);
                                }
                                catch (AccessControlException ex) {
                                    throw new SecurityException(ex);
                                }
                            }
                        };
                        System.setSecurityManager(this.m_securityManager);
                    } else {
                        try {
                            this.m_securityManager = (SecurityManager)Class.forName(security).newInstance();
                            System.setSecurityManager(this.m_securityManager);
                        }
                        catch (Throwable t) {
                            throw new SecurityException(new StringBuffer().append("Unable to install custom SecurityManager: ").append(security).toString(), t);
                        }
                    }
                }
                if (this.getState() != 2 && this.getState() != 4) break block27;
                this.m_activatorList = (List)this.m_configMutableMap.get("felix.systembundle.activators");
                this.m_activatorList = this.m_activatorList == null ? new ArrayList() : new ArrayList(this.m_activatorList);
                this.m_dispatcher = EventDispatcher.start(this.m_logger);
                this.m_cache = (BundleCache)this.m_configMutableMap.get("felix.bundlecache.impl");
                if (this.m_cache == null) {
                    try {
                        this.m_cache = new BundleCache(this.m_logger, this.m_configMap);
                    }
                    catch (Exception ex) {
                        this.m_logger.log(1, "Error creating bundle cache.", ex);
                        throw new BundleException("Error creating bundle cache.", ex);
                    }
                }
                if (this.getState() == 2 && (clean = (String)this.m_configMap.get("org.osgi.framework.storage.clean")) != null && clean.equalsIgnoreCase("onFirstInit")) {
                    try {
                        this.m_cache.delete();
                    }
                    catch (Exception ex) {
                        throw new BundleException("Unable to flush bundle cache.", ex);
                    }
                }
                Map[] maps = new Map[]{new HashMap(1), new TreeMap()};
                this.m_uninstalledBundles = new ArrayList<BundleImpl>(0);
                maps[0].put(this._getLocation(), this);
                maps[1].put(new Long(0L), this);
                this.m_installedBundles = maps;
                try {
                    this.m_felixResolver.resolve(this.getCurrentModule());
                }
                catch (ResolveException ex) {
                    throw new BundleException(new StringBuffer().append("Unresolved constraint in System Bundle:").append(ex.getRequirement()).toString());
                }
                BundleArchive[] archives = null;
                try {
                    archives = this.m_cache.getArchives();
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Unable to list saved bundles.", ex);
                    archives = null;
                }
                for (int i = 0; archives != null && i < archives.length; ++i) {
                    try {
                        this.m_nextId = Math.max(this.m_nextId, archives[i].getId() + 1L);
                        if (archives[i].getPersistentState() == 1) {
                            archives[i].closeAndDelete();
                            continue;
                        }
                        this.installBundle(archives[i].getId(), archives[i].getLocation(), archives[i], null);
                        continue;
                    }
                    catch (Exception ex) {
                        this.fireFrameworkEvent(2, this, ex);
                        try {
                            this.m_logger.log(1, new StringBuffer().append("Unable to re-install ").append(archives[i].getLocation()).toString(), ex);
                            continue;
                        }
                        catch (Exception ex2) {
                            this.m_logger.log(1, "Unable to re-install cached bundle.", ex);
                        }
                    }
                }
                this.m_nextId = Math.max(this.m_nextId, this.loadNextId());
                this.m_registry = new ServiceRegistry(this.m_logger, new ServiceRegistry.ServiceRegistryCallbacks(){

                    public void serviceChanged(ServiceEvent event, Dictionary oldProps) {
                        Felix.this.fireServiceEvent(event, oldProps);
                    }
                });
                this.m_dispatcher.setServiceRegistry(this.m_registry);
                this.setBundleStateAndNotify(this, 8);
                this.m_shutdownGate = new ThreadGate();
                this.setActivator(new SystemBundleActivator());
                this.setBundleContext(new BundleContextImpl(this.m_logger, this, this));
                try {
                    m_secureAction.startActivator(this.getActivator(), this._getBundleContext());
                }
                catch (Throwable ex) {
                    EventDispatcher.shutdown();
                    this.m_logger.log(1, "Unable to start system bundle.", ex);
                    throw new RuntimeException("Unable to start system bundle.");
                }
                this.m_logger.setSystemBundleContext(this._getBundleContext());
            }
            finally {
                this.releaseBundleLock(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws BundleException {
        block11: {
            int startLevel = 1;
            this.acquireBundleLock(this, 46);
            try {
                if (this.getState() == 2 || this.getState() == 4) {
                    this.init();
                }
                if (this.getState() != 8) break block11;
                String s = (String)this.m_configMap.get("org.osgi.framework.startlevel.beginning");
                if (s != null) {
                    try {
                        startLevel = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ex) {
                        startLevel = 1;
                    }
                }
                StartLevel sl = null;
                try {
                    sl = (StartLevel)this.getService(this.getBundle(0L), this.getServiceReferences((BundleImpl)this.getBundle(0L), (class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = Felix.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName(), null, true)[0]);
                }
                catch (InvalidSyntaxException ex) {
                    // empty catch block
                }
                if (sl instanceof StartLevelImpl) {
                    ((StartLevelImpl)sl).setStartLevelAndWait(startLevel);
                } else {
                    sl.setStartLevel(startLevel);
                }
                this.setBundleStateAndNotify(this, 32);
            }
            finally {
                this.releaseBundleLock(this);
            }
        }
        this.fireBundleEvent(2, this);
        this.fireFrameworkEvent(1, this, null);
    }

    @Override
    public void start(int options) throws BundleException {
        this.start();
    }

    @Override
    public void stop() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        this.stopBundle(this, true);
    }

    @Override
    public void stop(int options) throws BundleException {
        this.stop();
    }

    @Override
    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative.");
        }
        ThreadGate gate = this.m_shutdownGate;
        boolean open = false;
        if (gate != null) {
            open = gate.await(timeout);
        }
        FrameworkEvent event = open && gate.getMessage() != null ? (FrameworkEvent)gate.getMessage() : (!open && gate != null ? new FrameworkEvent(512, this, null) : new FrameworkEvent(64, this, null));
        return event;
    }

    @Override
    public void uninstall() throws BundleException {
        throw new BundleException("Cannot uninstall the system bundle.");
    }

    @Override
    public void update() throws BundleException {
        this.update(null);
    }

    @Override
    public void update(InputStream is) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ex) {
            this.m_logger.log(2, "Exception closing input stream.", ex);
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Felix.this.acquireBundleLock(Felix.this, 40);
                    Felix.this.m_shutdownGate.setMessage(new FrameworkEvent(128, Felix.this, null));
                    int oldState = Felix.this.getState();
                    try {
                        Felix.this.stop();
                    }
                    catch (BundleException ex) {
                        Felix.this.m_logger.log(2, "Exception stopping framework.", ex);
                    }
                    finally {
                        Felix.this.releaseBundleLock(Felix.this);
                    }
                    try {
                        Felix.this.waitForStop(0L);
                    }
                    catch (InterruptedException ex) {
                        Felix.this.m_logger.log(2, "Did not wait for framework to stop.", ex);
                    }
                    try {
                        switch (oldState) {
                            case 8: {
                                Felix.this.init();
                                break;
                            }
                            case 32: {
                                Felix.this.start();
                            }
                        }
                    }
                    catch (BundleException ex) {
                        Felix.this.m_logger.log(2, "Exception restarting framework.", ex);
                    }
                }
                catch (Exception ex) {
                    Felix.this.m_logger.log(2, "Cannot update an inactive framework.");
                }
            }
        }).start();
    }

    @Override
    public String toString() {
        return new StringBuffer().append(this.getSymbolicName()).append(" [").append(this.getBundleId()).append("]").toString();
    }

    int getActiveStartLevel() {
        return this.m_activeStartLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActiveStartLevel(int requestedLevel) {
        Bundle[] bundles = null;
        this.m_targetStartLevel = requestedLevel;
        if (this.m_targetStartLevel != this.m_activeStartLevel) {
            boolean lowering = this.m_targetStartLevel < this.m_activeStartLevel;
            boolean locked = this.acquireGlobalLock();
            if (!locked) {
                throw new IllegalStateException("Unable to acquire global lock to create bundle snapshot.");
            }
            try {
                bundles = this.getBundles();
                Arrays.sort(bundles, new BundleComparator(lowering));
            }
            finally {
                this.releaseGlobalLock();
            }
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                BundleImpl impl = (BundleImpl)bundles[i];
                if (impl.getBundleId() == 0L) continue;
                try {
                    this.acquireBundleLock(impl, 62);
                }
                catch (IllegalStateException ex) {
                    if (impl.getState() == 1) continue;
                    this.fireFrameworkEvent(2, impl, ex);
                    this.m_logger.log(1, new StringBuffer().append("Error locking ").append(impl._getLocation()).toString(), ex);
                    continue;
                }
                try {
                    if ((impl.getPersistentState() == 32 || impl.getPersistentState() == 8) && impl.getStartLevel(this.getInitialBundleStartLevel()) <= this.m_targetStartLevel) {
                        if (this.m_activeStartLevel != impl.getStartLevel(this.getInitialBundleStartLevel())) {
                            this.m_activeStartLevel = impl.getStartLevel(this.getInitialBundleStartLevel());
                        }
                        try {
                            int options = 1;
                            options = impl.getPersistentState() == 8 ? options | 2 : options;
                            this.startBundle(impl, options);
                        }
                        catch (Throwable th) {
                            this.fireFrameworkEvent(2, impl, th);
                            this.m_logger.log(1, new StringBuffer().append("Error starting ").append(impl._getLocation()).toString(), th);
                        }
                    } else if ((impl.getState() == 32 || impl.getState() == 8) && impl.getStartLevel(this.getInitialBundleStartLevel()) > this.m_targetStartLevel) {
                        if (this.m_activeStartLevel != impl.getStartLevel(this.getInitialBundleStartLevel())) {
                            this.m_activeStartLevel = impl.getStartLevel(this.getInitialBundleStartLevel());
                        }
                        try {
                            this.stopBundle(impl, false);
                        }
                        catch (Throwable th) {
                            this.fireFrameworkEvent(2, impl, th);
                            this.m_logger.log(1, new StringBuffer().append("Error stopping ").append(impl._getLocation()).toString(), th);
                        }
                    }
                }
                finally {
                    this.releaseBundleLock(impl);
                }
                bundles[i] = null;
            }
            this.m_activeStartLevel = this.m_targetStartLevel;
        }
        if (this.getState() == 32) {
            this.fireFrameworkEvent(8, this, null);
        }
    }

    int getInitialBundleStartLevel() {
        String s = (String)this.m_configMap.get("felix.startlevel.bundle");
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                return i > 0 ? i : 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    void setInitialBundleStartLevel(int startLevel) {
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be greater than zero.");
        }
        this.m_configMutableMap.put("felix.startlevel.bundle", Integer.toString(startLevel));
    }

    int getBundleStartLevel(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException("Bundle is uninstalled.");
        }
        return ((BundleImpl)bundle).getStartLevel(this.getInitialBundleStartLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBundleStartLevel(Bundle bundle, int startLevel) {
        Throwable rethrow;
        block12: {
            BundleImpl impl = (BundleImpl)bundle;
            try {
                this.acquireBundleLock(impl, 62);
            }
            catch (IllegalStateException ex) {
                this.fireFrameworkEvent(2, impl, ex);
                this.m_logger.log(1, new StringBuffer().append("Error locking ").append(impl._getLocation()).toString(), ex);
                return;
            }
            rethrow = null;
            try {
                if (startLevel >= 1) {
                    try {
                        if ((impl.getPersistentState() == 32 || impl.getPersistentState() == 8) && startLevel <= this.m_targetStartLevel) {
                            int options = 1;
                            options = impl.getPersistentState() == 8 ? options | 2 : options;
                            this.startBundle(impl, options);
                        } else if ((impl.getState() == 32 || impl.getState() == 8) && startLevel > this.m_targetStartLevel) {
                            this.stopBundle(impl, false);
                        }
                        break block12;
                    }
                    catch (Throwable th) {
                        rethrow = th;
                        this.m_logger.log(1, "Error starting/stopping bundle.", th);
                    }
                    break block12;
                }
                this.m_logger.log(2, "Bundle start level must be greater than zero.");
            }
            finally {
                this.releaseBundleLock(impl);
            }
        }
        if (rethrow != null) {
            this.fireFrameworkEvent(2, bundle, rethrow);
        }
    }

    boolean isBundlePersistentlyStarted(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException("Bundle is uninstalled.");
        }
        return ((BundleImpl)bundle).getPersistentState() == 32 || ((BundleImpl)bundle).getPersistentState() == 8;
    }

    boolean isBundleActivationPolicyUsed(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException("Bundle is uninstalled.");
        }
        return ((BundleImpl)bundle).isDeclaredActivationPolicyUsed();
    }

    Dictionary getBundleHeaders(BundleImpl bundle, String locale) {
        return new MapToDictionary(bundle.getCurrentLocalizedHeader(locale));
    }

    URL getBundleResource(BundleImpl bundle, String name) {
        if (bundle.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        if (Util.isFragment(bundle.getCurrentModule())) {
            return null;
        }
        return bundle.getCurrentModule().getResourceByDelegation(name);
    }

    Enumeration getBundleResources(BundleImpl bundle, String name) {
        if (bundle.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        if (Util.isFragment(bundle.getCurrentModule())) {
            return null;
        }
        return bundle.getCurrentModule().getResourcesByDelegation(name);
    }

    URL getBundleEntry(BundleImpl bundle, String name) {
        EntryFilterEnumeration enumeration;
        if (bundle.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        URL url = bundle.getCurrentModule().getEntry(name);
        if (url == null && name.endsWith("/") && !name.equals("/") && (enumeration = new EntryFilterEnumeration(bundle, false, name, "*", true, true)).hasMoreElements()) {
            URL entryURL = (URL)enumeration.nextElement();
            try {
                url = new URL(entryURL, name.charAt(0) == '/' ? name : new StringBuffer().append("/").append(name).toString());
            }
            catch (MalformedURLException ex) {
                url = null;
            }
        }
        return url;
    }

    Enumeration getBundleEntryPaths(BundleImpl bundle, String path) {
        if (bundle.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        EntryFilterEnumeration enumeration = new EntryFilterEnumeration(bundle, false, path, "*", false, false);
        return !enumeration.hasMoreElements() ? null : enumeration;
    }

    Enumeration findBundleEntries(BundleImpl bundle, String path, String filePattern, boolean recurse) {
        this.resolveBundles(new Bundle[]{bundle});
        EntryFilterEnumeration enumeration = new EntryFilterEnumeration(bundle, true, path, filePattern, recurse, true);
        return !enumeration.hasMoreElements() ? null : enumeration;
    }

    ServiceReference[] getBundleRegisteredServices(BundleImpl bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        ServiceReference[] refs = this.m_registry.getRegisteredServices(bundle);
        return refs;
    }

    ServiceReference[] getBundleServicesInUse(Bundle bundle) {
        ServiceReference[] refs = this.m_registry.getServicesInUse(bundle);
        return refs;
    }

    boolean bundleHasPermission(BundleImpl bundle, Object obj) {
        if (bundle.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        if (System.getSecurityManager() != null) {
            try {
                return obj instanceof Permission ? this.impliesBundlePermission((BundleProtectionDomain)bundle.getProtectionDomain(), (Permission)obj, true) : false;
            }
            catch (Exception ex) {
                this.m_logger.log(2, "Exception while evaluating the permission.", ex);
                return false;
            }
        }
        return true;
    }

    Class loadBundleClass(BundleImpl bundle, String name) throws ClassNotFoundException {
        if (bundle.getState() == 1) {
            throw new IllegalStateException("Bundle is uninstalled");
        }
        if (Util.isFragment(bundle.getCurrentModule())) {
            throw new ClassNotFoundException("Fragments cannot load classes.");
        }
        if (bundle.getState() == 2) {
            try {
                this.resolveBundle(bundle);
            }
            catch (BundleException ex) {
                this.fireFrameworkEvent(2, bundle, ex);
                throw new ClassNotFoundException(name, ex);
            }
        }
        return bundle.getCurrentModule().getClassByDelegation(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startBundle(BundleImpl bundle, int options) throws BundleException {
        int eventType;
        try {
            this.acquireBundleLock(bundle, 46);
        }
        catch (IllegalStateException ex) {
            if (bundle.getState() == 1) {
                throw new IllegalStateException("Cannot start an uninstalled bundle.");
            }
            throw new BundleException(new StringBuffer().append("Bundle ").append(bundle).append(" cannot be started, since it is either starting or stopping.").toString());
        }
        boolean wasDeferred = bundle.isDeclaredActivationPolicyUsed() && bundle.getCurrentModule().getDeclaredActivationPolicy() == 1;
        bundle.setDeclaredActivationPolicyUsed((options & 2) != 0);
        BundleException rethrow = null;
        try {
            if (bundle.isExtension()) {
                return;
            }
            if (Util.isFragment(bundle.getCurrentModule())) {
                throw new BundleException("Fragment bundles can not be started.");
            }
            if ((options & 1) == 0) {
                if ((options & 2) != 0) {
                    bundle.setPersistentStateStarting();
                } else {
                    bundle.setPersistentStateActive();
                }
            }
            if (bundle.getStartLevel(this.getInitialBundleStartLevel()) > this.m_targetStartLevel) {
                if ((options & 1) != 0) {
                    throw new BundleException(new StringBuffer().append("Cannot start bundle ").append(bundle).append(" because its start level is ").append(bundle.getStartLevel(this.getInitialBundleStartLevel())).append(", which is greater than the framework's start level of ").append(this.m_targetStartLevel).append(".").toString());
                }
                return;
            }
            switch (bundle.getState()) {
                case 1: {
                    throw new IllegalStateException("Cannot start an uninstalled bundle.");
                }
                case 8: {
                    if (wasDeferred) break;
                    throw new BundleException(new StringBuffer().append("Bundle ").append(bundle).append(" cannot be started, since it is starting.").toString());
                }
                case 16: {
                    throw new BundleException(new StringBuffer().append("Bundle ").append(bundle).append(" cannot be started, since it is stopping.").toString());
                }
                case 32: {
                    return;
                }
                case 2: {
                    this.resolveBundle(bundle);
                }
                case 4: {
                    bundle.setBundleContext(new BundleContextImpl(this.m_logger, this, bundle));
                    this.setBundleStateAndNotify(bundle, 8);
                }
            }
            if (!bundle.isDeclaredActivationPolicyUsed() || bundle.getCurrentModule().getDeclaredActivationPolicy() != 1 || ((ModuleImpl)bundle.getCurrentModule()).isActivationTriggered()) {
                eventType = 2;
                try {
                    this.activateBundle(bundle, false);
                }
                catch (BundleException ex) {
                    rethrow = ex;
                }
            } else {
                eventType = 512;
            }
        }
        finally {
            this.releaseBundleLock(bundle);
        }
        if (rethrow != null) {
            this.fireBundleEvent(4, bundle);
            throw rethrow;
        }
        this.fireBundleEvent(eventType, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activateBundle(BundleImpl bundle, boolean fireEvent) throws BundleException {
        try {
            this.acquireBundleLock(bundle, 40);
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("Activation only occurs for bundles in STARTING state.");
        }
        try {
            if (bundle.getState() == 32 || bundle.getStartLevel(this.getInitialBundleStartLevel()) > this.m_targetStartLevel) {
                return;
            }
            this.fireBundleEvent(128, bundle);
            try {
                bundle.setActivator(this.createBundleActivator(bundle));
                if (bundle.getActivator() != null) {
                    m_secureAction.startActivator(bundle.getActivator(), bundle._getBundleContext());
                }
                this.setBundleStateAndNotify(bundle, 32);
            }
            catch (Throwable th2) {
                Exception th2;
                this.fireBundleEvent(256, bundle);
                this.setBundleStateAndNotify(bundle, 4);
                bundle.setActivator(null);
                this.m_registry.unregisterServices(bundle);
                this.m_registry.ungetServices(bundle);
                this.m_dispatcher.removeListeners(bundle);
                ((BundleContextImpl)bundle._getBundleContext()).invalidate();
                bundle.setBundleContext(null);
                if (th2 instanceof BundleException) {
                    throw (BundleException)th2;
                }
                if (System.getSecurityManager() != null && th2 instanceof PrivilegedActionException) {
                    th2 = ((PrivilegedActionException)th2).getException();
                }
                throw new BundleException(new StringBuffer().append("Activator start error in bundle ").append(bundle).append(".").toString(), th2);
            }
        }
        finally {
            this.releaseBundleLock(bundle);
        }
        if (fireEvent) {
            this.fireBundleEvent(2, bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBundle(BundleImpl bundle, InputStream is) throws BundleException {
        try {
            this.acquireBundleLock(bundle, 38);
        }
        catch (IllegalStateException ex) {
            if (bundle.getState() == 1) {
                throw new IllegalStateException("Cannot update an uninstalled bundle.");
            }
            throw new BundleException(new StringBuffer().append("Bundle ").append(bundle).append(" cannot be update, since it is either starting or stopping.").toString());
        }
        try {
            Throwable rethrow = null;
            int oldState = bundle.getState();
            String updateLocation = (String)bundle.getCurrentModule().getHeaders().get("Bundle-UpdateLocation");
            if (updateLocation == null) {
                updateLocation = bundle._getLocation();
            }
            if (oldState == 32) {
                this.stopBundle(bundle, false);
            }
            try {
                boolean locked = this.acquireGlobalLock();
                if (!locked) {
                    throw new BundleException("Cannot acquire global lock to update the bundle.");
                }
                boolean wasExtension = bundle.isExtension();
                try {
                    bundle.revise(updateLocation, is);
                }
                finally {
                    this.releaseGlobalLock();
                }
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new AdminPermission(bundle, "lifecycle"));
                    }
                    if (!wasExtension && bundle.isExtension()) {
                        this.m_extensionManager.addExtensionBundle(this, bundle);
                        this.m_resolverState.refreshSystemBundleModule(this.m_extensionManager.getModule());
                        this.setBundleStateAndNotify(bundle, 4);
                    } else if (wasExtension) {
                        this.setBundleStateAndNotify(bundle, 2);
                    }
                }
                catch (Throwable ex) {
                    try {
                        bundle.rollbackRevise();
                    }
                    catch (Exception busted) {
                        this.m_logger.log(1, "Unable to rollback.", busted);
                    }
                    throw ex;
                }
            }
            catch (Throwable ex) {
                this.m_logger.log(1, "Unable to update the bundle.", ex);
                rethrow = ex;
            }
            if (rethrow == null) {
                bundle.setLastModified(System.currentTimeMillis());
                if (!bundle.isExtension()) {
                    this.setBundleStateAndNotify(bundle, 2);
                } else {
                    this.m_extensionManager.startExtensionBundle(this, bundle);
                }
                this.fireBundleEvent(64, bundle);
                this.fireBundleEvent(8, bundle);
                boolean locked = this.acquireGlobalLock();
                if (locked) {
                    try {
                        if (!bundle.isUsed() && !bundle.isExtension()) {
                            try {
                                this.refreshPackages(new BundleImpl[]{bundle});
                            }
                            catch (Exception ex) {
                                this.m_logger.log(1, "Unable to immediately purge the bundle revisions.", ex);
                            }
                        }
                    }
                    finally {
                        this.releaseGlobalLock();
                    }
                }
            }
            if (oldState == 32 && Util.isFragment(bundle.getCurrentModule())) {
                bundle.setPersistentStateInactive();
                this.m_logger.log(2, new StringBuffer().append("Previously active bundle was updated to a fragment, resetting state to inactive: ").append(bundle).toString());
            } else if (oldState == 32) {
                this.startBundle(bundle, 1);
            }
            if (rethrow != null) {
                if (rethrow instanceof AccessControlException) {
                    throw (AccessControlException)rethrow;
                }
                if (rethrow instanceof BundleException) {
                    throw (BundleException)rethrow;
                }
                throw new BundleException(new StringBuffer().append("Update of bundle ").append(bundle).append(" failed.").toString(), rethrow);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Unable to close input stream.", ex);
            }
            this.releaseBundleLock(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopBundle(BundleImpl bundle, boolean record) throws BundleException {
        try {
            this.acquireBundleLock(bundle, 46);
        }
        catch (IllegalStateException ex) {
            if (bundle.getState() == 1) {
                throw new IllegalStateException("Cannot stop an uninstalled bundle.");
            }
            throw new BundleException(new StringBuffer().append("Bundle ").append(bundle).append(" cannot be stopped since it is already stopping.").toString());
        }
        try {
            Throwable rethrow = null;
            if (record) {
                bundle.setPersistentStateInactive();
            }
            if (!this.isBundlePersistentlyStarted(bundle)) {
                bundle.setDeclaredActivationPolicyUsed(false);
            }
            if (Util.isFragment(bundle.getCurrentModule())) {
                throw new BundleException(new StringBuffer().append("Fragment bundles can not be stopped: ").append(bundle).toString());
            }
            boolean wasActive = false;
            switch (bundle.getState()) {
                case 1: {
                    throw new IllegalStateException("Cannot stop an uninstalled bundle.");
                }
                case 8: {
                    if (!bundle.isDeclaredActivationPolicyUsed() || bundle.getCurrentModule().getDeclaredActivationPolicy() == 1) break;
                    throw new BundleException("Stopping a starting or stopping bundle is currently not supported.");
                }
                case 16: {
                    throw new BundleException("Stopping a starting or stopping bundle is currently not supported.");
                }
                case 2: 
                case 4: {
                    return;
                }
                case 32: {
                    wasActive = true;
                }
            }
            this.setBundleStateAndNotify(bundle, 16);
            this.fireBundleEvent(256, bundle);
            if (wasActive || bundle.getBundleId() == 0L) {
                try {
                    if (bundle.getActivator() != null) {
                        m_secureAction.stopActivator(bundle.getActivator(), bundle._getBundleContext());
                    }
                }
                catch (Throwable th) {
                    this.m_logger.log(1, "Error stopping bundle.", th);
                    rethrow = th;
                }
            }
            if (bundle.getBundleId() != 0L) {
                bundle.setActivator(null);
                this.m_registry.unregisterServices(bundle);
                this.m_registry.ungetServices(bundle);
                this.m_dispatcher.removeListeners(bundle);
                ((BundleContextImpl)bundle._getBundleContext()).invalidate();
                bundle.setBundleContext(null);
                this.setBundleStateAndNotify(bundle, 4);
            }
            if (rethrow != null) {
                if (rethrow instanceof BundleException) {
                    throw (BundleException)rethrow;
                }
                if (System.getSecurityManager() != null && rethrow instanceof PrivilegedActionException) {
                    rethrow = ((PrivilegedActionException)rethrow).getException();
                }
                throw new BundleException(new StringBuffer().append("Activator stop error in bundle ").append(bundle).append(".").toString(), rethrow);
            }
        }
        finally {
            this.releaseBundleLock(bundle);
        }
        this.fireBundleEvent(4, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstallBundle(BundleImpl bundle) throws BundleException {
        try {
            this.acquireBundleLock(bundle, 46);
        }
        catch (IllegalStateException ex) {
            if (bundle.getState() == 1) {
                throw new IllegalStateException("Cannot uninstall an uninstalled bundle.");
            }
            throw new BundleException(new StringBuffer().append("Bundle ").append(bundle).append(" cannot be uninstalled since it is stopping.").toString());
        }
        try {
            if (!bundle.isExtension() && bundle.getState() == 32) {
                try {
                    this.stopBundle(bundle, true);
                }
                catch (BundleException ex) {
                    this.fireFrameworkEvent(2, bundle, ex);
                }
            }
            BundleImpl target = null;
            boolean locked = this.acquireGlobalLock();
            if (!locked) {
                throw new IllegalStateException("Unable to acquire global lock to remove bundle.");
            }
            try {
                Map[] maps = new Map[]{new HashMap(this.m_installedBundles[0]), new TreeMap(this.m_installedBundles[1])};
                target = (BundleImpl)maps[0].remove(bundle._getLocation());
                maps[1].remove(new Long(target.getBundleId()));
                this.m_installedBundles = maps;
                if (target != null) {
                    bundle.setPersistentStateUninstalled();
                    this.rememberUninstalledBundle(bundle);
                }
            }
            finally {
                this.releaseGlobalLock();
            }
            if (target == null) {
                this.m_logger.log(1, "Unable to remove bundle from installed map!");
            }
            this.setBundleStateAndNotify(bundle, 2);
            this.fireBundleEvent(64, bundle);
            this.setBundleStateAndNotify(bundle, 1);
            bundle.setLastModified(System.currentTimeMillis());
            bundle.cleanAfterUninstall();
        }
        finally {
            this.releaseBundleLock(bundle);
        }
        this.fireBundleEvent(16, bundle);
        boolean locked = this.acquireGlobalLock();
        if (locked) {
            try {
                if (!bundle.isUsed()) {
                    try {
                        this.refreshPackages(new BundleImpl[]{bundle});
                    }
                    catch (Exception ex) {
                        this.m_logger.log(1, "Unable to immediately garbage collect the bundle.", ex);
                    }
                }
            }
            finally {
                this.releaseGlobalLock();
            }
        }
    }

    String getProperty(String key) {
        String val = (String)this.m_configMap.get(key);
        return val == null ? System.getProperty(key) : val;
    }

    Bundle installBundle(String location, InputStream is) throws BundleException {
        return this.installBundle(-1L, location, null, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle installBundle(long id, String location, BundleArchive ba, InputStream is) throws BundleException {
        BundleImpl bundle = null;
        this.acquireInstallLock(location);
        try {
            boolean locked;
            boolean isNew;
            if (this.getState() == 16 || this.getState() == 1) {
                throw new BundleException("The framework has been shutdown.");
            }
            bundle = (BundleImpl)this.getBundle(location);
            if (bundle != null) {
                BundleImpl bundleImpl = bundle;
                return bundleImpl;
            }
            boolean bl = isNew = ba == null;
            if (isNew) {
                id = this.getNextId();
                try {
                    ba = this.m_cache.create(id, location, is);
                }
                catch (Exception ex) {
                    throw new BundleException(new StringBuffer().append("Unable to cache bundle: ").append(location).toString(), ex);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ex) {
                        this.m_logger.log(1, "Unable to close input stream.", ex);
                    }
                }
            }
            try {
                if (ba.getRevisionCount() > 1) {
                    ba.purge();
                }
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Could not purge bundle.", ex);
            }
            try {
                locked = this.acquireGlobalLock();
                if (!locked) {
                    throw new BundleException("Unable to acquire the global lock to install the bundle.");
                }
                try {
                    bundle = new BundleImpl(this, ba);
                }
                finally {
                    this.releaseGlobalLock();
                }
                if (!bundle.isExtension()) {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new AdminPermission(bundle, "lifecycle"));
                    }
                } else {
                    this.m_extensionManager.addExtensionBundle(this, bundle);
                    this.m_resolverState.refreshSystemBundleModule(this.m_extensionManager.getModule());
                }
            }
            catch (Throwable ex) {
                if (isNew) {
                    try {
                        if (bundle != null) {
                            bundle.closeAndDelete();
                        } else if (ba != null) {
                            ba.closeAndDelete();
                        }
                    }
                    catch (Exception ex1) {
                        this.m_logger.log(1, "Could not remove from cache.", ex1);
                    }
                }
                if (ex instanceof BundleException) {
                    throw (BundleException)ex;
                }
                if (ex instanceof AccessControlException) {
                    throw (AccessControlException)ex;
                }
                throw new BundleException("Could not create bundle object.", ex);
            }
            if (isNew) {
                bundle.setStartLevel(this.getInitialBundleStartLevel());
                bundle.setLastModified(System.currentTimeMillis());
            }
            if (!(locked = this.acquireGlobalLock())) {
                throw new IllegalStateException("Unable to acquire global lock to add bundle.");
            }
            try {
                Map[] maps = new Map[]{new HashMap(this.m_installedBundles[0]), new TreeMap(this.m_installedBundles[1])};
                maps[0].put(location, bundle);
                maps[1].put(new Long(bundle.getBundleId()), bundle);
                this.m_installedBundles = maps;
            }
            finally {
                this.releaseGlobalLock();
            }
            if (bundle.isExtension()) {
                this.m_extensionManager.startExtensionBundle(this, bundle);
            }
        }
        finally {
            this.releaseInstallLock(location);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                this.m_logger.log(1, "Unable to close input stream.", ex);
            }
        }
        this.fireBundleEvent(1, bundle);
        return bundle;
    }

    Bundle getBundle(String location) {
        return (Bundle)this.m_installedBundles[0].get(location);
    }

    Bundle getBundle(long id) {
        BundleImpl bundle = (BundleImpl)this.m_installedBundles[1].get(new Long(id));
        if (bundle != null) {
            return bundle;
        }
        List<BundleImpl> uninstalledBundles = this.m_uninstalledBundles;
        for (int i = 0; uninstalledBundles != null && i < uninstalledBundles.size(); ++i) {
            if (uninstalledBundles.get(i).getBundleId() != id) continue;
            return uninstalledBundles.get(i);
        }
        return null;
    }

    Bundle[] getBundles() {
        Map bundles = this.m_installedBundles[1];
        if (bundles.isEmpty()) {
            return null;
        }
        return bundles.values().toArray(new Bundle[bundles.size()]);
    }

    void addBundleListener(Bundle bundle, BundleListener l) {
        this.m_dispatcher.addListener(bundle, class$org$osgi$framework$BundleListener == null ? (class$org$osgi$framework$BundleListener = Felix.class$("org.osgi.framework.BundleListener")) : class$org$osgi$framework$BundleListener, l, null);
    }

    void removeBundleListener(Bundle bundle, BundleListener l) {
        this.m_dispatcher.removeListener(bundle, class$org$osgi$framework$BundleListener == null ? (class$org$osgi$framework$BundleListener = Felix.class$("org.osgi.framework.BundleListener")) : class$org$osgi$framework$BundleListener, l);
    }

    void addServiceListener(Bundle bundle, ServiceListener l, String f) throws InvalidSyntaxException {
        int i;
        Filter oldFilter = this.m_dispatcher.addListener(bundle, class$org$osgi$framework$ServiceListener == null ? (class$org$osgi$framework$ServiceListener = Felix.class$("org.osgi.framework.ServiceListener")) : class$org$osgi$framework$ServiceListener, l, f == null ? null : FrameworkUtil.createFilter(f));
        List listenerHooks = this.m_registry.getListenerHooks();
        if (oldFilter != null) {
            Set<ListenerHookInfoImpl> removed = Collections.singleton(new ListenerHookInfoImpl(((BundleImpl)bundle)._getBundleContext(), l, ((Object)oldFilter).toString(), true));
            ListenerHookRemovedCallback removedCallback = new ListenerHookRemovedCallback(removed);
            for (i = 0; i < listenerHooks.size(); ++i) {
                this.m_registry.invokeHook((ServiceReference)listenerHooks.get(i), this, removedCallback);
            }
        }
        final Set<ListenerHookInfoImpl> added = Collections.singleton(new ListenerHookInfoImpl(((BundleImpl)bundle)._getBundleContext(), l, f, false));
        InvokeHookCallback addedCallback = new InvokeHookCallback(){

            public void invokeHook(Object hook) {
                ((ListenerHook)hook).added(added);
            }
        };
        for (i = 0; i < listenerHooks.size(); ++i) {
            this.m_registry.invokeHook((ServiceReference)listenerHooks.get(i), this, addedCallback);
        }
    }

    void removeServiceListener(Bundle bundle, ServiceListener l) {
        ListenerHook.ListenerInfo listener = this.m_dispatcher.removeListener(bundle, class$org$osgi$framework$ServiceListener == null ? (class$org$osgi$framework$ServiceListener = Felix.class$("org.osgi.framework.ServiceListener")) : class$org$osgi$framework$ServiceListener, l);
        if (listener != null) {
            List listenerHooks = this.m_registry.getListenerHooks();
            Set<ListenerHook.ListenerInfo> c = Collections.singleton(listener);
            ListenerHookRemovedCallback callback = new ListenerHookRemovedCallback(c);
            for (int i = 0; i < listenerHooks.size(); ++i) {
                this.m_registry.invokeHook((ServiceReference)listenerHooks.get(i), this, callback);
            }
        }
    }

    void addFrameworkListener(Bundle bundle, FrameworkListener l) {
        this.m_dispatcher.addListener(bundle, class$org$osgi$framework$FrameworkListener == null ? (class$org$osgi$framework$FrameworkListener = Felix.class$("org.osgi.framework.FrameworkListener")) : class$org$osgi$framework$FrameworkListener, l, null);
    }

    void removeFrameworkListener(Bundle bundle, FrameworkListener l) {
        this.m_dispatcher.removeListener(bundle, class$org$osgi$framework$FrameworkListener == null ? (class$org$osgi$framework$FrameworkListener = Felix.class$("org.osgi.framework.FrameworkListener")) : class$org$osgi$framework$FrameworkListener, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRegistration registerService(BundleImpl bundle, String[] classNames, Object svcObj, Dictionary dict) {
        if (classNames == null) {
            throw new NullPointerException("Service class names cannot be null.");
        }
        if (svcObj == null) {
            throw new IllegalArgumentException("Service object cannot be null.");
        }
        try {
            this.acquireBundleLock(bundle, 40);
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("Can only register services while bundle is active or activating.");
        }
        ServiceRegistration reg = null;
        try {
            if (!(svcObj instanceof ServiceFactory)) {
                for (int i = 0; i < classNames.length; ++i) {
                    Class clazz = Util.loadClassUsingClass(svcObj.getClass(), classNames[i], m_secureAction);
                    if (clazz == null) {
                        throw new IllegalArgumentException(new StringBuffer().append("Cannot cast service: ").append(classNames[i]).toString());
                    }
                    if (clazz.isAssignableFrom(svcObj.getClass())) continue;
                    throw new IllegalArgumentException(new StringBuffer().append("Service object is not an instance of \"").append(classNames[i]).append("\".").toString());
                }
            }
            reg = this.m_registry.registerService(bundle, classNames, svcObj, dict);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
        if (ServiceRegistry.isHook(classNames, class$org$osgi$framework$hooks$service$ListenerHook == null ? (class$org$osgi$framework$hooks$service$ListenerHook = Felix.class$("org.osgi.framework.hooks.service.ListenerHook")) : class$org$osgi$framework$hooks$service$ListenerHook, svcObj)) {
            this.m_registry.invokeHook(reg.getReference(), this, new InvokeHookCallback(){

                public void invokeHook(Object hook) {
                    ((ListenerHook)hook).added(Felix.this.m_dispatcher.wrapAllServiceListeners(false));
                }
            });
        }
        return reg;
    }

    ServiceReference[] getServiceReferences(final BundleImpl bundle, final String className, final String expr, final boolean checkAssignable) throws InvalidSyntaxException {
        SimpleFilter filter = null;
        if (expr != null) {
            try {
                filter = SimpleFilter.parse(expr);
            }
            catch (Exception ex) {
                throw new InvalidSyntaxException(ex.getMessage(), expr);
            }
        }
        final List refList = this.m_registry.getServiceReferences(className, filter);
        if (checkAssignable) {
            for (int refIdx = 0; refList != null && refIdx < refList.size(); ++refIdx) {
                ServiceReference ref = (ServiceReference)refList.get(refIdx);
                if (Util.isServiceAssignable(bundle, ref)) continue;
                refList.remove(refIdx);
                --refIdx;
            }
        }
        List findHooks = this.m_registry.getFindHooks();
        InvokeHookCallback callback = new InvokeHookCallback(){

            public void invokeHook(Object hook) {
                ((FindHook)hook).find(bundle._getBundleContext(), className, expr, !checkAssignable, new ShrinkableCollection(refList));
            }
        };
        for (int i = 0; i < findHooks.size(); ++i) {
            this.m_registry.invokeHook((ServiceReference)findHooks.get(i), this, callback);
        }
        if (refList.size() > 0) {
            return refList.toArray(new ServiceReference[refList.size()]);
        }
        return null;
    }

    ServiceReference[] getAllowedServiceReferences(BundleImpl bundle, String className, String expr, boolean checkAssignable) throws InvalidSyntaxException {
        ServiceReference[] refs = this.getServiceReferences(bundle, className, expr, checkAssignable);
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || refs == null) {
            return refs;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (int i = 0; i < refs.length; ++i) {
            try {
                sm.checkPermission(new ServicePermission(refs[i], "get"));
                result.add(refs[i]);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    Object getService(Bundle bundle, ServiceReference ref) {
        try {
            return this.m_registry.getService(bundle, ref);
        }
        catch (ServiceException ex) {
            this.fireFrameworkEvent(2, ref.getBundle(), ex);
            return null;
        }
    }

    boolean ungetService(Bundle bundle, ServiceReference ref) {
        return this.m_registry.ungetService(bundle, ref);
    }

    File getDataFile(BundleImpl bundle, String s) {
        try {
            if (bundle == this) {
                return this.m_cache.getSystemBundleDataFile(s);
            }
            return bundle.getArchive().getDataFile(s);
        }
        catch (Exception ex) {
            this.m_logger.log(1, ex.getMessage());
            return null;
        }
    }

    Bundle getBundle(Class clazz) {
        if (clazz.getClassLoader() instanceof BundleReference) {
            BundleReference br = (BundleReference)((Object)clazz.getClassLoader());
            return br.getBundle() instanceof BundleImpl && ((BundleImpl)br.getBundle()).getFramework() == this ? br.getBundle() : null;
        }
        try {
            if (!clazz.getName().startsWith("java.")) {
                return this.m_extensionManager.getModule().getClassByDelegation(clazz.getName()) == clazz ? this : null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    ExportedPackage[] getExportedPackages(String pkgName) {
        ArrayList<Directive> dirs = new ArrayList<Directive>(0);
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        attrs.add(new Attribute("package", pkgName, false));
        RequirementImpl req = new RequirementImpl(null, "package", dirs, attrs);
        Set<Capability> exports = this.m_resolverState.getCandidates(null, req, false);
        Iterator<Capability> it = exports.iterator();
        while (it.hasNext()) {
            if (it.next().getModule().isResolved()) continue;
            it.remove();
        }
        if (exports != null) {
            ArrayList<ExportedPackageImpl> pkgs = new ArrayList<ExportedPackageImpl>();
            Iterator<Capability> it2 = exports.iterator();
            while (it2.hasNext()) {
                BundleImpl bundle = (BundleImpl)it2.next().getModule().getBundle();
                List<Module> modules = bundle.getModules();
                for (int modIdx = 0; modIdx < modules.size(); ++modIdx) {
                    List<Capability> ec = modules.get(modIdx).getCapabilities();
                    for (int i = 0; ec != null && i < ec.size(); ++i) {
                        if (!ec.get(i).getNamespace().equals(req.getNamespace()) || !CapabilitySet.matches(ec.get(i), req.getFilter())) continue;
                        pkgs.add(new ExportedPackageImpl(this, bundle, modules.get(modIdx), ec.get(i)));
                    }
                }
            }
            return pkgs.isEmpty() ? null : pkgs.toArray(new ExportedPackage[pkgs.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExportedPackage[] getExportedPackages(Bundle b) {
        ArrayList list = new ArrayList();
        if (b != null) {
            BundleImpl bundle = (BundleImpl)b;
            this.getExportedPackages(bundle, list);
        } else {
            boolean locked = this.acquireGlobalLock();
            if (!locked) {
                throw new IllegalStateException("Unable to acquire global lock to retrieve exported packages.");
            }
            try {
                for (int bundleIdx = 0; this.m_uninstalledBundles != null && bundleIdx < this.m_uninstalledBundles.size(); ++bundleIdx) {
                    BundleImpl bundle = this.m_uninstalledBundles.get(bundleIdx);
                    this.getExportedPackages(bundle, list);
                }
                Bundle[] bundles = this.getBundles();
                for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                    BundleImpl bundle = (BundleImpl)bundles[bundleIdx];
                    this.getExportedPackages(bundle, list);
                }
            }
            finally {
                this.releaseGlobalLock();
            }
        }
        return list.isEmpty() ? null : list.toArray(new ExportedPackage[list.size()]);
    }

    private void getExportedPackages(BundleImpl bundle, List list) {
        List<Module> modules = bundle.getModules();
        for (int modIdx = 0; modIdx < modules.size(); ++modIdx) {
            List<Capability> caps = modules.get(modIdx).getCapabilities();
            if (caps == null || caps.size() <= 0) continue;
            for (int capIdx = 0; capIdx < caps.size(); ++capIdx) {
                if (!caps.get(capIdx).getNamespace().equals("package")) continue;
                String pkgName = (String)caps.get(capIdx).getAttribute("package").getValue();
                ArrayList<Directive> dirs = new ArrayList<Directive>(0);
                ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
                attrs.add(new Attribute("package", pkgName, false));
                RequirementImpl req = new RequirementImpl(null, "package", dirs, attrs);
                Set<Capability> exports = this.m_resolverState.getCandidates(null, req, false);
                Iterator<Capability> it = exports.iterator();
                while (it.hasNext()) {
                    if (it.next().getModule().isResolved()) continue;
                    it.remove();
                }
                for (Capability cap : exports) {
                    if (cap != caps.get(capIdx)) continue;
                    list.add(new ExportedPackageImpl(this, bundle, modules.get(modIdx), caps.get(capIdx)));
                }
            }
        }
    }

    List<Bundle> getDependentBundles(BundleImpl exporter) {
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        List<Module> modules = exporter.getModules();
        for (int modIdx = 0; modIdx < modules.size(); ++modIdx) {
            List<Module> dependents = ((ModuleImpl)modules.get(modIdx)).getDependents();
            for (int depIdx = 0; dependents != null && depIdx < dependents.size(); ++depIdx) {
                list.add(dependents.get(depIdx).getBundle());
            }
        }
        return list;
    }

    List<Bundle> getImportingBundles(ExportedPackage ep) {
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        BundleImpl exporter = (BundleImpl)ep.getExportingBundle();
        List<Module> expModules = exporter.getModules();
        for (int expIdx = 0; expModules != null && expIdx < expModules.size(); ++expIdx) {
            int depIdx;
            List<Module> dependents = ((ModuleImpl)expModules.get(expIdx)).getDependentImporters();
            for (depIdx = 0; dependents != null && depIdx < dependents.size(); ++depIdx) {
                List<Wire> wires = dependents.get(depIdx).getWires();
                for (int wireIdx = 0; wires != null && wireIdx < wires.size(); ++wireIdx) {
                    if (wires.get(wireIdx).getExporter() != expModules.get(expIdx) || !wires.get(wireIdx).hasPackage(ep.getName())) continue;
                    list.add(dependents.get(depIdx).getBundle());
                }
            }
            dependents = ((ModuleImpl)expModules.get(expIdx)).getDependentRequirers();
            for (depIdx = 0; dependents != null && depIdx < dependents.size(); ++depIdx) {
                list.add(dependents.get(depIdx).getBundle());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resolveBundles(Bundle[] targets) {
        boolean locked = this.acquireGlobalLock();
        if (!locked) {
            this.m_logger.log(2, "Unable to acquire global lock to perform resolve.", null);
            return false;
        }
        try {
            if (targets == null) {
                ArrayList<BundleImpl> list = new ArrayList<BundleImpl>();
                for (BundleImpl bundle : this.m_installedBundles[0].values()) {
                    if (bundle.getState() != 2) continue;
                    list.add(bundle);
                }
                if (list.size() > 0) {
                    targets = list.toArray(new BundleImpl[list.size()]);
                }
            }
            boolean result = true;
            for (int i = 0; targets != null && i < targets.length; ++i) {
                try {
                    this.resolveBundle((BundleImpl)targets[i]);
                    continue;
                }
                catch (BundleException ex) {
                    result = false;
                    this.m_logger.log(2, new StringBuffer().append("Unable to resolve bundle ").append(targets[i].getBundleId()).toString(), ex);
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.releaseGlobalLock();
        }
    }

    private void resolveBundle(BundleImpl bundle) throws BundleException {
        try {
            this.m_felixResolver.resolve(bundle.getCurrentModule());
        }
        catch (ResolveException ex) {
            if (ex.getModule() != null) {
                Bundle b = ((ModuleImpl)ex.getModule()).getBundle();
                throw new BundleException(new StringBuffer().append("Unresolved constraint in bundle ").append(b).append(": ").append(ex.getMessage()).toString());
            }
            throw new BundleException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshPackages(Bundle[] targets) {
        boolean locked = this.acquireGlobalLock();
        if (!locked) {
            throw new IllegalStateException("Unable to acquire global lock for refresh.");
        }
        Bundle[] newTargets = targets;
        if (newTargets == null) {
            ArrayList<BundleImpl> list = new ArrayList<BundleImpl>();
            for (int i = 0; this.m_uninstalledBundles != null && i < this.m_uninstalledBundles.size(); ++i) {
                list.add(this.m_uninstalledBundles.get(i));
            }
            for (BundleImpl bundle : this.m_installedBundles[0].values()) {
                if (!bundle.isRemovalPending()) continue;
                list.add(bundle);
            }
            if (list.size() > 0) {
                newTargets = list.toArray(new Bundle[list.size()]);
            }
        }
        BundleImpl[] bundles = null;
        if (newTargets != null) {
            HashMap<BundleImpl, BundleImpl> map = new HashMap<BundleImpl, BundleImpl>();
            for (int targetIdx = 0; targetIdx < newTargets.length; ++targetIdx) {
                BundleImpl target = (BundleImpl)newTargets[targetIdx];
                map.put(target, target);
                this.populateDependentGraph(target, map);
            }
            bundles = map.values().toArray(new BundleImpl[map.size()]);
        }
        try {
            int i;
            boolean restart = false;
            Felix systemBundle = this;
            for (i = 0; bundles != null && !restart && i < bundles.length; ++i) {
                if (systemBundle != bundles[i]) continue;
                Bundle[] allBundles = this.getBundles();
                for (int j = 0; !restart && j < allBundles.length; ++j) {
                    if (!((BundleImpl)allBundles[j]).isExtension() || allBundles[j].getState() != 2) continue;
                    restart = true;
                }
            }
            for (i = 0; bundles != null && i < bundles.length; ++i) {
                this.forgetUninstalledBundle(bundles[i]);
            }
            if (bundles != null) {
                int i2;
                RefreshHelper[] helpers = new RefreshHelper[bundles.length];
                for (i2 = 0; i2 < bundles.length; ++i2) {
                    helpers[i2] = new RefreshHelper(bundles[i2]);
                }
                for (i2 = 0; i2 < helpers.length; ++i2) {
                    if (helpers[i2] == null) continue;
                    helpers[i2].stop();
                    helpers[i2].refreshOrRemove();
                }
                for (i2 = 0; i2 < helpers.length; ++i2) {
                    if (helpers[i2] == null) continue;
                    helpers[i2].restart();
                }
            }
            if (restart) {
                try {
                    this.update();
                }
                catch (BundleException ex) {
                    this.m_logger.log(1, "Framework restart error.", ex);
                }
            }
        }
        finally {
            this.releaseGlobalLock();
        }
        this.fireFrameworkEvent(4, this, null);
    }

    private void populateDependentGraph(BundleImpl exporter, Map map) {
        List<Bundle> dependents = this.getDependentBundles(exporter);
        for (int depIdx = 0; dependents != null && depIdx < dependents.size(); ++depIdx) {
            if (map.containsKey(dependents.get(depIdx))) continue;
            map.put(dependents.get(depIdx), dependents.get(depIdx));
            this.populateDependentGraph((BundleImpl)dependents.get(depIdx), map);
        }
    }

    SecurityProvider getSecurityProvider() {
        return this.m_securityProvider;
    }

    void setSecurityProvider(SecurityProvider securityProvider) {
        this.m_securityProvider = securityProvider;
    }

    Object getSignerMatcher(BundleImpl bundle, int signersType) {
        if (bundle != this && this.m_securityProvider != null) {
            return this.m_securityProvider.getSignerMatcher(bundle, signersType);
        }
        return new HashMap();
    }

    boolean impliesBundlePermission(BundleProtectionDomain bundleProtectionDomain, Permission permission, boolean direct) {
        if (this.m_securityProvider != null) {
            return this.m_securityProvider.hasBundlePermission(bundleProtectionDomain, permission, direct);
        }
        return true;
    }

    private BundleActivator createBundleActivator(BundleImpl impl) throws Exception {
        BundleActivator activator = null;
        Map headerMap = impl.getCurrentModule().getHeaders();
        String className = (String)headerMap.get("Bundle-Activator");
        if (className != null) {
            Class clazz;
            className = className.trim();
            try {
                clazz = impl.getCurrentModule().getClassByDelegation(className);
            }
            catch (ClassNotFoundException ex) {
                throw new BundleException(new StringBuffer().append("Not found: ").append(className).toString(), ex);
            }
            activator = (BundleActivator)clazz.newInstance();
        }
        return activator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBundle(BundleImpl bundle) throws Exception {
        try {
            this.acquireBundleLock(bundle, 6);
        }
        catch (IllegalStateException ex) {
            throw new BundleException("Bundle state has changed unexpectedly during refresh.");
        }
        try {
            bundle.refresh();
        }
        catch (Exception ex) {
            this.fireFrameworkEvent(2, bundle, ex);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    private void fireFrameworkEvent(int type, Bundle bundle, Throwable throwable) {
        this.m_dispatcher.fireFrameworkEvent(new FrameworkEvent(type, bundle, throwable));
    }

    private void fireBundleEvent(int type, Bundle bundle) {
        this.m_dispatcher.fireBundleEvent(new BundleEvent(type, bundle));
    }

    private void fireServiceEvent(ServiceEvent event, Dictionary oldProps) {
        this.m_dispatcher.fireServiceEvent(event, oldProps, this);
    }

    private void initializeFrameworkProperties() {
        this.m_configMutableMap.put("org.osgi.framework.version", "1.5");
        this.m_configMutableMap.put("org.osgi.framework.vendor", "Apache Software Foundation");
        this.m_configMutableMap.put("org.osgi.framework.language", System.getProperty("user.language"));
        this.m_configMutableMap.put("org.osgi.framework.os.version", System.getProperty("os.version"));
        this.m_configMutableMap.put("org.osgi.supports.framework.extension", "true");
        this.m_configMutableMap.put("org.osgi.supports.framework.fragment", "true");
        this.m_configMutableMap.put("org.osgi.supports.framework.requirebundle", "true");
        this.m_configMutableMap.put("org.osgi.supports.bootclasspath.extension", "false");
        String s = null;
        s = R4LibraryClause.normalizeOSName(System.getProperty("os.name"));
        this.m_configMutableMap.put("org.osgi.framework.os.name", s);
        s = R4LibraryClause.normalizeProcessor(System.getProperty("os.arch"));
        this.m_configMutableMap.put("org.osgi.framework.processor", s);
        this.m_configMutableMap.put("felix.version", Felix.getFrameworkVersion());
        if (!this.getConfig().containsKey("org.osgi.framework.executionenvironment") && (s = Util.getDefaultProperty(this.m_logger, "org.osgi.framework.executionenvironment")) != null) {
            this.m_configMutableMap.put("org.osgi.framework.executionenvironment", s);
        }
    }

    private static String getFrameworkVersion() {
        String toRet;
        StringBuffer sb;
        Properties props = new Properties();
        InputStream in = (class$org$apache$felix$framework$Felix == null ? (class$org$apache$felix$framework$Felix = Felix.class$("org.apache.felix.framework.Felix")) : class$org$apache$felix$framework$Felix).getResourceAsStream("Felix.properties");
        if (in != null) {
            try {
                props.load(in);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if ((sb = new StringBuffer(props.getProperty("felix.version", "0.0.0"))).toString().indexOf("-") >= 0) {
            sb.setCharAt(sb.toString().indexOf("-"), '.');
        }
        if ((toRet = sb.toString()).indexOf("${pom") >= 0) {
            return "0.0.0";
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long loadNextId() {
        Object object = this.m_nextIdLock;
        synchronized (object) {
            InputStream is = null;
            BufferedReader br = null;
            try {
                File file = this.m_cache.getSystemBundleDataFile("bundle.id");
                is = m_secureAction.getFileInputStream(file);
                br = new BufferedReader(new InputStreamReader(is));
                long l = Long.parseLong(br.readLine());
                return l;
            }
            catch (FileNotFoundException ex) {
            }
            catch (Exception ex) {
                this.m_logger.log(2, "Unable to initialize next bundle identifier from persistent storage.", ex);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex) {
                    this.m_logger.log(2, "Unable to close next bundle identifier file.", ex);
                }
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextId() {
        Object object = this.m_nextIdLock;
        synchronized (object) {
            long id = this.m_nextId++;
            OutputStream os = null;
            BufferedWriter bw = null;
            try {
                File file = this.m_cache.getSystemBundleDataFile("bundle.id");
                os = m_secureAction.getFileOutputStream(file);
                bw = new BufferedWriter(new OutputStreamWriter(os));
                String s = Long.toString(this.m_nextId);
                bw.write(s, 0, s.length());
            }
            catch (Exception ex) {
                this.m_logger.log(2, "Unable to save next bundle identifier to persistent storage.", ex);
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception ex) {
                    this.m_logger.log(2, "Unable to close next bundle identifier file.", ex);
                }
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberUninstalledBundle(BundleImpl bundle) {
        boolean locked = this.acquireGlobalLock();
        if (!locked) {
            throw new IllegalStateException("Unable to acquire global lock to record uninstalled bundle.");
        }
        try {
            for (int i = 0; this.m_uninstalledBundles != null && i < this.m_uninstalledBundles.size(); ++i) {
                if (this.m_uninstalledBundles.get(i) != bundle) continue;
                return;
            }
            ArrayList<BundleImpl> uninstalledBundles = new ArrayList<BundleImpl>(this.m_uninstalledBundles);
            uninstalledBundles.add(bundle);
            this.m_uninstalledBundles = uninstalledBundles;
        }
        finally {
            this.releaseGlobalLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetUninstalledBundle(BundleImpl bundle) {
        boolean locked = this.acquireGlobalLock();
        if (!locked) {
            throw new IllegalStateException("Unable to acquire global lock to release uninstalled bundle.");
        }
        try {
            if (this.m_uninstalledBundles == null) {
                return;
            }
            ArrayList<BundleImpl> uninstalledBundles = new ArrayList<BundleImpl>(this.m_uninstalledBundles);
            uninstalledBundles.remove(bundle);
            this.m_uninstalledBundles = uninstalledBundles;
        }
        finally {
            this.releaseGlobalLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireInstallLock(String location) throws BundleException {
        Object[] objectArray = this.m_installRequestLock_Priority1;
        synchronized (this.m_installRequestLock_Priority1) {
            while (this.m_installRequestMap.get(location) != null) {
                try {
                    this.m_installRequestLock_Priority1.wait();
                }
                catch (InterruptedException ex) {
                    throw new BundleException("Unable to install, thread interrupted.");
                }
            }
            this.m_installRequestMap.put(location, location);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseInstallLock(String location) {
        Object[] objectArray = this.m_installRequestLock_Priority1;
        synchronized (this.m_installRequestLock_Priority1) {
            this.m_installRequestMap.remove(location);
            this.m_installRequestLock_Priority1.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBundleStateAndNotify(BundleImpl bundle, int state) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            bundle.__setState(state);
            this.m_bundleLock.notifyAll();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireBundleLock(BundleImpl bundle, int desiredStates) throws IllegalStateException {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            while (!bundle.isLockable() || this.m_globalLockThread != null && this.m_globalLockThread != Thread.currentThread()) {
                if ((desiredStates & bundle.getState()) == 0) {
                    throw new IllegalStateException("Bundle in unexpected state.");
                }
                if (this.m_globalLockThread == Thread.currentThread() && bundle.getLockingThread() != null && this.m_globalLockWaitersList.contains(bundle.getLockingThread())) {
                    bundle.getLockingThread().interrupt();
                }
                try {
                    this.m_bundleLock.wait();
                }
                catch (InterruptedException ex) {}
            }
            if ((desiredStates & bundle.getState()) == 0) {
                throw new IllegalStateException("Bundle in unexpected state.");
            }
            bundle.lock();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseBundleLock(BundleImpl bundle) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            bundle.unlock();
            if (bundle.getLockingThread() == null) {
                this.m_bundleLock.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireGlobalLock() {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            boolean interrupted = false;
            while (!interrupted && this.m_globalLockThread != null && this.m_globalLockThread != Thread.currentThread()) {
                this.m_globalLockWaitersList.add(Thread.currentThread());
                this.m_bundleLock.notifyAll();
                try {
                    this.m_bundleLock.wait();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
                this.m_globalLockWaitersList.remove(Thread.currentThread());
            }
            if (!interrupted) {
                ++this.m_globalLockCount;
                this.m_globalLockThread = Thread.currentThread();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !interrupted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseGlobalLock() {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            if (this.m_globalLockThread == Thread.currentThread()) {
                --this.m_globalLockCount;
                if (this.m_globalLockCount == 0) {
                    this.m_globalLockThread = null;
                    this.m_bundleLock.notifyAll();
                }
            } else {
                throw new IllegalStateException("The current thread doesn't own the global lock.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void setURLHandlersActivator(URLHandlersActivator urlHandlersActivator) {
        this.m_urlHandlersActivator = urlHandlersActivator;
    }

    Object getStreamHandlerService(String protocol) {
        return this.m_urlHandlersActivator.getStreamHandlerService(protocol);
    }

    Object getContentHandlerService(String mimeType) {
        return this.m_urlHandlersActivator.getContentHandlerService(mimeType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    private class BundleComparator
    implements Comparator {
        private final boolean m_lowering;

        BundleComparator(boolean lowering) {
            this.m_lowering = lowering;
        }

        public int compare(Object o1, Object o2) {
            int result = -1;
            BundleImpl b1 = (BundleImpl)o1;
            BundleImpl b2 = (BundleImpl)o2;
            if (b1.getStartLevel(Felix.this.getInitialBundleStartLevel()) < b2.getStartLevel(Felix.this.getInitialBundleStartLevel())) {
                result = 1;
            } else if (b1.getStartLevel(Felix.this.getInitialBundleStartLevel()) > b2.getStartLevel(Felix.this.getInitialBundleStartLevel())) {
                result = -1;
            } else if (b1.getBundleId() < b2.getBundleId()) {
                result = 1;
            }
            if (!this.m_lowering) {
                result *= -1;
            }
            return result;
        }
    }

    private static class ListenerHookRemovedCallback
    implements InvokeHookCallback {
        private final Collection m_removed;

        ListenerHookRemovedCallback(Collection removed) {
            this.m_removed = removed;
        }

        public void invokeHook(Object hook) {
            ((ListenerHook)hook).removed(this.m_removed);
        }
    }

    private class RefreshHelper {
        private BundleImpl m_bundle = null;
        private int m_oldState = 2;

        public RefreshHelper(Bundle bundle) {
            this.m_bundle = (BundleImpl)bundle;
        }

        public void stop() {
            if (this.m_bundle.getState() == 32) {
                this.m_oldState = 32;
                try {
                    Felix.this.stopBundle(this.m_bundle, false);
                }
                catch (Throwable ex) {
                    Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
                }
            }
        }

        public void refreshOrRemove() {
            try {
                if (this.m_bundle.getState() == 1) {
                    this.m_bundle.closeAndDelete();
                    this.m_bundle = null;
                } else {
                    Felix.this.refreshBundle(this.m_bundle);
                }
            }
            catch (Throwable ex) {
                Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
            }
        }

        public void restart() {
            if (this.m_bundle != null && this.m_oldState == 32) {
                try {
                    int options = 1;
                    options = this.m_bundle.getPersistentState() == 8 ? options | 2 : options;
                    Felix.this.startBundle(this.m_bundle, options);
                }
                catch (Throwable ex) {
                    Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
                }
            }
        }
    }

    class SystemBundleActivator
    implements BundleActivator,
    Runnable {
        SystemBundleActivator() {
        }

        public void start(BundleContext context) throws Exception {
            Felix.this.m_activatorList.add(0, new PackageAdminActivator(Felix.this));
            Felix.this.m_activatorList.add(0, new StartLevelActivator(Felix.this.m_logger, Felix.this));
            Felix.this.m_activatorList.add(0, new URLHandlersActivator(Felix.this.m_configMap, Felix.this));
            for (int i = 0; i < Felix.this.m_activatorList.size(); ++i) {
                m_secureAction.startActivator((BundleActivator)Felix.this.m_activatorList.get(i), context);
            }
        }

        public void stop(BundleContext context) {
            if (Felix.this.m_shutdownThread == null) {
                Felix.this.m_shutdownThread = new Thread((Runnable)this, "FelixShutdown");
                Felix.this.m_shutdownThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int i;
            Felix.this.acquireBundleLock(Felix.this, 16);
            Felix.this.releaseBundleLock(Felix.this);
            try {
                StartLevelImpl sl = (StartLevelImpl)Felix.this.getService(Felix.this, Felix.this.getServiceReferences(Felix.this, (class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = Felix.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName(), null, true)[0]);
                sl.setStartLevelAndWait(0);
            }
            catch (InvalidSyntaxException ex) {
                // empty catch block
            }
            EventDispatcher.shutdown();
            Bundle[] bundles = Felix.this.getBundles();
            for (i = 0; i < bundles.length; ++i) {
                BundleImpl bundle = (BundleImpl)bundles[i];
                if (!bundle.isRemovalPending()) continue;
                try {
                    Felix.this.refreshBundle(bundle);
                    continue;
                }
                catch (Exception ex) {
                    Felix.this.fireFrameworkEvent(2, bundle, ex);
                    Felix.this.m_logger.log(1, "Unable to purge bundle " + bundle._getLocation(), ex);
                }
            }
            for (i = 0; Felix.this.m_uninstalledBundles != null && i < Felix.this.m_uninstalledBundles.size(); ++i) {
                try {
                    ((BundleImpl)Felix.this.m_uninstalledBundles.get(i)).closeAndDelete();
                    continue;
                }
                catch (Exception ex) {
                    Felix.this.m_logger.log(1, "Unable to remove " + ((BundleImpl)Felix.this.m_uninstalledBundles.get(i))._getLocation(), ex);
                }
            }
            bundles = Felix.this.getBundles();
            for (i = 0; i < bundles.length; ++i) {
                ((BundleImpl)bundles[i]).close();
            }
            for (i = 0; i < Felix.this.m_activatorList.size(); ++i) {
                try {
                    m_secureAction.stopActivator((BundleActivator)Felix.this.m_activatorList.get(i), Felix.this._getBundleContext());
                    continue;
                }
                catch (Throwable throwable) {
                    Felix.this.m_logger.log(2, "Exception stopping a system bundle activator.", throwable);
                }
            }
            if (Felix.this.m_securityManager != null) {
                System.setSecurityManager(null);
                Felix.this.m_securityManager = null;
            }
            if (Felix.this.m_extensionManager != null) {
                Felix.this.m_extensionManager.removeExtensions(Felix.this);
            }
            Felix.this.acquireBundleLock(Felix.this, 16);
            try {
                ((BundleContextImpl)Felix.this._getBundleContext()).invalidate();
                Felix.this.setBundleContext(null);
                Felix.this.setBundleStateAndNotify(Felix.this, 4);
                Felix.this.m_shutdownGate.open();
                Felix.this.m_shutdownGate = null;
                Felix.this.m_shutdownThread = null;
            }
            finally {
                Felix.this.releaseBundleLock(Felix.this);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FelixResolver {
        private final Resolver m_resolver;
        private final FelixResolverState m_resolverState;

        public FelixResolver(Resolver resolver, FelixResolverState resolverState) {
            this.m_resolver = resolver;
            this.m_resolverState = resolverState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resolve(Module rootModule) throws ResolveException {
            if (!rootModule.isResolved()) {
                boolean locked = Felix.this.acquireGlobalLock();
                if (!locked) {
                    throw new ResolveException("Unable to acquire global lock for resolve.", rootModule, null);
                }
                try {
                    BundleImpl bundle = (BundleImpl)rootModule.getBundle();
                    if (bundle.isExtension()) {
                        return;
                    }
                    Module newRootModule = this.m_resolverState.findHost(rootModule);
                    if (!Util.isFragment(newRootModule)) {
                        boolean repeat;
                        this.m_resolverState.checkSingleton(newRootModule);
                        do {
                            repeat = false;
                            try {
                                Map<Module, List<Wire>> wireMap = this.m_resolver.resolve(this.m_resolverState, newRootModule);
                                this.markResolvedModules(wireMap);
                            }
                            catch (ResolveException ex) {
                                if (ex.getRequirement() != null && ex.getRequirement() instanceof ModuleImpl.FragmentRequirement && rootModule != ((ModuleImpl.FragmentRequirement)ex.getRequirement()).getFragment()) {
                                    this.m_resolverState.detachFragment(newRootModule, ((ModuleImpl.FragmentRequirement)ex.getRequirement()).getFragment());
                                    repeat = true;
                                    continue;
                                }
                                throw ex;
                            }
                        } while (repeat);
                    }
                }
                finally {
                    Felix.this.releaseGlobalLock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Wire resolve(Module module, String pkgName) throws ResolveException {
            Wire candidateWire = null;
            if (module.isResolved() && this.isAllowedDynamicImport(module, pkgName)) {
                boolean locked = Felix.this.acquireGlobalLock();
                if (!locked) {
                    throw new ResolveException("Unable to acquire global lock for resolve.", module, null);
                }
                try {
                    List<Wire> wires = module.getWires();
                    for (int i = 0; wires != null && i < wires.size(); ++i) {
                        if (!wires.get(i).hasPackage(pkgName)) continue;
                        Wire wire = wires.get(i);
                        return wire;
                    }
                    Map<Module, List<Wire>> wireMap = this.m_resolver.resolve(this.m_resolverState, module, pkgName);
                    if (wireMap != null && wireMap.containsKey(module)) {
                        List<Wire> dynamicWires = wireMap.remove(module);
                        candidateWire = dynamicWires.get(0);
                        this.markResolvedModules(wireMap);
                        if (candidateWire != null) {
                            wires = new ArrayList<Wire>(wires.size() + 1);
                            wires.addAll(module.getWires());
                            wires.add(candidateWire);
                            ((ModuleImpl)module).setWires(wires);
                            Felix.this.m_logger.log(4, new StringBuffer().append("DYNAMIC WIRE: ").append(wires.get(wires.size() - 1)).toString());
                        }
                    }
                }
                finally {
                    Felix.this.releaseGlobalLock();
                }
            }
            return candidateWire;
        }

        public synchronized Set<Capability> getCandidates(Module reqModule, Requirement req, boolean obeyMandatory) {
            return this.m_resolverState.getCandidates(reqModule, req, obeyMandatory);
        }

        public boolean isAllowedDynamicImport(Module module, String pkgName) {
            if (!module.isResolved() || pkgName.length() == 0) {
                return false;
            }
            List<Requirement> dynamics = module.getDynamicRequirements();
            if (dynamics == null || dynamics.size() == 0) {
                return false;
            }
            List<Capability> caps = module.getCapabilities();
            for (int i = 0; caps != null && i < caps.size(); ++i) {
                if (!caps.get(i).getNamespace().equals("package") || !caps.get(i).getAttribute("package").getValue().equals(pkgName)) continue;
                return false;
            }
            List<Wire> wires = module.getWires();
            for (int i = 0; wires != null && i < wires.size(); ++i) {
                if (!wires.get(i).hasPackage(pkgName)) continue;
                return false;
            }
            List dirs = Collections.EMPTY_LIST;
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
            attrs.add(new Attribute("package", pkgName, false));
            RequirementImpl req = new RequirementImpl(module, "package", dirs, attrs);
            Set<Capability> candidates = this.m_resolverState.getCandidates(module, req, false);
            return candidates.size() != 0;
        }

        private void markResolvedModules(Map<Module, List<Wire>> wireMap) {
            if (wireMap != null) {
                for (Map.Entry<Module, List<Wire>> entry : wireMap.entrySet()) {
                    Module module = entry.getKey();
                    List<Wire> wires = entry.getValue();
                    for (int wireIdx = 0; wireIdx < wires.size(); ++wireIdx) {
                        Felix.this.m_logger.log(4, new StringBuffer().append("WIRE: ").append(wires.get(wireIdx)).toString());
                    }
                    ((ModuleImpl)module).setWires(wires);
                    List<Module> fragments = ((ModuleImpl)module).getFragments();
                    for (int i = 0; fragments != null && i < fragments.size(); ++i) {
                        ((ModuleImpl)fragments.get(i)).setResolved();
                        this.markBundleResolved(fragments.get(i));
                        Felix.this.m_logger.log(4, new StringBuffer().append("FRAGMENT WIRE: ").append(fragments.get(i)).append(" -> hosted by -> ").append(module).toString());
                    }
                    ((ModuleImpl)module).setResolved();
                    this.m_resolverState.moduleResolved(module);
                    this.markBundleResolved(module);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markBundleResolved(Module module) {
            BundleImpl bundle = (BundleImpl)module.getBundle();
            boolean fire = false;
            try {
                try {
                    Felix.this.acquireBundleLock(bundle, 38);
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
                if (bundle.getCurrentModule() == module) {
                    if (bundle.getState() != 2) {
                        Felix.this.m_logger.log(2, "Received a resolve event for a bundle that has already been resolved.");
                    } else {
                        Felix.this.setBundleStateAndNotify(bundle, 4);
                        fire = true;
                    }
                }
            }
            finally {
                Felix.this.releaseBundleLock(bundle);
            }
            if (fire) {
                Felix.this.fireBundleEvent(32, bundle);
            }
        }
    }
}

