/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.osgi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.executors.impl.ExecutorConfig;

public class Configuration {
    private static final Log LOG = LogFactory.getLog(Configuration.class);
    private static final Configuration INSTANCE = new Configuration();
    private final ExecutorConfig executorConfig = new ExecutorConfig();

    private Configuration() {
        LOG.debug((Object)"Configuring JBI components using OSGi ConfigAdmin");
    }

    public static final Configuration getInstance() {
        return INSTANCE;
    }

    public void setCorePoolSize(int size) {
        LOG.debug((Object)("Setting core thread pool size: " + size));
        this.executorConfig.setCorePoolSize(size);
    }

    public void setMaximumPoolSize(int size) {
        LOG.debug((Object)("Setting maximum thread pool size: " + size));
        this.executorConfig.setMaximumPoolSize(size);
    }

    public void setQueueSize(int size) {
        LOG.debug((Object)("Setting executor queue size: " + size));
        this.executorConfig.setQueueSize(size);
    }

    public void setAllowCoreThreadTimeout(boolean timeout) {
        LOG.debug((Object)("Setting core thread timeout allow: " + timeout));
        this.executorConfig.setAllowCoreThreadsTimeout(timeout);
    }

    public void setKeepAliveTime(int time) {
        LOG.debug((Object)("Setting thread keep-alive time: " + time));
        this.executorConfig.setKeepAliveTime((long)time);
    }

    public ExecutorConfig getExecutorConfig() {
        return this.executorConfig;
    }
}

