/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

@Command(scope="osgi", name="install", description="Installs one or more bundles")
public class InstallBundle
extends OsgiCommandSupport {
    @Argument(index=0, name="urls", description="Bundle URLs separated by whitespaces", required=true, multiValued=true)
    List<String> urls;
    @Option(name="-s", aliases={"--start"}, description="Starts the bundles after installation", required=false, multiValued=false)
    boolean start;

    protected Object doExecute() throws Exception {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        StringBuffer sb = new StringBuffer();
        for (String url : this.urls) {
            Bundle bundle = this.install(url, System.out, System.err);
            if (bundle == null) continue;
            bundles.add(bundle);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(bundle.getBundleId());
        }
        if (this.start) {
            for (Bundle bundle : bundles) {
                bundle.start();
            }
        }
        if (sb.toString().indexOf(44) > 0) {
            System.out.println("Bundle IDs: " + sb.toString());
        } else if (sb.length() > 0) {
            System.out.println("Bundle ID: " + sb.toString());
        }
        return null;
    }

    protected Bundle install(String location, PrintStream out, PrintStream err) {
        try {
            return this.getBundleContext().installBundle(location, null);
        }
        catch (IllegalStateException ex) {
            err.println(ex.toString());
        }
        catch (BundleException ex) {
            if (ex.getNestedException() != null) {
                err.println(ex.getNestedException().toString());
            } else {
                err.println(ex.toString());
            }
        }
        catch (Exception ex) {
            err.println(ex.toString());
        }
        return null;
    }
}

