/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config.completers;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class ConfigurationCompleter
implements Completer,
ConfigurationListener {
    private final StringsCompleter delegate = new StringsCompleter();
    private ConfigurationAdmin admin;

    public void setAdmin(ConfigurationAdmin admin) {
        this.admin = admin;
    }

    public void init() {
        Configuration[] configs;
        try {
            configs = this.admin.listConfigurations(null);
            if (configs == null) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        ArrayList<String> pids = new ArrayList<String>();
        for (Configuration config : configs) {
            if (config.getFactoryPid() != null) {
                pids.add(config.getFactoryPid());
                continue;
            }
            pids.add(config.getPid());
        }
        this.delegate.getStrings().addAll(pids);
    }

    public int complete(String buffer, int cursor, List candidates) {
        return this.delegate.complete(buffer, cursor, candidates);
    }

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        String pid;
        String string = pid = configurationEvent.getFactoryPid() != null ? configurationEvent.getFactoryPid() : configurationEvent.getPid();
        if (configurationEvent.getType() == 2) {
            this.delegate.getStrings().remove(pid);
        } else if (configurationEvent.getType() == 1) {
            this.delegate.getStrings().add(pid);
        }
    }
}

