/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management;

import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.apache.servicemix.nmr.management.ExchangeFailedEvent;
import org.apache.servicemix.nmr.management.ManagedEndpoint;
import org.fusesource.commons.management.ManagementStrategy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ManagementEndpointRegistry
implements ExchangeListener {
    private static final transient Log LOG = LogFactory.getLog(ManagementEndpointRegistry.class);
    private BundleContext bundleContext;
    private ManagementStrategy managementStrategy;
    private final Map<String, InternalEndpoint> internalEndpoints;
    private final Map<String, ManagedEndpoint> endpoints = new ConcurrentHashMap<String, ManagedEndpoint>();
    private ServiceTracker managementStrategyTracker;
    private ServiceTracker endpointTracker;

    public ManagementEndpointRegistry() {
        this.internalEndpoints = new ConcurrentHashMap<String, InternalEndpoint>();
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() {
        if (this.bundleContext == null) {
            throw new IllegalArgumentException("bundleContext must be set");
        }
        this.managementStrategyTracker = new ServiceTracker(this.bundleContext, ManagementStrategy.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                ManagementStrategy newMs = (ManagementStrategy)super.addingService(reference);
                if (this.getService() == null) {
                    ManagementEndpointRegistry.this.bindManagementStrategy(newMs);
                }
                return newMs;
            }

            public void removedService(ServiceReference reference, Object service) {
                ManagementStrategy newMs = (ManagementStrategy)this.getService();
                ManagementEndpointRegistry.this.bindManagementStrategy(newMs);
                super.removedService(reference, service);
            }
        };
        this.managementStrategyTracker.open();
        this.endpointTracker = new ServiceTracker(this.bundleContext, InternalEndpoint.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                InternalEndpoint endpoint = (InternalEndpoint)super.addingService(reference);
                ManagementEndpointRegistry.this.register(endpoint);
                return endpoint;
            }

            public void removedService(ServiceReference reference, Object service) {
                InternalEndpoint endpoint = (InternalEndpoint)service;
                ManagementEndpointRegistry.this.unregister(endpoint);
                super.removedService(reference, service);
            }
        };
        this.endpointTracker.open();
    }

    public void destroy() {
        this.unregisterAll();
        this.managementStrategyTracker.close();
        this.endpointTracker.close();
    }

    public void bindManagementStrategy(ManagementStrategy ms) {
        LOG.debug((Object)("Using new management strategy: " + ms));
        this.unregisterAll();
        this.managementStrategy = ms;
        this.registerAll();
    }

    protected void registerAll() {
        if (this.managementStrategy != null) {
            for (String id : this.internalEndpoints.keySet()) {
                this.registerEndpoint(this.internalEndpoints.get(id));
            }
        }
    }

    protected void unregisterAll() {
        if (this.managementStrategy != null) {
            for (String id : this.internalEndpoints.keySet()) {
                this.unregisterEndpoint(this.internalEndpoints.get(id));
            }
        }
    }

    protected void registerEndpoint(InternalEndpoint iep) {
        if (this.managementStrategy != null) {
            try {
                LOG.info((Object)("Registering endpoint: " + iep + " with properties " + iep.getMetaData()));
                ManagedEndpoint ep = new ManagedEndpoint(iep, this.managementStrategy);
                this.endpoints.put(iep.getId(), ep);
                this.managementStrategy.manageObject((Object)ep);
            }
            catch (Exception e) {
                LOG.warn((Object)("Unable to register managed endpoint: " + e), (Throwable)e);
            }
        }
    }

    private void unregisterEndpoint(InternalEndpoint iep) {
        if (this.managementStrategy != null) {
            try {
                LOG.info((Object)("Unregistering endpoint: " + iep + " with properties " + iep.getMetaData()));
                ManagedEndpoint ep = this.endpoints.remove(iep.getId());
                this.managementStrategy.unmanageObject((Object)ep);
            }
            catch (Exception e) {
                LOG.warn((Object)("Unable to unregister managed endpoint: " + e), (Throwable)e);
            }
        }
    }

    public void register(InternalEndpoint endpoint) {
        this.internalEndpoints.put(endpoint.getId(), endpoint);
        this.registerEndpoint(endpoint);
    }

    public void unregister(InternalEndpoint endpoint) {
        this.internalEndpoints.remove(endpoint.getId());
        this.unregisterEndpoint(endpoint);
    }

    public void exchangeSent(Exchange exchange) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Sending exchange: " + exchange));
            }
            if (exchange.getStatus() == Status.Active && exchange.getRole() == Role.Consumer && exchange.getOut(false) == null && exchange.getFault(false) == null && exchange instanceof InternalExchange) {
                ManagedEndpoint me;
                String id = ((InternalExchange)exchange).getSource().getId();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Source endpoint: " + id + " (known endpoints: " + this.endpoints + ")"));
                }
                if ((me = this.endpoints.get(id)) == null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("No managed endpoint registered with id: " + id));
                    }
                } else {
                    me.incrementOutbound();
                }
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Caught exception while processing exchange: " + t), t);
        }
    }

    public void exchangeDelivered(Exchange exchange) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Receiving exchange: " + exchange));
            }
            if (exchange.getStatus() == Status.Active && exchange.getRole() == Role.Provider && exchange.getOut(false) == null && exchange.getFault(false) == null && exchange instanceof InternalExchange) {
                ManagedEndpoint me;
                String id = ((InternalExchange)exchange).getDestination().getId();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Dest endpoint: " + id + " (known endpoints: " + this.endpoints + ")"));
                }
                if ((me = this.endpoints.get(id)) == null) {
                    LOG.warn((Object)("No managed endpoint registered with id: " + id));
                } else {
                    me.incrementInbound();
                }
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Caught exception while processing exchange: " + t), t);
        }
    }

    public void exchangeFailed(Exchange exchange) {
        ExchangeFailedEvent event = new ExchangeFailedEvent(exchange);
        try {
            this.managementStrategy.notify((EventObject)event);
        }
        catch (Exception ex) {
            LOG.warn((Object)"ExchangeFailedEvent notification failed", (Throwable)ex);
        }
    }
}

