/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.admin.command;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.admin.InstanceSettings;
import org.apache.karaf.admin.command.AdminCommandSupport;

@Command(scope="admin", name="create", description="Creates a new container instance.")
public class CreateCommand
extends AdminCommandSupport {
    @Option(name="-p", aliases={"--port"}, description="Port number for remote shell connection", required=false, multiValued=false)
    int port = 0;
    @Option(name="-l", aliases={"--location"}, description="Location of the new container instance in the file system", required=false, multiValued=false)
    String location;
    @Option(name="-f", aliases={"--feature"}, description="Initial features. This option can be specified multiple times to enable multiple initial features", required=false, multiValued=true)
    List<String> features;
    @Option(name="-furl", aliases={"--featureURL"}, description="Additional feature descriptor URLs. This option can be specified multiple times to add multiple URLs", required=false, multiValued=true)
    List<String> featureURLs;
    @Argument(index=0, name="name", description="The name of the new container instance", required=true, multiValued=false)
    String instance = null;

    protected Object doExecute() throws Exception {
        InstanceSettings settings = new InstanceSettings(this.port, this.location, this.featureURLs, this.features);
        this.getAdminService().createInstance(this.instance, settings);
        return null;
    }
}

