/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.commands.basic;

import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.gogo.commands.basic.ActionPreparator;
import org.apache.felix.gogo.commands.converter.DefaultConverter;
import org.osgi.service.command.CommandSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultActionPreparator
implements ActionPreparator {
    protected static final Option HELP = new Option(){

        @Override
        public String name() {
            return "--help";
        }

        @Override
        public String[] aliases() {
            return new String[0];
        }

        @Override
        public String description() {
            return "Display this help message";
        }

        @Override
        public boolean required() {
            return false;
        }

        @Override
        public boolean multiValued() {
            return false;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Option.class;
        }
    };

    @Override
    public boolean prepare(Action action, CommandSession session, List<Object> params) throws Exception {
        HashMap<Option, Field> options = new HashMap<Option, Field>();
        HashMap<Argument, Field> arguments = new HashMap<Argument, Field>();
        ArrayList<Argument> orderedArguments = new ArrayList<Argument>();
        for (Class<?> type = action.getClass(); type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    options.put(option, field);
                }
                if ((argument = field.getAnnotation(Argument.class)) == null) continue;
                arguments.put(argument, field);
                int index = argument.index();
                while (orderedArguments.size() <= index) {
                    orderedArguments.add(null);
                }
                if (orderedArguments.get(index) != null) {
                    throw new IllegalArgumentException("Duplicate argument index: " + index);
                }
                orderedArguments.set(index, argument);
            }
        }
        for (int i = 0; i < orderedArguments.size(); ++i) {
            if (orderedArguments.get(i) != null) continue;
            throw new IllegalArgumentException("Missing argument for index: " + i);
        }
        HashMap<Option, Object> optionValues = new HashMap<Option, Object>();
        HashMap<Argument, Object> argumentValues = new HashMap<Argument, Object>();
        boolean processOptions = true;
        int argIndex = 0;
        Iterator<Object> it = params.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (HELP.name().equals(object) || Arrays.asList(HELP.aliases()).contains(object)) {
                this.printUsage(session, action.getClass().getAnnotation(Command.class), options.keySet(), arguments.keySet(), System.out);
                return false;
            }
            if (processOptions && object instanceof String && ((String)object).startsWith("-")) {
                String name;
                boolean isKeyValuePair = ((String)object).indexOf(61) != -1;
                Object value = null;
                if (isKeyValuePair) {
                    name = ((String)object).substring(0, ((String)object).indexOf(61));
                    value = ((String)object).substring(((String)object).indexOf(61) + 1);
                } else {
                    name = (String)object;
                }
                Option option = null;
                for (Option opt : options.keySet()) {
                    if (!name.equals(opt.name()) && Arrays.binarySearch(opt.aliases(), name) < 0) continue;
                    option = opt;
                    break;
                }
                if (option == null) {
                    throw new IllegalArgumentException("Undefined option: " + object);
                }
                Field field = (Field)options.get(option);
                if (value == null && (field.getType() == Boolean.TYPE || field.getType() == Boolean.class)) {
                    value = Boolean.TRUE;
                }
                if (value == null && it.hasNext()) {
                    value = it.next();
                }
                if (value == null) {
                    throw new IllegalArgumentException("Missing value for option " + object);
                }
                if (option.multiValued()) {
                    ArrayList<Object> l = (ArrayList<Object>)optionValues.get(option);
                    if (l == null) {
                        l = new ArrayList<Object>();
                        optionValues.put(option, l);
                    }
                    l.add(value);
                    continue;
                }
                optionValues.put(option, value);
                continue;
            }
            processOptions = false;
            if (argIndex >= orderedArguments.size()) {
                throw new IllegalArgumentException("Too many arguments specified");
            }
            Argument argument = (Argument)orderedArguments.get(argIndex);
            if (!argument.multiValued()) {
                ++argIndex;
            }
            if (argument.multiValued()) {
                ArrayList<Object> l = (ArrayList<Object>)argumentValues.get(argument);
                if (l == null) {
                    l = new ArrayList<Object>();
                    argumentValues.put(argument, l);
                }
                l.add(object);
                continue;
            }
            argumentValues.put(argument, object);
        }
        for (Option option : options.keySet()) {
            if (!option.required() || optionValues.get(option) != null) continue;
            throw new IllegalArgumentException("Option " + option.name() + " is required");
        }
        for (Argument argument : arguments.keySet()) {
            if (!argument.required() || argumentValues.get(argument) != null) continue;
            throw new IllegalArgumentException("Argument " + argument.name() + " is required");
        }
        for (Map.Entry entry : optionValues.entrySet()) {
            Field field = (Field)options.get(entry.getKey());
            Object value = this.convert(action, session, entry.getValue(), field.getGenericType());
            field.setAccessible(true);
            field.set(action, value);
        }
        for (Map.Entry entry : argumentValues.entrySet()) {
            Field field = (Field)arguments.get(entry.getKey());
            Object value = this.convert(action, session, entry.getValue(), field.getGenericType());
            field.setAccessible(true);
            field.set(action, value);
        }
        return true;
    }

    protected void printUsage(CommandSession session, Command command, Set<Option> options, Set<Argument> arguments, PrintStream out) {
        options = new HashSet<Option>(options);
        options.add(HELP);
        if (command != null && command.description() != null && command.description().length() > 0) {
            out.println(command.description());
            out.println();
        }
        String syntax = "syntax: ";
        if (command != null) {
            syntax = syntax + command.scope() + ":" + command.name();
        }
        if (options.size() > 0) {
            syntax = syntax + " [options]";
        }
        if (arguments.size() > 0) {
            syntax = syntax + " [arguments]";
        }
        out.println(syntax);
        out.println();
        if (arguments.size() > 0) {
            out.println("arguments:");
            for (Argument argument : arguments) {
                out.print("  ");
                out.print(argument.name());
                out.print("  ");
                out.print(argument.description());
                out.println();
            }
            out.println();
        }
        if (options.size() > 0) {
            out.println("options:");
            for (Option option : options) {
                out.print("  ");
                out.print(option.name());
                out.print("  ");
                if (option.aliases().length > 0) {
                    out.print("(");
                    out.print(Arrays.toString(option.aliases()));
                    out.print(")  ");
                }
                out.print(option.description());
                out.println();
            }
            out.println();
        }
    }

    protected Object convert(Action action, CommandSession session, Object value, Type toType) throws Exception {
        if (toType == String.class) {
            return value != null ? value.toString() : null;
        }
        return new DefaultConverter(action.getClass().getClassLoader()).convert(value, toType);
    }
}

