/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.spring;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SpringDeploymentListener
implements ArtifactUrlTransformer {
    private static final Log LOGGER = LogFactory.getLog(SpringDeploymentListener.class);
    private DocumentBuilderFactory dbf;

    public boolean canHandle(File artifact) {
        try {
            if (artifact.isFile() && artifact.getName().endsWith(".xml")) {
                Document doc = this.parse(artifact);
                String name = doc.getDocumentElement().getLocalName();
                String uri = doc.getDocumentElement().getNamespaceURI();
                if ("beans".equals(name) && "http://www.springframework.org/schema/beans".equals(uri)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Unable to parse deployed file " + artifact.getAbsolutePath()), (Throwable)e);
        }
        return false;
    }

    public URL transform(URL artifact) {
        try {
            return new URL("spring", null, artifact.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to build spring application bundle", (Throwable)e);
            return null;
        }
    }

    protected Document parse(File artifact) throws Exception {
        if (this.dbf == null) {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.dbf.setNamespaceAware(true);
        }
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
            }

            public void error(SAXParseException exception) throws SAXException {
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        return db.parse(artifact);
    }
}

