/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.management.ManagedEndpoint;
import org.apache.servicemix.nmr.management.Nameable;
import org.apache.servicemix.nmr.management.NamingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamingStrategy
implements NamingStrategy {
    private static final Log LOG = LogFactory.getLog(DefaultNamingStrategy.class);
    private String jmxDomainName;

    @Override
    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    @Override
    public ObjectName getObjectName(ManagedEndpoint endpoint) throws MalformedObjectNameException {
        return new ObjectName(this.jmxDomainName + ":Type=Endpoint,Id=" + this.sanitize(this.getId(endpoint)));
    }

    @Override
    public ObjectName getObjectName(Nameable nameable) throws MalformedObjectNameException {
        String name = this.jmxDomainName + ":" + (nameable.getParent() != null ? "ContainerName=" + this.sanitize(nameable.getParent()) + "," : "") + "Type=" + this.sanitize(nameable.getMainType()) + ",Name=" + this.sanitize(nameable.getName()) + (nameable.getVersion() != null ? ",Version=" + this.sanitize(nameable.getVersion()) : "") + (nameable.getSubType() != null ? ",SubType=" + this.sanitize(nameable.getSubType()) : "");
        return new ObjectName(name);
    }

    private String sanitize(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
            result = result.replace('?', '_');
            result = result.replace('=', '_');
            result = result.replace(',', '_');
        }
        return result;
    }

    @Override
    public ObjectName getCustomObjectName(String type, String name) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("Type", "Component");
        result.put("Name", this.sanitize(name));
        result.put("SubType", this.sanitize(type));
        return this.createObjectName(result);
    }

    public ObjectName createObjectName(Map<String, String> props) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getJmxDomainName()).append(':');
        int i = 0;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append((Object)entry.getKey()).append("=").append((Object)entry.getValue());
        }
        ObjectName result = null;
        try {
            result = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            String error = "Could not create ObjectName for " + props;
            LOG.error((Object)error, (Throwable)e);
            throw new RuntimeException(error);
        }
        return result;
    }

    public static ObjectName getSystemObjectName(String domainName, String containerName, Class interfaceType) {
        String tmp = domainName + ":ContainerName=" + containerName + ",Type=SystemService,Name=" + DefaultNamingStrategy.getSystemServiceName(interfaceType);
        ObjectName result = null;
        try {
            result = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)"Failed to build ObjectName:", (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.error((Object)"Failed to build ObjectName:", (Throwable)e);
        }
        return result;
    }

    public static String getSystemServiceName(Class interfaceType) {
        String name = interfaceType.getName();
        if ((name = name.substring(name.lastIndexOf(46) + 1)).endsWith("MBean")) {
            name = name.substring(0, name.length() - 5);
        }
        return name;
    }

    private String getId(ManagedEndpoint endpoint) {
        return endpoint.getEndpoint().getId();
    }
}

