/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.HashSet;
import java.util.List;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.framework.resolver.Module;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.RequiredBundle;

class RequiredBundleImpl
implements RequiredBundle {
    private final Felix m_felix;
    private final BundleImpl m_bundle;
    private volatile String m_toString = null;
    private volatile String m_versionString = null;

    public RequiredBundleImpl(Felix felix, BundleImpl bundle) {
        this.m_felix = felix;
        this.m_bundle = bundle;
    }

    public String getSymbolicName() {
        return this.m_bundle.getSymbolicName();
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public Bundle[] getRequiringBundles() {
        if (this.m_bundle.isStale()) {
            return null;
        }
        HashSet<Bundle> bundleSet = new HashSet<Bundle>();
        List<Module> modules = this.m_bundle.getModules();
        for (int modIdx = 0; modules != null && modIdx < modules.size(); ++modIdx) {
            List<Module> dependents = ((ModuleImpl)modules.get(modIdx)).getDependentRequirers();
            for (int depIdx = 0; dependents != null && depIdx < dependents.size(); ++depIdx) {
                if (dependents.get(depIdx).getBundle() == null) continue;
                bundleSet.add(dependents.get(depIdx).getBundle());
            }
        }
        return bundleSet.toArray(new Bundle[bundleSet.size()]);
    }

    public Version getVersion() {
        return this.m_bundle.getCurrentModule().getVersion();
    }

    public boolean isRemovalPending() {
        return this.m_bundle.isRemovalPending();
    }

    public String toString() {
        if (this.m_toString == null) {
            this.m_toString = this.m_bundle.getSymbolicName() + "; version=" + this.m_bundle.getCurrentModule().getVersion();
        }
        return this.m_toString;
    }
}

