/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.capabilityset;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.StringComparator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilitySet {
    private final Map<String, Map<Object, Set<Capability>>> m_indices = new TreeMap<String, Map<Object, Set<Capability>>>(new StringComparator(false));
    private final Set<Capability> m_capList = new HashSet<Capability>();
    private static final SecureAction m_secureAction = new SecureAction();
    private static final Class[] STRING_CLASS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CapabilitySet.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;

    public CapabilitySet(List<String> indexProps) {
        for (int i = 0; indexProps != null && i < indexProps.size(); ++i) {
            this.m_indices.put(indexProps.get(i), new HashMap());
        }
    }

    public void addCapability(Capability cap) {
        this.m_capList.add(cap);
        for (Map.Entry<String, Map<Object, Set<Capability>>> entry : this.m_indices.entrySet()) {
            Attribute capAttr = cap.getAttribute(entry.getKey());
            if (capAttr == null) continue;
            Object capValue = capAttr.getValue();
            if (capValue.getClass().isArray()) {
                capValue = CapabilitySet.convertArrayToList(capValue);
            }
            Map<Object, Set<Capability>> index = entry.getValue();
            if (capValue instanceof Collection) {
                Collection c = (Collection)capValue;
                for (Object o : c) {
                    this.indexCapability(index, cap, o);
                }
                continue;
            }
            this.indexCapability(index, cap, capValue);
        }
    }

    private void indexCapability(Map<Object, Set<Capability>> index, Capability cap, Object capValue) {
        Set<Capability> caps = index.get(capValue);
        if (caps == null) {
            caps = new HashSet<Capability>();
            index.put(capValue, caps);
        }
        caps.add(cap);
    }

    public void removeCapability(Capability cap) {
        if (this.m_capList.remove(cap)) {
            for (Map.Entry<String, Map<Object, Set<Capability>>> entry : this.m_indices.entrySet()) {
                Attribute capAttr = cap.getAttribute(entry.getKey());
                if (capAttr == null) continue;
                Object capValue = capAttr.getValue();
                if (capValue.getClass().isArray()) {
                    capValue = CapabilitySet.convertArrayToList(capValue);
                }
                Map<Object, Set<Capability>> index = entry.getValue();
                if (capValue instanceof Collection) {
                    Collection c = (Collection)capValue;
                    for (Object o : c) {
                        this.deindexCapability(index, cap, o);
                    }
                    continue;
                }
                this.deindexCapability(index, cap, capValue);
            }
        }
    }

    private void deindexCapability(Map<Object, Set<Capability>> index, Capability cap, Object capValue) {
        Set<Capability> caps = index.get(capValue);
        if (caps != null) {
            caps.remove(cap);
            if (caps.size() == 0) {
                index.remove(capValue);
            }
        }
    }

    public Set<Capability> match(SimpleFilter sf, boolean obeyMandatory) {
        Set<Capability> matches = this.match(this.m_capList, sf);
        return obeyMandatory ? CapabilitySet.matchMandatory(matches, sf) : matches;
    }

    private Set<Capability> match(Set<Capability> caps, SimpleFilter sf) {
        Set<Capability> matches;
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            matches = new HashSet<Capability>();
                            if (sf.getOperation() != 1) break block4;
                            List sfs = (List)sf.getValue();
                            for (int i = 0; caps.size() > 0 && i < sfs.size(); ++i) {
                                matches = this.match(caps, (SimpleFilter)sfs.get(i));
                                caps = matches;
                            }
                            break block5;
                        }
                        if (sf.getOperation() != 2) break block6;
                        List sfs = (List)sf.getValue();
                        for (int i = 0; i < sfs.size(); ++i) {
                            matches.addAll(this.match(caps, (SimpleFilter)sfs.get(i)));
                        }
                        break block5;
                    }
                    if (sf.getOperation() != 3) break block7;
                    matches.addAll(caps);
                    List sfs = (List)sf.getValue();
                    for (int i = 0; i < sfs.size(); ++i) {
                        matches.removeAll(this.match(caps, (SimpleFilter)sfs.get(i)));
                    }
                    break block5;
                }
                Map<Object, Set<Capability>> index = this.m_indices.get(sf.getName());
                if (sf.getOperation() != 4 || index == null) break block8;
                Set<Capability> existingCaps = index.get(sf.getValue());
                if (existingCaps == null) break block5;
                matches.addAll(existingCaps);
                matches.retainAll(caps);
                break block5;
            }
            for (Capability cap : caps) {
                Object lhs;
                Attribute attr = cap.getAttribute(sf.getName());
                if (attr == null || !CapabilitySet.compare(lhs = attr.getValue(), sf.getValue(), sf.getOperation())) continue;
                matches.add(cap);
            }
        }
        return matches;
    }

    public static boolean matches(Capability cap, SimpleFilter sf) {
        return CapabilitySet.matchesInternal(cap, sf) && CapabilitySet.matchMandatory(cap, sf);
    }

    private static boolean matchesInternal(Capability cap, SimpleFilter sf) {
        boolean matched = true;
        if (sf.getOperation() == 1) {
            List sfs = (List)sf.getValue();
            for (int i = 0; matched && i < sfs.size(); ++i) {
                matched = CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else if (sf.getOperation() == 2) {
            matched = false;
            List sfs = (List)sf.getValue();
            for (int i = 0; !matched && i < sfs.size(); ++i) {
                matched = CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else if (sf.getOperation() == 3) {
            List sfs = (List)sf.getValue();
            for (int i = 0; i < sfs.size(); ++i) {
                matched = !CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else {
            matched = false;
            Attribute attr = cap.getAttribute(sf.getName());
            if (attr != null) {
                Object lhs = attr.getValue();
                matched = CapabilitySet.compare(lhs, sf.getValue(), sf.getOperation());
            }
        }
        return matched;
    }

    private static Set<Capability> matchMandatory(Set<Capability> caps, SimpleFilter sf) {
        Iterator<Capability> it = caps.iterator();
        while (it.hasNext()) {
            Capability cap = it.next();
            if (CapabilitySet.matchMandatory(cap, sf)) continue;
            it.remove();
        }
        return caps;
    }

    private static boolean matchMandatory(Capability cap, SimpleFilter sf) {
        List<Attribute> attrs = cap.getAttributes();
        for (int attrIdx = 0; attrIdx < attrs.size(); ++attrIdx) {
            if (!attrs.get(attrIdx).isMandatory() || CapabilitySet.matchMandatory(attrs.get(attrIdx), sf)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchMandatory(Attribute attr, SimpleFilter sf) {
        if (sf.getName() != null && sf.getName().equals(attr.getName())) {
            return true;
        }
        if (sf.getOperation() == 1) {
            List list = (List)sf.getValue();
            for (int i = 0; i < list.size(); ++i) {
                SimpleFilter sf2 = (SimpleFilter)list.get(i);
                if (sf2.getName() == null || !sf2.getName().equals(attr.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean compare(Object lhs, Object rhsUnknown, int op) {
        if (op == 8) {
            return true;
        }
        if (lhs instanceof Comparable) {
            Object rhs;
            if (op == 7 && !(lhs instanceof String)) {
                return false;
            }
            if (op == 7) {
                rhs = rhsUnknown;
            } else {
                try {
                    rhs = CapabilitySet.coerceType(lhs, (String)rhsUnknown);
                }
                catch (Exception ex) {
                    return false;
                }
            }
            switch (op) {
                case 4: {
                    return ((Comparable)lhs).compareTo(rhs) == 0;
                }
                case 6: {
                    return ((Comparable)lhs).compareTo(rhs) >= 0;
                }
                case 5: {
                    return ((Comparable)lhs).compareTo(rhs) <= 0;
                }
                case 9: {
                    return CapabilitySet.compareApproximate((Comparable)lhs, rhs);
                }
                case 7: {
                    return SimpleFilter.compareSubstring((List)rhs, (String)lhs);
                }
            }
            throw new RuntimeException(new StringBuffer().append("Unknown comparison operator: ").append(op).toString());
        }
        if (lhs instanceof Boolean) {
            Object rhs;
            try {
                rhs = CapabilitySet.coerceType(lhs, (String)rhsUnknown);
            }
            catch (Exception ex) {
                return false;
            }
            switch (op) {
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    return lhs.equals(rhs);
                }
            }
            throw new RuntimeException(new StringBuffer().append("Unknown comparison operator: ").append(op).toString());
        }
        if (lhs.getClass().isArray()) {
            lhs = CapabilitySet.convertArrayToList(lhs);
        }
        if (lhs instanceof Collection) {
            Iterator iter = ((Collection)lhs).iterator();
            while (iter.hasNext()) {
                if (!CapabilitySet.compare(iter.next(), rhsUnknown, op)) continue;
                return true;
            }
            return false;
        }
        if (op == 7 && !(lhs instanceof String)) {
            return false;
        }
        Object rhsObj = null;
        try {
            rhsObj = CapabilitySet.coerceType(lhs, (String)rhsUnknown);
        }
        catch (Exception ex) {
            return false;
        }
        return lhs.equals(rhsObj);
    }

    private static boolean compareApproximate(Object lhs, Object rhs) {
        if (rhs instanceof String) {
            return CapabilitySet.removeWhitespace((String)lhs).equalsIgnoreCase(CapabilitySet.removeWhitespace((String)rhs));
        }
        if (rhs instanceof Character) {
            return Character.toLowerCase(((Character)lhs).charValue()) == Character.toLowerCase(((Character)rhs).charValue());
        }
        return lhs.equals(rhs);
    }

    private static String removeWhitespace(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private static Object coerceType(Object lhs, String rhsString) throws Exception {
        if (lhs.getClass() == rhsString.getClass()) {
            return rhsString;
        }
        Character rhs = null;
        try {
            if (lhs instanceof Character) {
                rhs = new Character(rhsString.charAt(0));
            } else {
                Constructor ctor = m_secureAction.getConstructor(lhs.getClass(), STRING_CLASS);
                m_secureAction.setAccesssible(ctor);
                rhs = ctor.newInstance(rhsString);
            }
        }
        catch (Exception ex) {
            throw new Exception(new StringBuffer().append("Could not instantiate class ").append(lhs.getClass().getName()).append(" from string constructor with argument '").append(rhsString).append("' because ").append(ex).toString());
        }
        return rhs;
    }

    private static List convertArrayToList(Object array) {
        int len = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

