/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="shell", name="tac", description="Captures the STDIN and returns it as a string. Optionally writes the content to a file")
public class TacAction
extends AbstractAction {
    @Option(name="-f", aliases={}, description="Outputs the content to the given file", required=false, multiValued=false)
    private File file;

    protected Object doExecute() throws Exception {
        StringWriter sw = new StringWriter();
        Writer[] writers = this.file != null ? new Writer[]{sw, new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.file)))} : new Writer[]{sw};
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        String s = rdr.readLine();
        boolean first = true;
        while (s != null) {
            for (Writer w : writers) {
                if (!first) {
                    w.write("\n");
                }
                w.write(s);
            }
            first = false;
            s = rdr.readLine();
        }
        for (Writer w : writers) {
            w.close();
        }
        return sw.toString();
    }
}

