/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class EmbeddedResource
implements Resource {
    byte[] data;
    long lastModified;
    String extra;

    public EmbeddedResource(byte[] data, long lastModified) {
        this.data = data;
        this.lastModified = lastModified;
    }

    public InputStream openInputStream() throws FileNotFoundException {
        return new ByteArrayInputStream(this.data);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.data);
    }

    public String toString() {
        return ":" + this.data.length + ":";
    }

    public static void build(Jar jar, InputStream in, long lastModified) throws IOException {
        ZipInputStream jin = new ZipInputStream(in);
        ZipEntry entry = jin.getNextEntry();
        while (entry != null) {
            if (!entry.isDirectory()) {
                byte[] data = EmbeddedResource.collect(jin);
                jar.putResource(entry.getName(), new EmbeddedResource(data, lastModified), true);
            }
            entry = jin.getNextEntry();
        }
        jin.close();
    }

    static byte[] collect(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EmbeddedResource.copy(in, out);
        return out.toByteArray();
    }

    static void copy(InputStream in, OutputStream out) throws IOException {
        int size;
        int available = in.available();
        if (available <= 10000) {
            available = 64000;
        }
        byte[] buffer = new byte[available];
        while ((size = in.read(buffer)) > 0) {
            out.write(buffer, 0, size);
        }
    }

    public long lastModified() {
        return this.lastModified;
    }

    public static void build(Jar sub, Resource resource) throws IOException {
        InputStream in = resource.openInputStream();
        EmbeddedResource.build(sub, in, resource.lastModified());
        in.close();
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public long size() {
        return this.data.length;
    }
}

