/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.util.FileUtil;
import org.apache.servicemix.util.jaf.StreamDataSource;

public class BinaryFileMarshaler
extends DefaultFileMarshaler {
    private String attachment = "org.apache.servicemix.file.content";
    private String contentType = "application/octet-stream";

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void readMessage(MessageExchange exchange, NormalizedMessage message, InputStream in, String path) throws IOException, JBIException {
        File polledFile = new File(path);
        DataHandler handler = new DataHandler((DataSource)new StreamDataSource(in, this.getContentType(), polledFile.getName()));
        message.addAttachment(this.attachment, handler);
        message.setProperty("org.apache.servicemix.file.name", (Object)polledFile.getName());
        message.setProperty("org.apache.servicemix.file.path", (Object)path);
    }

    public void writeMessage(MessageExchange exchange, NormalizedMessage message, OutputStream out, String path) throws IOException, JBIException {
        DataHandler handler = message.getAttachment(this.attachment);
        if (handler == null) {
            throw new MessagingException("Could not find attachment: " + this.attachment);
        }
        InputStream is = handler.getInputStream();
        BinaryFileMarshaler.copyInputStream(is, out);
    }

    protected static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        FileUtil.fastCopy(in, out);
    }
}

