/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.jdbc.JdbcStoreFactory;

public class JdbcStore
implements Store {
    private static final Log LOG = LogFactory.getLog(JdbcStore.class);
    private JdbcStoreFactory factory;
    private String name;

    public JdbcStore(JdbcStoreFactory factory, String name) {
        this.factory = factory;
        this.name = name;
    }

    public boolean hasFeature(String feature) {
        return "Persistent".equals(feature) || "Clustered".equals(feature) && this.factory.isClustered() || "Transactional".equals(feature) && this.factory.isTransactional();
    }

    public void store(String id, Object data) throws IOException {
        LOG.debug((Object)("Storing object with id: " + id));
        Connection connection = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(data);
            out.close();
            connection = this.factory.getDataSource().getConnection();
            this.factory.getAdapter().doStoreData(connection, this.name + ":" + id, buffer.toByteArray());
        }
        catch (Exception e) {
            try {
                throw (IOException)new IOException("Error storing object").initCause(e);
            }
            catch (Throwable throwable) {
                this.close(connection);
                throw throwable;
            }
        }
        this.close(connection);
    }

    public String store(Object data) throws IOException {
        String id = this.factory.getIdGenerator().generateId();
        this.store(id, data);
        return id;
    }

    public Object load(String id) throws IOException {
        LOG.debug((Object)("Loading object with id: " + id));
        Connection connection = null;
        try {
            connection = this.factory.getDataSource().getConnection();
            byte[] data = this.factory.getAdapter().doLoadData(connection, this.name + ":" + id);
            Object result = null;
            if (data != null) {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
                result = ois.readObject();
                this.factory.getAdapter().doRemoveData(connection, this.name + ":" + id);
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error loading object").initCause(e);
        }
        finally {
            this.close(connection);
        }
    }

    public Object peek(String id) throws IOException {
        LOG.debug((Object)("Peeking object with id: " + id));
        Connection connection = null;
        try {
            connection = this.factory.getDataSource().getConnection();
            byte[] data = this.factory.getAdapter().doLoadData(connection, this.name + ":" + id);
            Object result = null;
            if (data != null) {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
                result = ois.readObject();
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error loading object").initCause(e);
        }
        finally {
            this.close(connection);
        }
    }

    protected void close(Connection connection) throws IOException {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                throw (IOException)new IOException("Error closing connection").initCause(e);
            }
        }
    }
}

