/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.document.impl.blueprint;

import java.util.ArrayList;
import java.util.List;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.ComponentDefinitionRegistryProcessor;
import org.apache.aries.blueprint.mutable.MutableBeanArgument;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanProperty;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableMapEntry;
import org.apache.aries.blueprint.mutable.MutableMapMetadata;
import org.apache.aries.blueprint.mutable.MutablePropsMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceListener;
import org.apache.aries.blueprint.mutable.MutableRegistrationListener;
import org.apache.aries.blueprint.mutable.MutableServiceMetadata;
import org.apache.servicemix.document.DocumentRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.PropsMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintDocumentFactory
implements ComponentDefinitionRegistryProcessor {
    private BundleContext bundleContext;
    private String document;
    private String documentId;
    private String beanName;
    private DocumentRepository repository;

    public void setDocument(String document) {
        this.document = document;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setRepository(DocumentRepository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.document == null) {
            throw new IllegalStateException("document must be set");
        }
        if (this.repository != null) {
            this.documentId = this.repository.register(this.document.getBytes());
        } else if (this.bundleContext != null) {
            ServiceReference ref = this.bundleContext.getServiceReference(DocumentRepository.class.getName());
            if (ref == null) {
                throw new IllegalStateException("Can not get a reference to the DocumentRepository");
            }
            try {
                DocumentRepository rep = (DocumentRepository)this.bundleContext.getService(ref);
                this.documentId = rep.register(this.document.getBytes());
            }
            finally {
                if (ref != null) {
                    this.bundleContext.ungetService(ref);
                }
            }
        } else {
            throw new IllegalStateException("repoitory or bundleContext must be set");
        }
    }

    public void process(ComponentDefinitionRegistry registry) throws ComponentDefinitionException {
        for (String name : registry.getComponentDefinitionNames()) {
            this.processMetadata((Metadata)registry.getComponentDefinition(name));
        }
    }

    protected Metadata processMetadata(Metadata metadata) {
        if (metadata instanceof BeanMetadata) {
            return this.processBeanMetadata((BeanMetadata)metadata);
        }
        if (metadata instanceof ReferenceListMetadata) {
            return this.processRefCollectionMetadata((ReferenceListMetadata)metadata);
        }
        if (metadata instanceof ReferenceMetadata) {
            return this.processReferenceMetadata((ReferenceMetadata)metadata);
        }
        if (metadata instanceof ServiceMetadata) {
            return this.processServiceMetadata((ServiceMetadata)metadata);
        }
        if (metadata instanceof CollectionMetadata) {
            return this.processCollectionMetadata((CollectionMetadata)metadata);
        }
        if (metadata instanceof MapMetadata) {
            return this.processMapMetadata((MapMetadata)metadata);
        }
        if (metadata instanceof PropsMetadata) {
            return this.processPropsMetadata((PropsMetadata)metadata);
        }
        if (metadata instanceof ValueMetadata) {
            return this.processValueMetadata((ValueMetadata)metadata);
        }
        return metadata;
    }

    protected Metadata processBeanMetadata(BeanMetadata component) {
        for (BeanArgument arg : component.getArguments()) {
            ((MutableBeanArgument)arg).setValue(this.processMetadata(arg.getValue()));
        }
        for (BeanProperty prop : component.getProperties()) {
            ((MutableBeanProperty)prop).setValue(this.processMetadata(prop.getValue()));
        }
        ((MutableBeanMetadata)component).setFactoryComponent((Target)this.processMetadata((Metadata)component.getFactoryComponent()));
        return component;
    }

    protected Metadata processServiceMetadata(ServiceMetadata component) {
        ((MutableServiceMetadata)component).setServiceComponent((Target)this.processMetadata((Metadata)component.getServiceComponent()));
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>(component.getServiceProperties());
        for (MapEntry entry : entries) {
            ((MutableServiceMetadata)component).removeServiceProperty(entry);
        }
        for (MapEntry entry : this.processMapEntries(entries)) {
            ((MutableServiceMetadata)component).addServiceProperty(entry);
        }
        for (RegistrationListener listener : component.getRegistrationListeners()) {
            ((MutableRegistrationListener)listener).setListenerComponent((Target)this.processMetadata((Metadata)listener.getListenerComponent()));
        }
        return component;
    }

    protected Metadata processReferenceMetadata(ReferenceMetadata component) {
        for (ReferenceListener listener : component.getReferenceListeners()) {
            ((MutableReferenceListener)listener).setListenerComponent((Target)this.processMetadata((Metadata)listener.getListenerComponent()));
        }
        return component;
    }

    protected Metadata processRefCollectionMetadata(ReferenceListMetadata component) {
        for (ReferenceListener listener : component.getReferenceListeners()) {
            ((MutableReferenceListener)listener).setListenerComponent((Target)this.processMetadata((Metadata)listener.getListenerComponent()));
        }
        return component;
    }

    protected Metadata processPropsMetadata(PropsMetadata metadata) {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>(metadata.getEntries());
        for (MapEntry entry : entries) {
            ((MutablePropsMetadata)metadata).removeEntry(entry);
        }
        for (MapEntry entry : this.processMapEntries(entries)) {
            ((MutablePropsMetadata)metadata).addEntry(entry);
        }
        return metadata;
    }

    protected Metadata processMapMetadata(MapMetadata metadata) {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>(metadata.getEntries());
        for (MapEntry entry : entries) {
            ((MutableMapMetadata)metadata).removeEntry(entry);
        }
        for (MapEntry entry : this.processMapEntries(entries)) {
            ((MutableMapMetadata)metadata).addEntry(entry);
        }
        return metadata;
    }

    protected List<MapEntry> processMapEntries(List<MapEntry> entries) {
        for (MapEntry entry : entries) {
            ((MutableMapEntry)entry).setKey((NonNullMetadata)this.processMetadata((Metadata)entry.getKey()));
            ((MutableMapEntry)entry).setValue(this.processMetadata(entry.getValue()));
        }
        return entries;
    }

    protected Metadata processCollectionMetadata(CollectionMetadata metadata) {
        ArrayList values = new ArrayList(metadata.getValues());
        for (Metadata value : values) {
            ((MutableCollectionMetadata)metadata).removeValue(value);
        }
        for (Metadata value : values) {
            ((MutableCollectionMetadata)metadata).addValue(this.processMetadata(value));
        }
        return metadata;
    }

    protected Metadata processValueMetadata(ValueMetadata metadata) {
        return new LateBindingValueMetadata(metadata);
    }

    protected String processString(String str) {
        if (str.equals("document-name:" + this.beanName)) {
            str = this.documentId;
        }
        return str;
    }

    public class LateBindingValueMetadata
    implements ValueMetadata {
        private final ValueMetadata metadata;
        private boolean retrieved;
        private String retrievedValue;

        public LateBindingValueMetadata(ValueMetadata metadata) {
            this.metadata = metadata;
        }

        public String getStringValue() {
            if (!this.retrieved) {
                this.retrieved = true;
                this.retrievedValue = BlueprintDocumentFactory.this.processString(this.metadata.getStringValue());
            }
            return this.retrievedValue;
        }

        public String getType() {
            return this.metadata.getType();
        }
    }
}

