/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.apache.servicemix.jbi.runtime.Environment;
import org.apache.servicemix.jbi.runtime.impl.MBeanServerWrapper;
import org.fusesource.commons.management.ManagementStrategy;
import org.fusesource.commons.management.Statistic;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EnvironmentImpl
implements Environment {
    private BundleContext bundleContext;
    private Object transactionManager;
    private InitialContext namingContext;
    private ManagementStrategyWrapper managementStrategy = new ManagementStrategyWrapper();
    private ManagementStrategy currentMs;
    private ServiceReference currentMsRef;
    private MBeanServerWrapper mbeanServer = new MBeanServerWrapper(null, this.managementStrategy);

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    public void bindManagementStrategy(ManagementStrategy ms) {
        this.managementStrategy.setDelegate(ms);
    }

    public void bindManagementStrategy(ServiceReference reference) {
        ManagementStrategy ms = (ManagementStrategy)this.bundleContext.getService(reference);
        this.managementStrategy.updateRef(this.currentMs, ms);
        if (this.currentMsRef != null) {
            this.bundleContext.ungetService(this.currentMsRef);
        }
        this.currentMs = ms;
        this.currentMsRef = reference;
    }

    public void unbindManagementStrategy(ServiceReference ref) {
        this.managementStrategy.updateRef(this.currentMs, null);
        if (this.currentMsRef != null) {
            this.bundleContext.ungetService(this.currentMsRef);
        }
        this.currentMs = null;
        this.currentMsRef = null;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void bindMBeanServer(MBeanServer mbs) {
        this.mbeanServer.setDelegate(mbs);
    }

    public void unbindMBeanServer(MBeanServer mbs) {
    }

    public Object getTransactionManager() {
        return this.transactionManager;
    }

    public void bindTransactionManager(ServiceReference reference) {
        this.transactionManager = this.bundleContext.getService(reference);
        this.bundleContext.ungetService(reference);
    }

    public void unbindTransactionManager(ServiceReference reference) {
        this.transactionManager = null;
    }

    public InitialContext getNamingContext() {
        return this.namingContext;
    }

    public void setNamingContext(InitialContext namingContext) {
        this.namingContext = namingContext;
    }

    public ObjectName getManagedObjectName(Object object) throws Exception {
        return (ObjectName)this.getManagementStrategy().getManagedObjectName(object, null, ObjectName.class);
    }

    public ObjectName getManagedObjectName(Object object, String customName) throws Exception {
        return (ObjectName)this.getManagementStrategy().getManagedObjectName(object, customName, ObjectName.class);
    }

    public String getJmxDomainName() throws Exception {
        return (String)this.getManagementStrategy().getManagedObjectName(null, null, String.class);
    }

    public void manageObject(Object managedObject) throws Exception {
        this.getManagementStrategy().manageObject(managedObject);
    }

    public void unmanageObject(Object managedObject) throws Exception {
        if (this.getManagementStrategy().isManaged(managedObject, null)) {
            this.getManagementStrategy().unmanageObject(managedObject);
        }
    }

    public void unmanageNamedObject(ObjectName name) throws Exception {
        this.getManagementStrategy().unmanageNamedObject((Object)name);
    }

    public boolean isManaged(Object managedObject) {
        return this.getManagementStrategy().isManaged(managedObject, null);
    }

    public void notify(EventObject event) throws Exception {
        this.getManagementStrategy().notify(event);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ManagementStrategyWrapper
    implements ManagementStrategy {
        private ManagementStrategy delegate;
        private boolean isValid;
        private Set<Object> managedObjects = new HashSet<Object>();

        public synchronized ManagementStrategy getDelegate() {
            return this.delegate;
        }

        public synchronized void setDelegate(ManagementStrategy delegate) {
            this.delegate = delegate;
        }

        public synchronized void updateRef(ManagementStrategy oldMs, ManagementStrategy newMs) {
            if (oldMs != newMs) {
                if (oldMs != null) {
                    for (Object managedObject : this.managedObjects) {
                        try {
                            oldMs.unmanageObject(managedObject);
                        }
                        catch (Exception e) {}
                    }
                }
                if (newMs != null) {
                    for (Object managedObject : this.managedObjects) {
                        try {
                            newMs.manageObject(managedObject);
                        }
                        catch (Exception e) {}
                    }
                }
            }
            this.isValid = newMs != null;
        }

        public synchronized void manageObject(Object managedObject) throws Exception {
            if (this.isValid) {
                this.delegate.manageObject(managedObject);
            }
            this.managedObjects.add(managedObject);
        }

        public synchronized void manageNamedObject(Object managedObject, Object preferedName) throws Exception {
            this.delegate.manageNamedObject(managedObject, preferedName);
        }

        public synchronized <T> T getManagedObjectName(Object managableObject, String customName, Class<T> nameType) throws Exception {
            return (T)this.delegate.getManagedObjectName(managableObject, customName, nameType);
        }

        public synchronized void unmanageObject(Object managedObject) throws Exception {
            if (this.isValid) {
                this.delegate.unmanageObject(managedObject);
            }
            this.managedObjects.remove(managedObject);
        }

        public synchronized void unmanageNamedObject(Object name) throws Exception {
            this.delegate.unmanageNamedObject(name);
        }

        public synchronized boolean isManaged(Object managableObject, Object name) {
            if (this.isValid) {
                return this.delegate.isManaged(managableObject, name);
            }
            if (managableObject != null) {
                return this.managedObjects.contains(managableObject);
            }
            return false;
        }

        public synchronized void notify(EventObject event) throws Exception {
            this.delegate.notify(event);
        }

        public synchronized Statistic createStatistic(String name, Object owner, Statistic.UpdateMode updateMode) {
            return this.delegate.createStatistic(name, owner, updateMode);
        }
    }
}

