/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.audit.AuditorException;
import org.apache.servicemix.nmr.audit.AuditorMBean;

public abstract class AbstractAuditor
implements AuditorMBean,
ExchangeListener {
    protected final Log log = LogFactory.getLog(this.getClass());

    public abstract int getExchangeCount() throws AuditorException;

    public String getExchangeIdByIndex(int index) throws AuditorException {
        if (index < 0) {
            throw new IllegalArgumentException("index should be greater or equal to zero");
        }
        return this.getExchangeIdsByRange(index, index + 1)[0];
    }

    public String[] getAllExchangeIds() throws AuditorException {
        return this.getExchangeIdsByRange(0, this.getExchangeCount());
    }

    public abstract String[] getExchangeIdsByRange(int var1, int var2) throws AuditorException;

    public Exchange getExchangeByIndex(int index) throws AuditorException {
        if (index < 0) {
            throw new IllegalArgumentException("index should be greater or equal to zero");
        }
        return this.getExchangesByRange(index, index + 1)[0];
    }

    public Exchange getExchangeById(String id) throws AuditorException {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("id should be non null and non empty");
        }
        return this.getExchangesByIds(new String[]{id})[0];
    }

    public Exchange[] getAllExchanges() throws AuditorException {
        return this.getExchangesByRange(0, this.getExchangeCount());
    }

    public Exchange[] getExchangesByRange(int fromIndex, int toIndex) throws AuditorException {
        return this.getExchangesByIds(this.getExchangeIdsByRange(fromIndex, toIndex));
    }

    public abstract Exchange[] getExchangesByIds(String[] var1) throws AuditorException;

    public int deleteAllExchanges() throws AuditorException {
        return this.deleteExchangesByRange(0, this.getExchangeCount());
    }

    public boolean deleteExchangeByIndex(int index) throws AuditorException {
        if (index < 0) {
            throw new IllegalArgumentException("index should be greater or equal to zero");
        }
        return this.deleteExchangesByRange(index, index + 1) == 1;
    }

    public boolean deleteExchangeById(String id) throws AuditorException {
        return this.deleteExchangesByIds(new String[]{id}) == 1;
    }

    public int deleteExchangesByRange(int fromIndex, int toIndex) throws AuditorException {
        return this.deleteExchangesByIds(this.getExchangeIdsByRange(fromIndex, toIndex));
    }

    public abstract int deleteExchangesByIds(String[] var1) throws AuditorException;

    public void resendExchange(Exchange exchange) throws AuditorException {
    }

    public void exchangeDelivered(Exchange exchange) {
    }

    public void exchangeFailed(Exchange exchange) {
    }
}

