/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.proxy.Collaborator;
import org.apache.aries.blueprint.proxy.ProxySubclassGenerator;
import org.apache.aries.blueprint.proxy.UnableToProxyException;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmInterceptorWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsmInterceptorWrapper.class);
    static final String LOG_ENTRY = "Method entry: {}, args {}";
    static final String LOG_EXIT = "Method exit: {}, returning {}";
    static final String LOG_EXCEPTION = "Caught exception";

    public static Object createProxyObject(ClassLoader cl, ComponentMetadata cm, List<Interceptor> interceptors, Object delegate, Class<?> ... classesToProxy) {
        LOGGER.debug(LOG_ENTRY, (Object)"createProxyObject", (Object)new Object[]{cl, cm, interceptors, delegate, classesToProxy});
        Object proxyObject = null;
        try {
            if (classesToProxy.length == 1 && !classesToProxy[0].isInterface()) {
                Class<?> classToProxy = classesToProxy[0];
                LOGGER.debug("Single class to proxy: {}", (Object)classToProxy.getName());
                boolean isProxy = AsmInterceptorWrapper.isProxyClass(classToProxy);
                LOGGER.debug("Class already a proxy: {}", (Object)isProxy);
                if (isProxy) {
                    try {
                        LOGGER.debug("Get a new instance of existing proxy class");
                        proxyObject = classToProxy.getConstructor(InvocationHandler.class).newInstance(new Collaborator(cm, interceptors, delegate));
                        LOGGER.debug("New proxy object instance {}", proxyObject);
                    }
                    catch (InvocationTargetException e) {
                        LOGGER.debug(LOG_EXCEPTION, (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        LOGGER.debug(LOG_EXCEPTION, (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        LOGGER.debug(LOG_EXCEPTION, (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.debug(LOG_EXCEPTION, (Throwable)e);
                    }
                    catch (SecurityException e) {
                        LOGGER.debug(LOG_EXCEPTION, (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.debug(LOG_EXCEPTION, (Throwable)e);
                    }
                } else {
                    LOGGER.debug("Generating a subclass proxy for: {}", (Object)classToProxy.getName());
                    proxyObject = AsmInterceptorWrapper.createSubclassProxy(classToProxy, cm, interceptors, delegate);
                }
            } else {
                LOGGER.debug("Multiple classes or interface(s) to proxy: {}", (Object[])classesToProxy);
                boolean useSubclassProxy = false;
                HashSet notInterfaces = new HashSet();
                for (Class<?> clazz : classesToProxy) {
                    if (clazz.isInterface()) continue;
                    useSubclassProxy = true;
                    notInterfaces.add(clazz);
                }
                if (useSubclassProxy) {
                    LOGGER.debug("Going to use subclass proxy");
                    Class classToProxy = null;
                    int deepest = 0;
                    Iterator i$ = notInterfaces.iterator();
                    while (i$.hasNext()) {
                        Class clazz;
                        Class nextHighestClass = clazz = (Class)i$.next();
                        int depth = 0;
                        do {
                            nextHighestClass = nextHighestClass.getSuperclass();
                            ++depth;
                        } while (nextHighestClass != null);
                        if (depth <= deepest) continue;
                        deepest = depth;
                        classToProxy = clazz;
                    }
                    LOGGER.debug("Most specific class to proxy: {}", classToProxy);
                    proxyObject = AsmInterceptorWrapper.createSubclassProxy(classToProxy, cm, interceptors, delegate);
                } else {
                    LOGGER.debug("Going to use interface proxy");
                    proxyObject = Proxy.newProxyInstance(cl, classesToProxy, (InvocationHandler)new Collaborator(cm, interceptors, delegate));
                }
            }
        }
        catch (UnableToProxyException e) {
            LOGGER.debug(LOG_EXIT, (Object)"createProxyObject", (Object)e);
            throw new ComponentDefinitionException("Unable to proxy bean for interceptors: " + e);
        }
        LOGGER.debug(LOG_EXIT, (Object)"createProxyObject", proxyObject);
        return proxyObject;
    }

    private static Object createSubclassProxy(Class<?> classToProxy, ComponentMetadata cm, List<Interceptor> interceptors, Object delegate) throws UnableToProxyException {
        LOGGER.debug(LOG_ENTRY, (Object)"createSubclassProxy", (Object)new Object[]{classToProxy, cm, interceptors, delegate});
        LOGGER.debug("Generating a subclass proxy for: {}", (Object)classToProxy.getName());
        try {
            Object proxyObject = ProxySubclassGenerator.newProxySubclassInstance(classToProxy, new Collaborator(cm, interceptors, delegate));
            LOGGER.debug("Generated subclass proxy object: {}", proxyObject);
            LOGGER.debug(LOG_EXIT, (Object)"createSubclassProxy", proxyObject);
            return proxyObject;
        }
        catch (UnableToProxyException e) {
            LOGGER.debug(LOG_EXCEPTION, (Throwable)e);
            LOGGER.debug(LOG_EXIT, (Object)"createSubclassProxy", (Object)e);
            throw e;
        }
    }

    static boolean isProxyClass(Class<?> clazz) {
        LOGGER.debug(LOG_ENTRY, (Object)"isProxyClass", (Object)new Object[]{clazz});
        boolean isProxyObject = false;
        isProxyObject = ProxySubclassGenerator.isProxySubclass(clazz);
        LOGGER.debug(LOG_EXIT, (Object)"isProxyClass", (Object)isProxyObject);
        return isProxyObject;
    }

    static Object unwrapObject(Object o) {
        LOGGER.debug(LOG_ENTRY, (Object)"unwrapObject", (Object)new Object[]{o});
        InvocationHandler ih = null;
        Object unwrappedObject = null;
        ih = ProxySubclassGenerator.isProxySubclass(o.getClass()) ? ProxySubclassGenerator.getInvocationHandler(o) : Proxy.getInvocationHandler(o);
        if (ih instanceof Collaborator) {
            unwrappedObject = ((Collaborator)ih).object;
        }
        LOGGER.debug(LOG_EXIT, (Object)"unwrapObject", unwrappedObject);
        return unwrappedObject;
    }
}

