/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.servicemix.store.Store;

public class MongoStore
implements Store {
    private static final String ID = "_id";
    private static final String DATA = "data";
    private static final String TIMESTAMP = "_timestamp";
    private DB db;
    DBCollection collection;
    private Long timeout;

    public MongoStore(DB db, String collectionName) {
        this.db = db;
        this.collection = db.getCollection(collectionName);
    }

    public MongoStore(DB db, String collectionName, Long timeout) {
        this.db = db;
        this.collection = db.getCollection(collectionName);
        this.timeout = timeout;
    }

    public boolean hasFeature(String feature) {
        return "Persistent".equals(feature) || "Clustered".equals(feature);
    }

    public void store(String id, Object data) throws IOException {
        BasicDBObject object = new BasicDBObject();
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(data);
            out.close();
            object.put(ID, (Object)id);
            object.put(DATA, (Object)buffer.toByteArray());
            object.put(TIMESTAMP, (Object)System.currentTimeMillis());
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error storing object").initCause(e);
        }
        WriteResult result = this.collection.insert(new DBObject[]{object});
        if (result.getError() != null) {
            throw new IOException(result.getError());
        }
    }

    public String store(Object data) throws IOException {
        BasicDBObject object = new BasicDBObject();
        object.put(DATA, data);
        WriteResult result = this.collection.insert(new DBObject[]{object});
        if (result.getError() != null) {
            throw new IOException(result.getError());
        }
        return String.valueOf(result.getField(ID));
    }

    public Object load(String id) throws IOException {
        this.evict();
        Object obj = null;
        try {
            BasicDBObject object = new BasicDBObject();
            object.put(ID, (Object)id);
            DBObject item = this.collection.findOne((DBObject)object);
            WriteResult result = this.collection.remove((DBObject)object);
            if (item == null) {
                throw new IOException("Could not find item with id " + id);
            }
            byte[] data = (byte[])item.get(DATA);
            if (data != null) {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
                obj = ois.readObject();
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error loading object").initCause(e);
        }
        return obj;
    }

    public Object peek(String id) throws IOException {
        this.evict();
        Object obj = null;
        try {
            BasicDBObject object = new BasicDBObject();
            object.put(ID, (Object)id);
            DBObject item = this.collection.findOne((DBObject)object);
            byte[] data = (byte[])item.get(DATA);
            if (data != null) {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
                obj = ois.readObject();
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error loading object").initCause(e);
        }
        return obj;
    }

    protected void evict() {
        if (this.timeout != null) {
            BasicDBObject object = new BasicDBObject();
            object.put(TIMESTAMP, (Object)new BasicDBObject("&lt", (Object)(System.currentTimeMillis() - this.timeout)));
            this.collection.remove((DBObject)object);
        }
    }
}

