/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.features;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class FeatureTransformer {
    private static final String DEFAULT_VERSION = "0.0.0";
    private static final Pattern ARTIFACT_MATCHER = Pattern.compile("(.+)(?:-(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(?:[^a-zA-Z0-9](.*))?)(?:\\.([^\\.]+))", 32);
    private static final Pattern FUZZY_MODIFIDER = Pattern.compile("(?:\\d+[.-])*(.*)", 32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(URL url, OutputStream os) throws Exception {
        String name = url.getPath();
        int idx = name.lastIndexOf(47);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        String[] str = FeatureTransformer.extractNameVersionType(name);
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "2");
        m.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        m.getMainAttributes().putValue("Bundle-SymbolicName", str[0]);
        m.getMainAttributes().putValue("Bundle-Version", str[1]);
        JarOutputStream out = new JarOutputStream(os);
        ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
        out.putNextEntry(e);
        m.write(out);
        out.closeEntry();
        e = new ZipEntry("META-INF/");
        out.putNextEntry(e);
        e = new ZipEntry("META-INF/org.apache.karaf.shell.features/");
        out.putNextEntry(e);
        out.closeEntry();
        e = new ZipEntry("META-INF/org.apache.karaf.shell.features/" + name);
        out.putNextEntry(e);
        InputStream fis = url.openStream();
        try {
            FeatureTransformer.copyInputStream(fis, out);
        }
        finally {
            fis.close();
        }
        out.closeEntry();
        out.close();
        os.close();
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }

    public static String[] extractNameVersionType(String url) {
        Matcher m = ARTIFACT_MATCHER.matcher(url);
        if (!m.matches()) {
            return new String[]{url, DEFAULT_VERSION};
        }
        StringBuffer v = new StringBuffer();
        String d1 = m.group(1);
        String d2 = m.group(2);
        String d3 = m.group(3);
        String d4 = m.group(4);
        String d5 = m.group(5);
        String d6 = m.group(6);
        if (d2 != null) {
            v.append(d2);
            if (d3 != null) {
                v.append('.');
                v.append(d3);
                if (d4 != null) {
                    v.append('.');
                    v.append(d4);
                    if (d5 != null) {
                        v.append(".");
                        FeatureTransformer.cleanupModifier(v, d5);
                    }
                } else if (d5 != null) {
                    v.append(".0.");
                    FeatureTransformer.cleanupModifier(v, d5);
                }
            } else if (d5 != null) {
                v.append(".0.0.");
                FeatureTransformer.cleanupModifier(v, d5);
            }
        }
        return new String[]{d1, v.toString(), d6};
    }

    private static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = FUZZY_MODIFIDER.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(1);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }
}

