/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.endpoints;

import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.common.scheduler.ScheduleIterator;
import org.apache.servicemix.common.scheduler.Scheduler;
import org.apache.servicemix.common.scheduler.SchedulerTask;
import org.apache.servicemix.executors.Executor;

public abstract class PollingEndpoint
extends ConsumerEndpoint {
    private Executor executor;
    private Scheduler scheduler;
    private Date firstTime;
    private long period = 5000L;
    private long delay;
    private SchedulerTask schedulerTask;
    private ScheduleIterator scheduleIterator;
    private boolean started;
    private boolean scheduleExecutedFlag;
    private boolean concurrentPolling;
    private AtomicBoolean pollActive = new AtomicBoolean(false);

    public PollingEndpoint() {
    }

    public PollingEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public PollingEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component.getServiceUnit(), endpoint.getServiceName(), endpoint.getEndpointName());
    }

    public abstract void poll() throws Exception;

    public Executor getExecutor() {
        return this.executor;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setFirstTime(Date firstTime) {
        this.firstTime = firstTime;
    }

    public Date getFirstTime() {
        return this.firstTime;
    }

    public void setConcurrentPolling(boolean concurrentPolling) {
        this.concurrentPolling = concurrentPolling;
    }

    public boolean isConcurrentPolling() {
        return this.concurrentPolling;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getPeriod() {
        return this.period;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public synchronized void start() throws Exception {
        if (!this.started) {
            this.started = true;
            if (this.scheduler == null) {
                this.scheduler = new Scheduler(true);
            }
            if (this.scheduleIterator == null) {
                this.scheduleIterator = new PollScheduleIterator();
            }
            if (this.executor == null) {
                this.executor = this.getServiceUnit().getComponent().getExecutor(MessageExchange.Role.CONSUMER);
            }
            if (this.schedulerTask != null) {
                this.schedulerTask.cancel();
            }
            this.schedulerTask = new PollSchedulerTask();
            this.scheduler.schedule(this.schedulerTask, this.scheduleIterator);
        }
        super.start();
    }

    public synchronized void stop() throws Exception {
        if (this.schedulerTask != null) {
            this.schedulerTask.cancel();
            this.schedulerTask = null;
        }
        this.scheduleExecutedFlag = false;
        this.started = false;
        this.scheduler.cancel();
        this.scheduler = null;
        this.scheduleIterator = null;
        this.executor = null;
        super.stop();
    }

    protected void handlePollException(Exception e) {
        this.logger.error((Object)("Caught exception while polling: " + e), (Throwable)e);
    }

    private class PollScheduleIterator
    implements ScheduleIterator {
        private PollScheduleIterator() {
        }

        public Date nextExecution() {
            long nextTime = System.currentTimeMillis();
            if (PollingEndpoint.this.scheduleExecutedFlag) {
                nextTime += PollingEndpoint.this.period;
            } else {
                if (PollingEndpoint.this.firstTime != null) {
                    nextTime = PollingEndpoint.this.firstTime.getTime();
                }
                nextTime += PollingEndpoint.this.delay;
                PollingEndpoint.this.scheduleExecutedFlag = true;
            }
            return PollingEndpoint.this.started ? new Date(nextTime) : null;
        }
    }

    private class PollSchedulerTask
    extends SchedulerTask {
        private PollSchedulerTask() {
        }

        public void run() {
            try {
                if (!PollingEndpoint.this.isConcurrentPolling() && PollingEndpoint.this.pollActive.get()) {
                    return;
                }
                PollingEndpoint.this.getExecutor().execute(new Runnable(){

                    public void run() {
                        try {
                            PollingEndpoint.this.pollActive.set(true);
                            PollingEndpoint.this.poll();
                            PollingEndpoint.this.pollActive.set(false);
                        }
                        catch (Exception e) {
                            PollingEndpoint.this.handlePollException(e);
                            PollingEndpoint.this.pollActive.set(false);
                        }
                    }
                });
            }
            catch (Throwable e) {
                PollingEndpoint.this.logger.error((Object)("Failed to schedule work: " + e), e);
                PollingEndpoint.this.pollActive.set(false);
            }
        }
    }
}

