/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.runtime.ComponentWrapper;
import org.apache.servicemix.jbi.runtime.impl.ComponentRegistryImpl;
import org.apache.servicemix.jbi.runtime.impl.ServiceEndpointImpl;
import org.apache.servicemix.jbi.runtime.impl.utils.DOMUtil;
import org.apache.servicemix.jbi.runtime.impl.utils.URIResolver;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.service.ServiceHelper;
import org.apache.servicemix.nmr.management.Nameable;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentContext
implements ComponentContext,
MBeanNames {
    public static final String INTERNAL_ENDPOINT = "jbi.internal";
    public static final String EXTERNAL_ENDPOINT = "jbi.external";
    private static final Log LOG = LogFactory.getLog(AbstractComponentContext.class);
    protected DeliveryChannel dc;
    protected ComponentRegistryImpl componentRegistry;

    public AbstractComponentContext(ComponentRegistryImpl componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public NMR getNmr() {
        return this.componentRegistry.getNmr();
    }

    public ServiceEndpoint getEndpoint(QName serviceName, String endpointName) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("SERVICE_NAME", serviceName.toString());
        props.put("ENDPOINT_NAME", endpointName);
        props.put(INTERNAL_ENDPOINT, Boolean.TRUE.toString());
        List endpoints = this.getNmr().getEndpointRegistry().query(props);
        if (endpoints.isEmpty()) {
            return null;
        }
        Map p = this.getNmr().getEndpointRegistry().getProperties(endpoints.get(0));
        return new ServiceEndpointImpl(p);
    }

    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws JBIException {
        block5: {
            String url;
            Map<String, ?> props;
            if (endpoint instanceof ServiceEndpointImpl && (props = ((ServiceEndpointImpl)endpoint).getProperties()) != null && (url = (String)props.get("WSDL_URL")) != null) {
                InputStream is = null;
                try {
                    is = new URL(url).openStream();
                    return DOMUtil.parseDocument(is);
                }
                catch (Exception e) {
                    if (is == null) break block5;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public ServiceEndpoint[] getEndpoints(QName interfaceName) {
        HashMap<String, String> props = null;
        if (interfaceName != null) {
            props = new HashMap<String, String>();
            props.put("INTERFACE_NAME", interfaceName.toString());
        }
        return this.queryInternalEndpoints(props);
    }

    protected ServiceEndpoint[] queryInternalEndpoints(Map<String, Object> props) {
        return this.doQueryServiceEndpoints(props, false);
    }

    protected ServiceEndpoint[] queryExternalEndpoints(Map<String, Object> props) {
        return this.doQueryServiceEndpoints(props, true);
    }

    protected ServiceEndpoint[] doQueryServiceEndpoints(Map<String, Object> props, boolean external) {
        List<Endpoint> endpoints = this.doQueryEndpoints(props, external);
        ArrayList<ServiceEndpoint> ses = new ArrayList<ServiceEndpoint>();
        for (Endpoint endpoint : endpoints) {
            ServiceEndpoint se = this.getServiceEndpoint(endpoint);
            if (se == null) continue;
            ses.add(se);
        }
        return ses.toArray(new ServiceEndpoint[ses.size()]);
    }

    protected List<Endpoint> doQueryEndpoints(Map<String, Object> props, boolean external) {
        if (props == null) {
            props = new HashMap<String, Object>();
        }
        props.put(external ? EXTERNAL_ENDPOINT : INTERNAL_ENDPOINT, Boolean.TRUE.toString());
        List endpoints = this.getNmr().getEndpointRegistry().query(props);
        return endpoints;
    }

    protected ServiceEndpoint getServiceEndpoint(Endpoint endpoint) {
        if (endpoint instanceof InternalEndpoint) {
            endpoint = ((InternalEndpoint)endpoint).getEndpoint();
        }
        if (endpoint instanceof ServiceEndpoint) {
            ServiceEndpoint se = (ServiceEndpoint)endpoint;
            if (se.getServiceName() != null && se.getEndpointName() != null) {
                return se;
            }
        } else {
            String endpointName;
            Map epProps = this.getNmr().getEndpointRegistry().getProperties((Object)endpoint);
            QName serviceName = this.getServiceQNameFromProperties(epProps);
            String string = endpointName = epProps.get("ENDPOINT_NAME") != null ? (String)epProps.get("ENDPOINT_NAME") : null;
            if (serviceName != null && endpointName != null) {
                return new ServiceEndpointImpl(epProps);
            }
        }
        return null;
    }

    protected QName getServiceQNameFromProperties(Map<String, ?> epProps) {
        QName svcName = null;
        if (epProps != null && epProps.containsKey("SERVICE_NAME")) {
            Object prop = epProps.get("SERVICE_NAME");
            if (prop instanceof QName) {
                svcName = (QName)prop;
            } else if (prop instanceof String && prop.toString().trim().length() > 0) {
                svcName = QName.valueOf((String)prop);
            }
        }
        return svcName;
    }

    public ServiceEndpoint[] getEndpointsForService(QName serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("This method needs a non-null serviceName parameter!");
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("SERVICE_NAME", serviceName.toString());
        return this.queryInternalEndpoints(props);
    }

    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) {
        HashMap<String, String> props = null;
        if (interfaceName != null) {
            props = new HashMap<String, String>();
            props.put("INTERFACE_NAME", interfaceName.toString());
        }
        return this.queryExternalEndpoints(props);
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("This method needs a non-null serviceName parameter!");
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("SERVICE_NAME", serviceName.toString());
        return this.queryExternalEndpoints(props);
    }

    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        return this.dc;
    }

    public Logger getLogger(String suffix, String resourceBundleName) throws MissingResourceException, JBIException {
        try {
            String name = suffix != null ? this.getComponentName() + suffix : this.getComponentName();
            return Logger.getLogger(name, resourceBundleName);
        }
        catch (IllegalArgumentException e) {
            throw new JBIException("A logger can not be created using resource bundle " + resourceBundleName);
        }
    }

    public MBeanNames getMBeanNames() {
        return this;
    }

    public MBeanServer getMBeanServer() {
        return this.componentRegistry.getEnvironment().getMBeanServer();
    }

    public InitialContext getNamingContext() {
        return this.componentRegistry.getEnvironment().getNamingContext();
    }

    public Object getTransactionManager() {
        return this.componentRegistry.getEnvironment().getTransactionManager();
    }

    public ObjectName createCustomComponentMBeanName(String customName) {
        ObjectName name = null;
        try {
            Nameable nameable = new Nameable(){

                public String getName() {
                    return AbstractComponentContext.this.getComponentName();
                }

                public String getParent() {
                    return null;
                }

                public String getMainType() {
                    return null;
                }

                public String getSubType() {
                    return null;
                }

                public String getVersion() {
                    return null;
                }

                public Class getPrimaryInterface() {
                    return null;
                }
            };
            name = this.componentRegistry.getEnvironment().getManagedObjectName(nameable, customName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public String getJmxDomainName() {
        String name = null;
        try {
            name = this.componentRegistry.getEnvironment().getJmxDomainName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        for (ComponentWrapper component : this.componentRegistry.getServices()) {
            ServiceEndpoint se = component.getComponent().resolveEndpointReference(epr);
            if (se == null) continue;
            Map target = this.componentRegistry.getProperties(component);
            this.componentRegistry.getNmr().getWireRegistry().register(ServiceHelper.createWire((Map)ServiceHelper.createMap((String[])new String[]{"ENDPOINT_NAME", se.getEndpointName(), "SERVICE_NAME", se.getServiceName().toString()}), (Map)ServiceHelper.createMap((String[])new String[]{"NAME", target.get("NAME").toString(), "TYPE", target.get("TYPE").toString()})));
            return se;
        }
        ServiceEndpoint se = this.resolveInternalEPR(epr);
        if (se != null) {
            return se;
        }
        return this.resolveStandardEPR(epr);
    }

    public ServiceEndpoint resolveInternalEPR(DocumentFragment epr) {
        if (epr == null) {
            throw new NullPointerException("resolveInternalEPR(epr) called with null epr.");
        }
        NodeList nl = epr.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || (el = (Element)n).getNamespaceURI() == null || !el.getNamespaceURI().equals("http://java.sun.com/jbi/end-point-reference") || el.getLocalName() == null || !el.getLocalName().equals("end-point-reference")) continue;
            String serviceName = el.getAttributeNS(el.getNamespaceURI(), "service-name");
            QName serviceQName = DOMUtil.createQName(el, serviceName);
            String endpointName = el.getAttributeNS(el.getNamespaceURI(), "end-point-name");
            return this.getEndpoint(serviceQName, endpointName);
        }
        return null;
    }

    public ServiceEndpoint resolveStandardEPR(DocumentFragment epr) {
        try {
            NodeList children = epr.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element address;
                String uri;
                Node n = children.item(i);
                if (n.getNodeType() != 1) continue;
                Element elem = (Element)n;
                String[] namespaces = new String[]{"http://www.w3.org/2005/08/addressing", "http://schemas.xmlsoap.org/ws/2004/08/addressing", "http://schemas.xmlsoap.org/ws/2004/03/addressing", "http://schemas.xmlsoap.org/ws/2003/03/addressing"};
                NodeList nl = null;
                for (String ns : namespaces) {
                    NodeList tnl = elem.getElementsByTagNameNS(ns, "Address");
                    if (tnl.getLength() != 1) continue;
                    nl = tnl;
                    break;
                }
                if (nl == null || (uri = DOMUtil.getElementText(address = (Element)nl.item(0))) == null) continue;
                if ((uri = uri.trim()).startsWith("endpoint:")) {
                    uri = uri.substring("endpoint:".length());
                    String[] parts = URIResolver.split3(uri);
                    return this.getEndpoint(new QName(parts[0], parts[1]), parts[2]);
                }
                if (!uri.startsWith("service:")) continue;
                uri = uri.substring("service:".length());
                String[] parts = URIResolver.split2(uri);
                return this.getEndpoint(new QName(parts[0], parts[1]), parts[1]);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Unable to resolve EPR: " + e));
        }
        return null;
    }
}

