/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.config.ConfigCommandSupport;
import org.apache.karaf.util.Properties;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="config", name="update", description="Save and propagate changes from the configuration being edited.")
public class UpdateCommand
extends ConfigCommandSupport {
    private final String FELIX_FILEINSTALL_FILENAME = "felix.fileinstall.filename";
    @Option(name="-b", aliases={"--bypass-storage"}, multiValued=false, required=false, description="Do not store the configuration in a properties file, but feed it directly to ConfigAdmin")
    private boolean bypassStorage;
    private File storage;

    public File getStorage() {
        return this.storage;
    }

    public void setStorage(File storage) {
        this.storage = storage;
    }

    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        Dictionary props = this.getEditedProps();
        if (props == null) {
            System.err.println("No configuration is being edited. Run the edit command first");
            return;
        }
        String pid = (String)this.session.get("ConfigCommand.PID");
        if (!this.bypassStorage && this.storage != null) {
            Object val;
            File storageFile = new File(this.storage, pid + ".cfg");
            Configuration cfg = admin.getConfiguration(pid, null);
            if (cfg != null && cfg.getProperties() != null && (val = cfg.getProperties().get("felix.fileinstall.filename")) instanceof String) {
                if (((String)val).startsWith("file:")) {
                    val = ((String)val).substring("file:".length());
                }
                storageFile = new File((String)val);
            }
            Properties p = new Properties(storageFile);
            Enumeration keys = props.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if ("service.pid".equals(key) || "service.factoryPid".equals(key) || "felix.fileinstall.filename".equals(key)) continue;
                p.put((String)key, (String)props.get(key));
            }
            this.storage.mkdirs();
            p.save();
        } else {
            String[] pids;
            Configuration cfg = admin.getConfiguration(pid, null);
            if (cfg.getProperties() == null && (pids = this.parsePid(pid))[1] != null) {
                cfg = admin.createFactoryConfiguration(pids[0], null);
            }
            if (cfg.getBundleLocation() != null) {
                cfg.setBundleLocation(null);
            }
            cfg.update(props);
        }
        this.session.put("ConfigCommand.PID", null);
        this.session.put("ConfigCommand.Props", null);
    }

    private String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }
}

