/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.properties;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.RolePrincipal;
import org.apache.karaf.jaas.modules.UserPrincipal;
import org.apache.karaf.util.Properties;

public class PropertiesLoginModule
extends AbstractKarafLoginModule {
    private static final String USER_FILE = "users";
    private static final Log LOG = LogFactory.getLog(PropertiesLoginModule.class);
    private String usersFile;

    public void initialize(Subject sub, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(sub, handler, options);
        this.usersFile = (String)options.get(USER_FILE) + "";
        if (this.debug) {
            LOG.debug((Object)("Initialized debug=" + this.debug + " usersFile=" + this.usersFile));
        }
    }

    public boolean login() throws LoginException {
        String encryptedPassword;
        Properties users;
        File f = new File(this.usersFile);
        try {
            users = new Properties(f);
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load user properties file " + f);
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        String password = new String(((PasswordCallback)callbacks[1]).getPassword());
        String userInfos = null;
        try {
            userInfos = (String)users.get(this.user);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (userInfos == null) {
            throw new FailedLoginException("User " + this.user + " does not exist");
        }
        String[] infos = userInfos.split(",");
        String storedPassword = infos[0];
        if (!storedPassword.equals(encryptedPassword = this.getEncryptedPassword(storedPassword))) {
            if (this.debug) {
                LOG.debug((Object)"The password isn't flagged as encrypted, encrypt it.");
            }
            if (this.debug) {
                LOG.debug((Object)"Rebuild the user informations string.");
            }
            userInfos = encryptedPassword + ",";
            for (int i = 1; i < infos.length; ++i) {
                userInfos = i == infos.length - 1 ? userInfos + infos[i] : userInfos + infos[i] + ",";
            }
            if (this.debug) {
                LOG.debug((Object)"Push back the user informations in the users properties.");
            }
            users.put(this.user, userInfos);
            try {
                if (this.debug) {
                    LOG.debug((Object)"Store the users properties file.");
                }
                users.save();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Unable to write user properties file " + f), (Throwable)ioe);
            }
            storedPassword = encryptedPassword;
        }
        if (!this.checkPassword(password, storedPassword)) {
            throw new FailedLoginException("Password for " + this.user + " does not match");
        }
        this.principals = new HashSet();
        this.principals.add(new UserPrincipal(this.user));
        for (int i = 1; i < infos.length; ++i) {
            this.principals.add(new RolePrincipal(infos[i]));
        }
        users.clear();
        if (this.debug) {
            LOG.debug((Object)("Successfully logged in " + this.user));
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            LOG.debug((Object)"abort");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            LOG.debug((Object)"logout");
        }
        return true;
    }
}

