/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.Component;
import javax.jbi.component.InstallationContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.management.InstallerMBean;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.deployer.SharedLibrary;
import org.apache.servicemix.jbi.deployer.artifacts.ComponentImpl;
import org.apache.servicemix.jbi.deployer.artifacts.SharedLibraryImpl;
import org.apache.servicemix.jbi.deployer.descriptor.ComponentDesc;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryList;
import org.apache.servicemix.jbi.deployer.impl.AbstractInstaller;
import org.apache.servicemix.jbi.deployer.impl.Deployer;
import org.apache.servicemix.jbi.deployer.impl.InstallationContextImpl;
import org.apache.servicemix.jbi.deployer.impl.PendingException;
import org.apache.servicemix.jbi.deployer.utils.BundleDelegatingClassLoader;
import org.apache.servicemix.jbi.deployer.utils.FileUtil;
import org.apache.servicemix.jbi.deployer.utils.ManagementSupport;
import org.apache.servicemix.nmr.management.Nameable;
import org.apache.xbean.classloader.MultiParentClassLoader;
import org.osgi.framework.Bundle;

public class ComponentInstaller
extends AbstractInstaller
implements InstallerMBean,
Nameable {
    private InstallationContextImpl installationContext;
    private ObjectName objectName;
    private ObjectName extensionMBeanName;
    private boolean initialized;
    private Bootstrap bootstrap;
    private Component innerComponent;

    public ComponentInstaller(Deployer deployer, Descriptor descriptor, File jbiArtifact, boolean autoStart) throws Exception {
        super(deployer, descriptor, jbiArtifact, autoStart);
        this.installRoot = new File(System.getProperty("karaf.base"), System.getProperty("jbi.cache", "data/jbi/") + this.getName() + "/install");
        this.installRoot.mkdirs();
        this.installationContext = new InstallationContextImpl(descriptor.getComponent(), deployer.getEnvironment());
        this.installationContext.setInstallRoot(this.installRoot);
    }

    public String getInstallRoot() {
        return this.installationContext.getInstallRoot();
    }

    public void register() throws JMException {
        try {
            this.deployer.getEnvironment().manageObject((Object)this);
        }
        catch (Exception ex) {
            throw new JMException(ex.getMessage());
        }
    }

    public void unregister() throws JMException {
        try {
            this.deployer.getEnvironment().unmanageObject((Object)this);
        }
        catch (Exception ex) {
            throw new JMException(ex.getMessage());
        }
    }

    public String getName() {
        return this.descriptor.getComponent().getIdentification().getName();
    }

    public Component getInnerComponent() {
        return this.innerComponent;
    }

    public void setInnerComponent(Component innerComponent) {
        this.innerComponent = innerComponent;
    }

    public void init() throws Exception {
        if (this.descriptor.getComponent().getSharedLibraries() != null) {
            for (SharedLibraryList sl : this.descriptor.getComponent().getSharedLibraries()) {
                if (this.deployer.getSharedLibrary(sl.getName()) != null) continue;
                throw new PendingException(this.bundle, "SharedLibrary not installed: " + sl.getName());
            }
        }
        super.init();
        if (this.isModified) {
            this.initBootstrap();
        }
    }

    public ObjectName install() throws JBIException {
        try {
            if (this.isModified) {
                if (this.isInstalled()) {
                    throw new DeploymentException("Component is already installed");
                }
                this.initBootstrap();
                if (this.bootstrap != null) {
                    this.bootstrap.onInstall();
                }
                try {
                    ObjectName name = this.initComponent();
                    this.cleanUpBootstrap();
                    this.installationContext.setInstall(false);
                    this.postInstall();
                    return name;
                }
                catch (Exception e) {
                    this.cleanUpBootstrap();
                    throw e;
                }
            }
            ObjectName name = this.initComponent();
            this.postInstall();
            return name;
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e.getMessage());
            throw new JBIException((Throwable)e);
        }
    }

    public boolean isInstalled() {
        return !this.installationContext.isInstall();
    }

    public void uninstall() throws JBIException {
        try {
            this.uninstall(false);
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
    }

    public void stop(boolean force) throws Exception {
        ComponentImpl comp = this.deployer.getComponent(this.getName());
        if (comp == null && !force) {
            throw ManagementSupport.failure("uninstallComponent", "Component '" + this.getName() + "' is not installed.");
        }
        if (comp != null && !"Shutdown".equals(comp.getCurrentState())) {
            if (!force) {
                throw ManagementSupport.failure("uninstallComponent", "Component '" + this.getName() + "' is not shut down.");
            }
            if ("Started".equals(comp.getCurrentState())) {
                comp.stop(false);
            }
            if ("Stopped".equals(comp.getCurrentState())) {
                comp.shutDown(false, force);
            }
        }
    }

    public void uninstall(boolean force) throws Exception {
        this.stop(force);
        ComponentImpl comp = this.deployer.getComponent(this.getName());
        if (comp == null && !force) {
            throw ManagementSupport.failure("uninstallComponent", "Component '" + this.getName() + "' is not installed.");
        }
        if (this.hasBootstrap()) {
            try {
                this.initBootstrap();
                this.bootstrap.init((InstallationContext)this.installationContext);
                this.bootstrap.getExtensionMBeanName();
                this.bootstrap.onUninstall();
                this.cleanUpBootstrap();
                this.installationContext.setInstall(true);
            }
            catch (Exception e) {
                this.cleanUpBootstrap();
                throw e;
            }
        }
        this.deployer.unregisterComponent(comp);
        try {
            this.deleteStorage();
        }
        catch (IOException e) {
            this.LOGGER.warn((Object)("Error cleaning persistent state for component: " + this.getName()), (Throwable)e);
        }
        this.uninstallBundle();
        FileUtil.deleteFile(this.installRoot);
    }

    public ObjectName getInstallerConfigurationMBean() throws JBIException {
        return this.extensionMBeanName;
    }

    public ObjectName getObjectName() {
        if (this.objectName == null) {
            try {
                this.objectName = this.deployer.getEnvironment().getManagedObjectName((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    protected ClassLoader createClassLoader(Bundle bundle, String name, String[] classPathNames, boolean parentFirst, SharedLibrary[] sharedLibs) {
        ClassLoader[] parents;
        if (sharedLibs != null) {
            parents = new ClassLoader[sharedLibs.length + 2];
            for (int i = 0; i < sharedLibs.length; ++i) {
                parents[i] = sharedLibs[i].getClassLoader();
            }
        } else {
            parents = new ClassLoader[2];
        }
        parents[parents.length - 2] = new BundleDelegatingClassLoader(bundle, this.getClass().getClassLoader());
        parents[parents.length - 1] = new BundleDelegatingClassLoader(this.getBundleContext().getBundle(0L));
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < classPathNames.length; ++i) {
            File f = new File(this.installRoot, classPathNames[i]);
            if (!f.exists()) {
                this.LOGGER.warn((Object)("Component classpath entry not found: '" + classPathNames[i] + "'"));
            }
            try {
                urls.add(f.getCanonicalFile().toURL());
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Component classpath entry not found: '" + classPathNames[i] + "'");
            }
        }
        return new MultiParentClassLoader(name, urls.toArray(new URL[urls.size()]), parents, !parentFirst, new String[0], new String[]{"java.", "javax."});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBootstrap() throws DeploymentException {
        block10: {
            if (!this.hasBootstrap()) {
                return;
            }
            try {
                if (this.initialized) break block10;
                try {
                    if (this.extensionMBeanName != null) {
                        this.deployer.getEnvironment().unmanageNamedObject(this.extensionMBeanName);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.bootstrap == null) {
                    this.bootstrap = this.createBootstrap();
                }
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.bootstrap.getClass().getClassLoader());
                    this.bootstrap.init((InstallationContext)this.installationContext);
                    this.extensionMBeanName = this.bootstrap.getExtensionMBeanName();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCl);
                }
                this.initialized = true;
            }
            catch (JBIException e) {
                this.LOGGER.error((Object)"Could not initialize bootstrap", (Throwable)e);
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    protected void cleanUpBootstrap() throws DeploymentException {
        if (this.bootstrap != null) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.bootstrap.getClass().getClassLoader());
                this.bootstrap.cleanUp();
            }
            catch (JBIException e) {
                this.LOGGER.error((Object)"Could not initialize bootstrap", (Throwable)e);
                throw new DeploymentException((Throwable)e);
            }
            finally {
                this.initialized = false;
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
    }

    private boolean hasBootstrap() {
        ComponentDesc descriptor = this.installationContext.getDescriptor();
        return descriptor.getBootstrapClassName() != null;
    }

    private Bootstrap createBootstrap() throws DeploymentException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        ComponentDesc descriptor = this.installationContext.getDescriptor();
        try {
            ClassLoader cl = this.createClassLoader(this.getBundle(), this.installationContext.getInstallRoot(), descriptor.getBootstrapClassPath().getPathElements(), descriptor.isBootstrapClassLoaderDelegationParentFirst(), null);
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> bootstrapClass = cl.loadClass(descriptor.getBootstrapClassName());
            Bootstrap bootstrap = (Bootstrap)bootstrapClass.newInstance();
            return bootstrap;
        }
        catch (ClassNotFoundException e) {
            this.LOGGER.error((Object)("Class not found: " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (InstantiationException e) {
            this.LOGGER.error((Object)("Could not instantiate : " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.LOGGER.error((Object)("Illegal access on: " + descriptor.getBootstrapClassName()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectName initComponent() throws Exception {
        ComponentDesc componentDesc = this.installationContext.getDescriptor();
        ArrayList<SharedLibraryImpl> libs = new ArrayList<SharedLibraryImpl>();
        if (componentDesc.getSharedLibraries() != null) {
            for (SharedLibraryList sll : componentDesc.getSharedLibraries()) {
                SharedLibraryImpl lib = this.deployer.getSharedLibrary(sll.getName());
                if (lib == null) continue;
                libs.add(lib);
            }
        }
        SharedLibrary[] aLibs = libs.toArray(new SharedLibrary[libs.size()]);
        if (this.innerComponent == null) {
            ClassLoader classLoader = this.createClassLoader(this.getBundle(), componentDesc.getIdentification().getName(), this.installationContext.getClassPathElements().toArray(new String[this.installationContext.getClassPathElements().size()]), componentDesc.isComponentClassLoaderDelegationParentFirst(), aLibs);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                Class<?> clazz = classLoader.loadClass(componentDesc.getComponentClassName());
                this.innerComponent = (Component)clazz.newInstance();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        ComponentImpl component = this.deployer.registerComponent(this.getBundle(), componentDesc, this.innerComponent, aLibs);
        return this.deployer.getEnvironment().getManagedObjectName((Object)component);
    }

    public void configure(Properties props) throws Exception {
        if (props != null && props.size() > 0) {
            ObjectName on = this.getInstallerConfigurationMBean();
            if (on == null) {
                this.LOGGER.warn((Object)"Could not find installation configuration MBean. Installation properties will be ignored.");
            } else {
                MBeanServer mbs = this.deployer.getEnvironment().getMBeanServer();
                for (Object o : props.keySet()) {
                    String key = (String)o;
                    String val = props.getProperty(key);
                    try {
                        mbs.setAttribute(on, new Attribute(key, val));
                    }
                    catch (JMException e) {
                        throw new DeploymentException("Could not set installation property: (" + key + " = " + val, (Throwable)e);
                    }
                }
            }
        }
    }

    public String getParent() {
        return null;
    }

    public String getMainType() {
        return "service-engine";
    }

    public String getSubType() {
        return "Installer";
    }

    public String getVersion() {
        return null;
    }

    public Class getPrimaryInterface() {
        return InstallerMBean.class;
    }
}

