/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.servicemix.jdbc.JDBCAdapter;
import org.apache.servicemix.jdbc.JDBCAdapterFactory;
import org.apache.servicemix.jdbc.Statements;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.Type;
import org.apache.servicemix.nmr.audit.AbstractAuditor;
import org.apache.servicemix.nmr.audit.AuditorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcAuditor
extends AbstractAuditor {
    private DataSource dataSource;
    private boolean autoStart = true;
    private Statements statements;
    private String tableName = "SM_AUDIT";
    private JDBCAdapter adapter;
    private boolean createDataBase = true;
    private Set<String> nonSerializableClasses = new HashSet<String>();
    private ClassLoader tccl;

    public String getDescription() {
        return "JDBC Auditing Service";
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("dataSource should not be null");
        }
        if (this.statements == null) {
            this.statements = new Statements();
            this.statements.setStoreTableName(this.tableName);
        }
        Connection connection = null;
        boolean restoreAutoCommit = false;
        try {
            connection = this.getDataSource().getConnection();
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
                restoreAutoCommit = true;
            }
            this.adapter = JDBCAdapterFactory.getAdapter((Connection)connection);
            if (this.statements == null) {
                this.statements = new Statements();
                this.statements.setStoreTableName(this.tableName);
            }
            this.adapter.setStatements(this.statements);
            if (this.createDataBase) {
                this.adapter.doCreateTables(connection);
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw (IOException)new IOException("Exception while creating database").initCause(e);
        }
        finally {
            JdbcAuditor.close(connection, restoreAutoCommit);
        }
        this.tccl = Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeSent(Exchange exchange) {
        try {
            String id = exchange.getId();
            Connection connection = null;
            boolean restoreAutoCommit = false;
            try {
                connection = this.dataSource.getConnection();
                if (connection.getAutoCommit()) {
                    connection.setAutoCommit(false);
                    restoreAutoCommit = true;
                }
                this.store(connection, id, this.getDataForExchange(exchange));
                connection.commit();
            }
            finally {
                JdbcAuditor.close(connection, restoreAutoCommit);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Could not persist exchange", (Throwable)e);
        }
    }

    protected byte[] getDataForExchange(Exchange exchange) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(baos);
        os.writeObject(this.checkSerializable(exchange));
        os.close();
        return baos.toByteArray();
    }

    protected Exchange checkSerializable(Exchange exchange) {
        Message m;
        boolean isSerializable = this.isMapSerializable(exchange.getProperties());
        if (isSerializable) {
            for (Type t : Type.values()) {
                m = exchange.getMessage(t, false);
                if (m == null || this.isMapSerializable(m.getHeaders())) continue;
                isSerializable = false;
                break;
            }
        }
        if (!isSerializable) {
            exchange = exchange.copy();
            this.makeMapSerializable(exchange.getProperties());
            for (Type t : Type.values()) {
                m = exchange.getMessage(t, false);
                if (m == null) continue;
                this.makeMapSerializable(m.getHeaders());
            }
        }
        return exchange;
    }

    protected boolean isMapSerializable(Map<String, Object> map) {
        for (Object o : map.values()) {
            if (o == null || o instanceof Serializable) continue;
            return false;
        }
        return true;
    }

    protected void makeMapSerializable(Map<String, Object> map) {
        ArrayList<String> badEntries = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null || entry.getValue() instanceof Serializable) continue;
            this.warnAboutNonSerializableClass(entry.getValue());
            badEntries.add(entry.getKey());
        }
        for (String key : badEntries) {
            map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void warnAboutNonSerializableClass(Object o) {
        boolean added;
        Set<String> set = this.nonSerializableClasses;
        synchronized (set) {
            added = this.nonSerializableClasses.add(o.getClass().getName());
        }
        if (added) {
            this.log.warn((Object)("Properties of types '" + o.getClass().getName() + "' will be removed from the audit log as they are not serializable"));
        }
    }

    protected void store(Connection connection, String id, byte[] data) throws Exception {
        if (this.adapter.doLoadData(connection, id) != null) {
            this.adapter.doUpdateData(connection, id, data);
        } else {
            this.adapter.doStoreData(connection, id, data);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public int getExchangeCount() throws AuditorException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            int n = this.adapter.doGetCount(connection);
            return n;
        }
        catch (Exception e) {
            throw new AuditorException("Could not retrieve exchange count", e);
        }
        finally {
            JdbcAuditor.close(connection, false);
        }
    }

    @Override
    public String[] getExchangeIdsByRange(int fromIndex, int toIndex) throws AuditorException {
        if (fromIndex < 0) {
            throw new IllegalArgumentException("fromIndex should be greater or equal to zero");
        }
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException("toIndex should be greater or equal to fromIndex");
        }
        if (fromIndex == toIndex) {
            return new String[0];
        }
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            String[] stringArray = this.adapter.doGetIds(connection, fromIndex, toIndex);
            return stringArray;
        }
        catch (Exception e) {
            throw new AuditorException("Could not retrieve exchange ids", e);
        }
        finally {
            JdbcAuditor.close(connection, false);
        }
    }

    @Override
    public Exchange[] getExchangesByIds(String[] ids) throws AuditorException {
        Exchange[] exchanges = new Exchange[ids.length];
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            for (int row = 0; row < ids.length; ++row) {
                exchanges[row] = this.getExchange(this.adapter.doLoadData(connection, ids[row]));
            }
            Exchange[] row = exchanges;
            return row;
        }
        catch (Exception e) {
            throw new AuditorException("Could not retrieve exchanges", e);
        }
        finally {
            JdbcAuditor.close(connection, false);
        }
    }

    @Override
    public int deleteExchangesByIds(String[] ids) throws AuditorException {
        Connection connection = null;
        boolean restoreAutoCommit = false;
        try {
            int row;
            connection = this.dataSource.getConnection();
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
                restoreAutoCommit = true;
            }
            for (row = 0; row < ids.length; ++row) {
                this.adapter.doRemoveData(connection, ids[row]);
            }
            connection.commit();
            row = ids.length;
            return row;
        }
        catch (Exception e) {
            throw new AuditorException("Could not delete exchanges", e);
        }
        finally {
            JdbcAuditor.close(connection, restoreAutoCommit);
        }
    }

    protected Exchange getExchange(byte[] data) throws AuditorException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.tccl);
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(data));
            Exchange exchange = (Exchange)is.readObject();
            return exchange;
        }
        catch (Exception e) {
            throw new AuditorException("Unable to reconstruct exchange", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    private static void close(Connection connection, boolean restoreAutoCommit) {
        if (connection != null) {
            try {
                if (restoreAutoCommit) {
                    connection.setAutoCommit(true);
                }
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

