/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.management.ManagedEndpoint;
import org.apache.servicemix.nmr.management.Nameable;
import org.apache.servicemix.nmr.management.NamingStrategy;
import org.apache.servicemix.nmr.management.stats.CountStatistic;
import org.apache.servicemix.nmr.management.stats.TimeStatistic;
import org.fusesource.commons.management.ManagementStrategy;
import org.fusesource.commons.management.Statistic;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.ServiceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementAgent
implements ManagementStrategy {
    private static final transient Log LOG = LogFactory.getLog(ManagementAgent.class);
    private boolean enabled;
    private MBeanServer mbeanServer;
    private Map<ObjectName, Object> mbeans = new HashMap<ObjectName, Object>();
    private NamingStrategy namingStrategy;
    private BundleContext bundleContext;
    private ServiceRegistration serviceRegistration;

    public synchronized void manageObject(Object managedObject) throws Exception {
        ObjectName objectName = this.getManagedObjectName(managedObject, null, ObjectName.class);
        this.manageNamedObject(managedObject, objectName);
    }

    public synchronized <T> T getManagedObjectName(Object managableObject, String customName, Class<T> nameType) throws Exception {
        return String.class.equals(nameType) && managableObject == null && customName == null ? (T)nameType.cast(this.namingStrategy.getJmxDomainName()) : (ObjectName.class.equals(nameType) ? (T)nameType.cast(this.getTypeSpecificObjectName(managableObject, customName)) : null);
    }

    public synchronized void manageNamedObject(Object managedObject, Object preferredName) throws Exception {
        managedObject = this.getTypeSpecificManagedObject(managedObject);
        if (preferredName instanceof ObjectName && managedObject != null) {
            try {
                this.register(managedObject, (ObjectName)preferredName);
            }
            catch (Exception ex) {
                throw (JMException)new JMException(ex.getMessage()).initCause(ex);
            }
        }
    }

    public synchronized void unmanageObject(Object managedObject) throws Exception {
        ObjectName objectName = this.getManagedObjectName(managedObject, null, ObjectName.class);
        this.unmanageNamedObject(objectName);
    }

    public synchronized void unmanageNamedObject(Object name) throws Exception {
        if (name instanceof ObjectName) {
            this.unregister((ObjectName)name);
        }
    }

    public synchronized boolean isManaged(Object managableObject, Object name) {
        try {
            return managableObject != null ? this.getMbeanServer().isRegistered(this.getManagedObjectName(managableObject, null, ObjectName.class)) : (name != null && name instanceof ObjectName ? this.getMbeanServer().isRegistered((ObjectName)name) : false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Statistic createStatistic(String name, Object owner, Statistic.UpdateMode updateMode) {
        return updateMode == Statistic.UpdateMode.COUNTER ? new TimeStatistic(name, null) : (updateMode == Statistic.UpdateMode.VALUE ? new CountStatistic(name, null) : null);
    }

    public void notify(EventObject event) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)event.toString());
        }
    }

    public void setBundleContext(BundleContext ctx) {
        this.bundleContext = ctx;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public synchronized void bindMBeanServer(ServiceReference reference) throws Exception {
        if (this.isEnabled()) {
            MBeanServer mbeanServer = (MBeanServer)this.bundleContext.getService(reference);
            this.bundleContext.ungetService(reference);
            if (mbeanServer != this.mbeanServer) {
                this.unregisterObjects();
                this.mbeanServer = mbeanServer;
                this.registerObjects();
            }
            this.registerService();
        }
    }

    public synchronized void unbindMBeanServer(ServiceReference reference) {
        if (this.isEnabled()) {
            this.unregisterObjects();
            this.mbeanServer = null;
            this.unregisterService();
        }
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    protected void registerObjects() {
        ObjectName[] mBeans = this.mbeans.keySet().toArray(new ObjectName[this.mbeans.size()]);
        int caught = 0;
        for (ObjectName name : mBeans) {
            try {
                this.register(this.mbeans.get(name), name);
            }
            catch (JMException jmex) {
                LOG.info((Object)"Exception unregistering MBean", (Throwable)jmex);
                ++caught;
            }
            catch (ServiceUnavailableException sue) {
                // empty catch block
            }
        }
        if (caught > 0) {
            LOG.warn((Object)("A number of " + caught + " exceptions caught while unregistering MBeans during stop operation.  " + "See INFO log for details."));
        }
    }

    protected void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, !(obj instanceof ManagedEndpoint));
    }

    protected void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        if (this.mbeanServer == null) {
            this.mbeans.put(name, obj);
        } else {
            try {
                this.registerMBeanWithServer(obj, name, forceRegistration);
            }
            catch (UndeclaredThrowableException ute) {
                if (ute.getCause() instanceof RuntimeException) {
                    LOG.warn((Object)"MBean registration failed: ", ute.getCause());
                    throw (RuntimeException)ute.getCause();
                }
                LOG.warn((Object)"MBean registration failed: ", ute.getCause());
                throw new JMException(ute.getCause().getMessage());
            }
        }
    }

    protected void unregisterObjects() {
        ObjectName[] mBeans = this.mbeans.keySet().toArray(new ObjectName[this.mbeans.size()]);
        int caught = 0;
        for (ObjectName name : mBeans) {
            try {
                this.unregister(name);
            }
            catch (JMException jmex) {
                LOG.info((Object)"Exception unregistering MBean", (Throwable)jmex);
                ++caught;
            }
            catch (ServiceUnavailableException sue) {
                // empty catch block
            }
        }
        if (caught > 0) {
            LOG.warn((Object)("A number of " + caught + " exceptions caught while unregistering MBeans during stop operation.  " + "See INFO log for details."));
        }
    }

    protected void unregister(ObjectName name) throws JMException {
        this.mbeans.remove(name);
        if (this.mbeanServer != null) {
            this.mbeanServer.unregisterMBean(name);
        }
    }

    protected void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        ObjectInstance instance;
        try {
            instance = this.mbeanServer.registerMBean(obj, name);
        }
        catch (InstanceAlreadyExistsException e) {
            if (forceRegistration) {
                this.mbeanServer.unregisterMBean(name);
                instance = this.mbeanServer.registerMBean(obj, name);
            }
            throw e;
        }
        if (instance != null) {
            this.mbeans.put(name, obj);
        }
    }

    protected void registerService() {
        this.serviceRegistration = this.getBundleContext().registerService("org.fusesource.commons.management.ManagementStrategy", (Object)this, null);
    }

    protected void unregisterService() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    protected ObjectName getTypeSpecificObjectName(Object mo, String customName) throws MalformedObjectNameException {
        return mo instanceof ManagedEndpoint ? this.namingStrategy.getObjectName((ManagedEndpoint)mo) : (mo instanceof Nameable ? (customName != null ? this.namingStrategy.getCustomObjectName(customName, ((Nameable)mo).getName()) : this.namingStrategy.getObjectName((Nameable)mo)) : null);
    }

    protected Object getTypeSpecificManagedObject(Object object) throws NotCompliantMBeanException {
        return object instanceof ManagedEndpoint ? object : (object instanceof Nameable ? new StandardMBean(object, ((Nameable)object).getPrimaryInterface()) : object);
    }
}

