/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.codec.RoleData;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.User;

public class UserData
extends RoleData {
    public UserData(String name, int type) {
        super(name, type);
    }

    public UserData(User user) {
        this(user.getName(), user.getType());
    }

    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("Name", this.name);
            items.put("Type", this.type);
            return new CompositeDataSupport(UserAdminMBean.USER_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData" + e);
        }
    }

    public static UserData from(CompositeData data) {
        if (data == null) {
            return null;
        }
        String name = (String)data.get("Name");
        int type = (Integer)data.get("Type");
        return new UserData(name, type);
    }
}

