/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.felix.cm.impl.ConfigurationAdminImpl;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.osgi.service.cm.Configuration;

public class ConfigurationAdapter
implements Configuration {
    private final ConfigurationAdminImpl configurationAdmin;
    private final ConfigurationImpl delegatee;

    ConfigurationAdapter(ConfigurationAdminImpl configurationAdmin, ConfigurationImpl delegatee) {
        this.configurationAdmin = configurationAdmin;
        this.delegatee = delegatee;
    }

    public String getPid() {
        this.checkDeleted();
        return this.delegatee.getPid();
    }

    public String getFactoryPid() {
        this.checkDeleted();
        return this.delegatee.getFactoryPid();
    }

    public String getBundleLocation() {
        this.configurationAdmin.checkPermission();
        this.checkDeleted();
        return this.delegatee.getBundleLocation();
    }

    public void setBundleLocation(String bundleLocation) {
        this.configurationAdmin.checkPermission();
        this.checkDeleted();
        this.delegatee.setStaticBundleLocation(bundleLocation);
    }

    public void update() throws IOException {
        this.checkDeleted();
        this.delegatee.update();
    }

    public void update(Dictionary properties) throws IOException {
        this.checkDeleted();
        this.delegatee.update(properties);
    }

    public Dictionary getProperties() {
        this.checkDeleted();
        return this.delegatee.getProperties(true);
    }

    public void delete() throws IOException {
        this.checkDeleted();
        this.delegatee.delete();
    }

    public int hashCode() {
        return this.delegatee.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegatee.equals(obj);
    }

    public String toString() {
        return this.delegatee.toString();
    }

    private void checkDeleted() {
        if (this.delegatee.isDeleted()) {
            throw new IllegalStateException("Configuration " + this.delegatee.getPid() + " deleted");
        }
    }
}

