/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.executors.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.ExecutorAwareRunnable;
import org.apache.servicemix.executors.impl.ExecutorConfig;
import org.apache.servicemix.executors.impl.ExecutorFactoryImpl;

public class ExecutorImpl
implements Executor {
    private final ThreadPoolExecutor threadPool;
    private ExecutorFactoryImpl executorFactory;
    private final ExecutorConfig config;

    public ExecutorImpl(ExecutorFactoryImpl executorFactory, ThreadPoolExecutor threadPool, ExecutorConfig config) {
        this.executorFactory = executorFactory;
        this.threadPool = threadPool;
        this.config = config;
    }

    public void execute(Runnable command) {
        if (this.config.isBypassIfSynchronous().booleanValue() && command instanceof ExecutorAwareRunnable && ((ExecutorAwareRunnable)command).shouldRunSynchronously()) {
            command.run();
            return;
        }
        this.threadPool.execute(command);
    }

    public void shutdown() {
        try {
            this.executorFactory.unregisterMBean(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.threadPool.shutdown();
        if (!this.threadPool.isTerminated() && this.config.getShutdownDelay() > 0L) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        if (!ExecutorImpl.this.threadPool.awaitTermination(ExecutorImpl.this.config.getShutdownDelay(), TimeUnit.MILLISECONDS)) {
                            ExecutorImpl.this.threadPool.shutdownNow();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }).start();
        }
    }

    public int capacity() {
        BlockingQueue<Runnable> queue = this.threadPool.getQueue();
        return queue.remainingCapacity() + queue.size();
    }

    public int size() {
        BlockingQueue<Runnable> queue = this.threadPool.getQueue();
        return queue.size();
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPool;
    }

    protected ExecutorConfig getConfig() {
        return this.config;
    }
}

