/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.executors.impl;

import java.lang.reflect.Method;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.impl.ExecutorConfig;
import org.apache.servicemix.executors.impl.ExecutorImpl;
import org.apache.servicemix.executors.impl.ManagedExecutorMBean;
import org.apache.servicemix.executors.impl.WrappedRejectedExecutionHandler;

public class ManagedExecutor
extends StandardMBean
implements Executor,
ManagedExecutorMBean {
    private String id;
    private ExecutorImpl internalExecutor;
    private ExecutorConfig config;
    private AtomicLong rejectedExecutions;

    public ManagedExecutor(String id, ExecutorImpl internalExecutor, ExecutorConfig config) throws NotCompliantMBeanException {
        super(ManagedExecutorMBean.class);
        this.id = id;
        this.internalExecutor = internalExecutor;
        this.config = config;
        this.rejectedExecutions = new AtomicLong(0L);
        if (this.internalExecutor != null) {
            this.setupWrapper();
        }
    }

    public String getId() {
        return this.id;
    }

    public int getActiveCount() {
        return this.internalExecutor != null ? this.internalExecutor.getThreadPoolExecutor().getActiveCount() : 0;
    }

    public long getCompletedTaskCount() {
        return this.internalExecutor != null ? this.internalExecutor.getThreadPoolExecutor().getCompletedTaskCount() : 0L;
    }

    public int getCorePoolSize() {
        return this.internalExecutor != null ? this.internalExecutor.getThreadPoolExecutor().getCorePoolSize() : 0;
    }

    public void setCorePoolSize(int size) {
        if (this.internalExecutor != null) {
            this.internalExecutor.getThreadPoolExecutor().setCorePoolSize(size);
        }
    }

    public long getKeepAliveTimeInMillis() {
        return this.internalExecutor != null ? this.internalExecutor.getThreadPoolExecutor().getKeepAliveTime(TimeUnit.MILLISECONDS) : 0L;
    }

    public void setKeepAliveTimeInMillis(long timeInMillis) {
        if (this.internalExecutor != null) {
            this.internalExecutor.getThreadPoolExecutor().setKeepAliveTime(timeInMillis, TimeUnit.MILLISECONDS);
        }
    }

    public int getLargestPoolSize() {
        return this.internalExecutor != null ? this.internalExecutor.getThreadPoolExecutor().getLargestPoolSize() : 0;
    }

    public int getMaximumPoolSize() {
        return this.internalExecutor != null ? this.internalExecutor.getThreadPoolExecutor().getMaximumPoolSize() : 0;
    }

    public void setMaximumPoolSize(int size) {
        if (this.internalExecutor != null) {
            this.internalExecutor.getThreadPoolExecutor().setMaximumPoolSize(size);
        }
    }

    public int getPoolSize() {
        return this.internalExecutor != null ? this.internalExecutor.getThreadPoolExecutor().getPoolSize() : 0;
    }

    public long getTaskCount() {
        return this.internalExecutor != null ? this.internalExecutor.getThreadPoolExecutor().getTaskCount() : 0L;
    }

    public int getQueueSize() {
        return this.internalExecutor != null ? this.internalExecutor.size() : 0;
    }

    public boolean isAllowCoreThreadTimeOut() {
        if (this.internalExecutor != null) {
            ThreadPoolExecutor executor = this.internalExecutor.getThreadPoolExecutor();
            try {
                Method m = ThreadPoolExecutor.class.getMethod("allowsCoreThreadTimeOut", null);
                try {
                    return (Boolean)m.invoke((Object)executor, null);
                }
                catch (Exception exception) {
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    public long getNumberOfRejectedExecutions() {
        return this.rejectedExecutions.get();
    }

    public void reset() {
        this.rejectedExecutions.set(0L);
    }

    public long getShutdownDelay() {
        return this.config != null ? this.config.getShutdownDelay() : 0L;
    }

    public boolean isBypassIfSynchronous() {
        return this.config != null && this.config.isBypassIfSynchronous() != false;
    }

    public void increaseRejectedExecutions() {
        this.rejectedExecutions.incrementAndGet();
    }

    private void setupWrapper() {
        this.internalExecutor.getThreadPoolExecutor().setRejectedExecutionHandler(new WrappedRejectedExecutionHandler(this));
    }

    public ExecutorImpl getInternalExecutor() {
        return this.internalExecutor;
    }

    public void execute(Runnable command) {
        if (this.internalExecutor != null) {
            this.internalExecutor.execute(command);
        }
    }

    public void shutdown() {
        if (this.internalExecutor != null) {
            this.internalExecutor.shutdown();
        }
    }

    public int capacity() {
        return this.internalExecutor != null ? this.internalExecutor.capacity() : 0;
    }

    public int size() {
        return this.internalExecutor != null ? this.internalExecutor.size() : 0;
    }

    protected String getDescription(MBeanInfo info) {
        return "Managed Executor";
    }

    protected String getDescription(MBeanFeatureInfo info) {
        if ("name".equalsIgnoreCase(info.getName())) {
            return "Name of the endpoint";
        }
        if ("properties".equalsIgnoreCase(info.getName())) {
            return "Properties associated to this endpoint";
        }
        if ("inboundExchangeCount".equalsIgnoreCase(info.getName())) {
            return "Number of exchanges received";
        }
        if ("inboundExchangeCount".equalsIgnoreCase(info.getName())) {
            return "Number of exchanges received";
        }
        if ("inboundExchangeRate".equalsIgnoreCase(info.getName())) {
            return "Exchanges received per second";
        }
        if ("outboundExchangeCount".equalsIgnoreCase(info.getName())) {
            return "Number of exchanges sent";
        }
        if ("outboundExchangeRate".equalsIgnoreCase(info.getName())) {
            return "Exchanges sent per second";
        }
        if ("reset".equalsIgnoreCase(info.getName())) {
            return "Reset statistics";
        }
        return null;
    }
}

