/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.hazelcast;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IdGenerator;
import java.io.IOException;
import java.util.Map;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.hazelcast.HazelcastStore;

public class HazelcastStoreFactory {
    private Map<String, HazelcastStore> stores;
    private HazelcastInstance hazelcastInstance;
    private long timeout = -1L;
    public static final String STORE_PREFIX = "org.apache.servicemix.stores";

    public synchronized Store open(String name) throws IOException {
        if (this.hazelcastInstance == null) {
            this.hazelcastInstance = Hazelcast.newHazelcastInstance(null);
        }
        this.stores = this.hazelcastInstance.getMap(STORE_PREFIX);
        HazelcastStore store = this.stores.get(name);
        String storeName = "org.apache.servicemix.stores." + name;
        if (store == null) {
            IdGenerator idGenerator = this.hazelcastInstance.getIdGenerator(storeName);
            store = this.timeout <= 0L ? new HazelcastStore(this.hazelcastInstance, storeName) : new HazelcastStore(this.hazelcastInstance, storeName, this.timeout);
            this.stores.put(name, store);
        }
        return store;
    }

    public synchronized void close(Store store) throws IOException {
        this.stores.remove(store);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }
}

