/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.runtime.impl.FaultImpl;
import org.apache.servicemix.jbi.runtime.impl.NormalizedMessageImpl;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.core.MessageImpl;

public class MessageExchangeImpl
implements MessageExchange {
    public static final String INTERFACE_NAME_PROP = "javax.jbi.InterfaceName";
    public static final String SERVICE_NAME_PROP = "javax.jbi.ServiceName";
    public static final String SERVICE_ENDPOINT_PROP = "javax.jbi.ServiceEndpoint";
    public static final String IN = "in";
    public static final String OUT = "out";
    public static final String FAULT = "fault";
    private static final Map<Pattern, URI> MEP_URIS = new HashMap<Pattern, URI>();
    private final Exchange exchange;
    private ExchangeStatus previousStatus;

    public MessageExchangeImpl(Exchange exchange) {
        this.exchange = exchange;
    }

    public Exchange getInternalExchange() {
        return this.exchange;
    }

    public String getExchangeId() {
        return this.exchange.getId();
    }

    public URI getPattern() {
        return MEP_URIS.get(this.exchange.getPattern());
    }

    public MessageExchange.Role getRole() {
        return this.exchange.getRole() == Role.Consumer ? MessageExchange.Role.CONSUMER : MessageExchange.Role.PROVIDER;
    }

    public ExchangeStatus getStatus() {
        if (this.exchange.getStatus() == Status.Active) {
            return ExchangeStatus.ACTIVE;
        }
        if (this.exchange.getStatus() == Status.Done) {
            return ExchangeStatus.DONE;
        }
        if (this.exchange.getStatus() == Status.Error) {
            return ExchangeStatus.ERROR;
        }
        throw new IllegalStateException();
    }

    public void setStatus(ExchangeStatus status) {
        if (status == ExchangeStatus.ACTIVE) {
            this.exchange.setStatus(Status.Active);
        } else if (status == ExchangeStatus.DONE) {
            this.exchange.setStatus(Status.Done);
        } else if (status == ExchangeStatus.ERROR) {
            this.exchange.setStatus(Status.Error);
        } else {
            throw new IllegalStateException();
        }
    }

    public QName getOperation() {
        return this.exchange.getOperation();
    }

    public void setOperation(QName qName) {
        this.exchange.setOperation(qName);
    }

    public Object getProperty(String s) {
        return this.exchange.getProperty(s);
    }

    public void setProperty(String s, Object o) {
        this.exchange.setProperty(s, o);
    }

    public Set getPropertyNames() {
        return this.exchange.getProperties().keySet();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return new NormalizedMessageImpl((Message)new MessageImpl());
    }

    public NormalizedMessage getMessage(String name) {
        if (IN.equalsIgnoreCase(name)) {
            return this.getInMessage();
        }
        if (OUT.equalsIgnoreCase(name)) {
            return this.getOutMessage();
        }
        if (FAULT.equalsIgnoreCase(name)) {
            return this.getFault();
        }
        throw new IllegalStateException();
    }

    public void setMessage(NormalizedMessage msg, String name) throws MessagingException {
        if (IN.equalsIgnoreCase(name)) {
            this.setInMessage(msg);
        } else if (OUT.equalsIgnoreCase(name)) {
            this.setOutMessage(msg);
        } else if (FAULT.equalsIgnoreCase(name)) {
            this.setFault((Fault)msg);
        } else {
            throw new IllegalStateException();
        }
    }

    public NormalizedMessage getInMessage() {
        Message msg = this.exchange.getIn(false);
        if (msg == null) {
            return null;
        }
        return new NormalizedMessageImpl(msg);
    }

    public void setInMessage(NormalizedMessage message) throws MessagingException {
        if (this.exchange.getIn(false) != null) {
            throw new MessagingException("In message already set");
        }
        NormalizedMessageImpl msg = (NormalizedMessageImpl)message;
        this.exchange.setIn(msg.getInternalMessage());
    }

    public NormalizedMessage getOutMessage() {
        Message msg = this.exchange.getOut(false);
        if (msg == null) {
            return null;
        }
        return new NormalizedMessageImpl(msg);
    }

    public void setOutMessage(NormalizedMessage message) throws MessagingException {
        if (this.exchange.getOut(false) != null) {
            throw new MessagingException("Out message already set");
        }
        NormalizedMessageImpl msg = (NormalizedMessageImpl)message;
        this.exchange.setOut(msg.getInternalMessage());
    }

    public Fault createFault() throws MessagingException {
        return new FaultImpl((Message)new MessageImpl());
    }

    public Fault getFault() {
        Message msg = this.exchange.getFault(false);
        if (msg == null) {
            return null;
        }
        return new FaultImpl(msg);
    }

    public void setFault(Fault message) throws MessagingException {
        if (this.exchange.getFault(false) != null) {
            throw new MessagingException("Fault message already set");
        }
        FaultImpl msg = (FaultImpl)message;
        this.exchange.setFault(msg.getInternalMessage());
    }

    public Exception getError() {
        return this.exchange.getError();
    }

    public void setError(Exception e) {
        this.exchange.setError(e);
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.exchange.setProperty(SERVICE_ENDPOINT_PROP, (Object)endpoint);
    }

    public void setService(QName service) {
        this.exchange.setProperty(SERVICE_NAME_PROP, (Object)service);
    }

    public void setInterfaceName(QName interfaceName) {
        this.exchange.setProperty(INTERFACE_NAME_PROP, (Object)interfaceName);
    }

    public ServiceEndpoint getEndpoint() {
        return MessageExchangeImpl.getEndpoint(this.exchange);
    }

    public QName getInterfaceName() {
        return MessageExchangeImpl.getInterfaceName(this.exchange);
    }

    public QName getService() {
        return MessageExchangeImpl.getService(this.exchange);
    }

    public boolean isTransacted() {
        return this.exchange.getProperty("javax.jbi.transaction.jta") != null;
    }

    void beforeReceived() throws MessagingException {
        this.previousStatus = this.getStatus();
    }

    void afterSend() throws MessagingException {
        if (this.previousStatus == ExchangeStatus.DONE || this.previousStatus == ExchangeStatus.ERROR) {
            throw new MessagingException("Can not send a terminated exchange");
        }
    }

    public static ServiceEndpoint getEndpoint(Exchange exchange) {
        return (ServiceEndpoint)exchange.getProperty(SERVICE_ENDPOINT_PROP, ServiceEndpoint.class);
    }

    public static QName getInterfaceName(Exchange exchange) {
        return (QName)exchange.getProperty(INTERFACE_NAME_PROP, QName.class);
    }

    public static QName getService(Exchange exchange) {
        return (QName)exchange.getProperty(SERVICE_NAME_PROP, QName.class);
    }

    static {
        for (Pattern mep : Pattern.values()) {
            String uri = mep.getWsdlUri();
            String name = uri.substring(uri.lastIndexOf(47) + 1);
            MEP_URIS.put(mep, URI.create("http://www.w3.org/2004/08/wsdl/" + name));
        }
    }
}

