/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.commands;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.servicemix.nmr.audit.AuditorMBean;
import org.apache.servicemix.nmr.audit.commands.AuditCommandSupport;

@Command(scope="audit", name="ids", description="Retrieve and display exchange ids.")
public class IdsCommand
extends AuditCommandSupport {
    @Option(name="--index")
    private int index = -1;
    @Option(name="--from")
    private int from = -1;
    @Option(name="--to")
    private int to = -1;
    @Option(name="--all")
    private boolean all;

    protected Object doExecute(AuditorMBean auditor) throws Exception {
        String[] ids;
        if (this.index >= 0) {
            ids = new String[]{auditor.getExchangeIdByIndex(this.index)};
        } else if (this.from >= 0 && this.to >= 0) {
            ids = auditor.getExchangeIdsByRange(this.from, this.to);
        } else if (this.all) {
            ids = auditor.getAllExchangeIds();
        } else {
            System.err.println("One of [--index, --id, --all] option must be specified");
            return null;
        }
        if (ids == null || ids.length == 0) {
            System.out.println("No matching exchanges");
        } else {
            for (String id : ids) {
                if (id == null) continue;
                System.out.println(id);
            }
        }
        return null;
    }
}

