/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.aries.proxy.InvocationHandlerWrapper;
import org.apache.aries.proxy.ProxyManager;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.NLS;
import org.apache.aries.proxy.impl.ProxyHandler;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProxyManager
implements ProxyManager {
    @Override
    public final Object createProxy(Bundle clientBundle, Collection<Class<?>> classes, Callable<Object> dispatcher) throws UnableToProxyException {
        return this.createProxy(clientBundle, classes, dispatcher, null);
    }

    @Override
    public final Object createProxy(Bundle clientBundle, Collection<Class<?>> classes, Callable<Object> dispatcher, InvocationHandlerWrapper wrapper) throws UnableToProxyException {
        ProxyHandler ih = new ProxyHandler(this, dispatcher, wrapper);
        Object proxyObject = this.duplicateProxy(classes, ih);
        if (proxyObject == null) {
            proxyObject = this.createNewProxy(clientBundle, classes, ih);
        }
        return proxyObject;
    }

    @Override
    public final Callable<Object> unwrap(Object proxy) {
        InvocationHandler ih;
        Callable<Object> target = null;
        if (this.isProxy(proxy) && (ih = this.getInvocationHandler(proxy)) instanceof ProxyHandler) {
            target = ((ProxyHandler)ih).getTarget();
        }
        return target;
    }

    @Override
    public final boolean isProxy(Object proxy) {
        return this.getInvocationHandler(proxy) instanceof ProxyHandler;
    }

    protected abstract Object createNewProxy(Bundle var1, Collection<Class<?>> var2, InvocationHandler var3) throws UnableToProxyException;

    protected abstract InvocationHandler getInvocationHandler(Object var1);

    protected abstract boolean isProxyClass(Class<?> var1);

    protected synchronized ClassLoader getClassLoader(Bundle clientBundle, Collection<Class<?>> classes) {
        if (clientBundle.getState() == 1) {
            throw new IllegalStateException(NLS.MESSAGES.getMessage("bundle.uninstalled", new Object[]{clientBundle.getSymbolicName(), clientBundle.getVersion(), clientBundle.getBundleId()}));
        }
        ClassLoader cl = null;
        if (classes.size() == 1) {
            cl = classes.iterator().next().getClassLoader();
        }
        if (cl == null) {
            cl = AriesFrameworkUtil.getClassLoaderForced((Bundle)clientBundle);
        }
        return cl;
    }

    private Object duplicateProxy(Collection<Class<?>> classes, InvocationHandler handler) {
        Class<?> classToProxy;
        boolean isProxy;
        Object proxyObject = null;
        if (classes.size() == 1 && (isProxy = this.isProxyClass(classToProxy = classes.iterator().next()))) {
            try {
                proxyObject = classToProxy.getConstructor(InvocationHandler.class).newInstance(handler);
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (SecurityException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return proxyObject;
    }
}

