/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.ssh.KarafJaasPasswordAuthenticator;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;

public class ShellCommandFactory
implements CommandFactory {
    private CommandProcessor commandProcessor;

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public Command createCommand(String command) {
        return new ShellCommand(command);
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public class ShellCommand
    implements Command,
    SessionAware {
        private String command;
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private ServerSession session;

        public ShellCommand(String command) {
            this.command = command;
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void setSession(ServerSession session) {
            this.session = session;
        }

        public void start(Environment env) throws IOException {
            block7: {
                try {
                    Subject subject;
                    final CommandSession session = ShellCommandFactory.this.commandProcessor.createSession(this.in, new PrintStream(this.out), new PrintStream(this.err));
                    Subject subject2 = subject = this.session != null ? (Subject)this.session.getAttribute(KarafJaasPasswordAuthenticator.SUBJECT_ATTRIBUTE_KEY) : null;
                    if (subject != null) {
                        try {
                            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws Exception {
                                    session.execute((CharSequence)ShellCommand.this.command);
                                    return null;
                                }
                            });
                            break block7;
                        }
                        catch (PrivilegedActionException e) {
                            throw e.getException();
                        }
                    }
                    session.execute((CharSequence)this.command);
                }
                catch (Exception e) {
                    try {
                        throw (IOException)new IOException("Unable to start shell").initCause(e);
                    }
                    catch (Throwable throwable) {
                        ShellCommandFactory.close(new Closeable[]{this.in, this.out, this.err});
                        this.callback.onExit(0);
                        throw throwable;
                    }
                }
            }
            ShellCommandFactory.close(new Closeable[]{this.in, this.out, this.err});
            this.callback.onExit(0);
        }

        public void destroy() {
        }
    }
}

