/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.File;
import java.util.Properties;
import javax.jbi.management.DeploymentException;
import javax.jbi.management.InstallationServiceMBean;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.deployer.artifacts.ComponentImpl;
import org.apache.servicemix.jbi.deployer.artifacts.SharedLibraryImpl;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.handler.Transformer;
import org.apache.servicemix.jbi.deployer.impl.AbstractInstaller;
import org.apache.servicemix.jbi.deployer.impl.ComponentInstaller;
import org.apache.servicemix.jbi.deployer.impl.Deployer;
import org.apache.servicemix.jbi.deployer.impl.SharedLibraryInstaller;
import org.apache.servicemix.jbi.deployer.utils.ManagementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallationService
implements InstallationServiceMBean {
    private final Logger logger = LoggerFactory.getLogger(InstallationService.class);
    private Deployer deployer;

    public synchronized ObjectName loadNewInstaller(String installJarURL) {
        try {
            this.logger.debug("Loading new installer from {}", (Object)installJarURL);
            ComponentInstaller installer = this.doLoadNewInstaller(installJarURL, false);
            return installer.getObjectName();
        }
        catch (Throwable t) {
            this.logger.error("Deployment failed", t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException("Deployment failed: " + t.getMessage());
        }
    }

    public ObjectName loadInstaller(String componentName) {
        try {
            ComponentInstaller installer = this.getComponentInstaller(componentName);
            if (installer != null) {
                installer.register();
            }
            return installer != null ? installer.getObjectName() : null;
        }
        catch (Exception e) {
            String errStr = "Error loading installer: " + componentName;
            this.logger.error(errStr, (Throwable)e);
            return null;
        }
    }

    public boolean unloadInstaller(String componentName, boolean isToBeDeleted) {
        boolean result = false;
        try {
            ComponentInstaller installer = this.getComponentInstaller(componentName);
            if (installer != null) {
                installer.unregister();
                if (isToBeDeleted) {
                    installer.uninstall();
                }
                result = true;
            }
        }
        catch (Exception e) {
            String errStr = "Error unloading installer: " + componentName;
            this.logger.error(errStr, (Throwable)e);
        }
        return result;
    }

    protected ComponentInstaller getComponentInstaller(String name) {
        ComponentImpl component = this.deployer.getComponent(name);
        return (ComponentInstaller)this.deployer.getInstaller(component);
    }

    public String installSharedLibrary(String location) {
        try {
            return this.doInstallSharedLibrary(location);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            throw ManagementSupport.failure("installSharedibrary", location, e);
        }
    }

    public boolean uninstallSharedLibrary(String aSharedLibName) {
        try {
            this.doUninstallSharedLibrary(aSharedLibName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void install(String location, Properties props, boolean autoStart) throws Exception {
        ComponentInstaller installer = this.doLoadNewInstaller(location, autoStart);
        try {
            installer.configure(props);
            installer.install();
        }
        catch (Exception e) {
            installer.uninstall(true);
            throw e;
        }
    }

    public String doInstallSharedLibrary(String location) throws Exception {
        File jarfile = new File(location);
        if (jarfile.exists()) {
            Descriptor desc = Transformer.getDescriptor(jarfile);
            if (desc.getSharedLibrary() == null) {
                throw new DeploymentException("JBI descriptor is not a shared library descriptor");
            }
            String slName = desc.getSharedLibrary().getIdentification().getName();
            this.logger.info("Installing shared library {}", (Object)slName);
            if (this.deployer.getSharedLibrary(slName) != null) {
                throw new DeploymentException("ShareLib " + slName + " is already installed");
            }
            SharedLibraryInstaller installer = new SharedLibraryInstaller(this.deployer, desc, jarfile, false);
            installer.installBundle();
            installer.init();
            installer.install();
            return slName;
        }
        throw new Exception("Unable to find shared library " + location);
    }

    public void doUninstallSharedLibrary(String aSharedLibName) throws Exception {
        SharedLibraryImpl library = this.deployer.getSharedLibrary(aSharedLibName);
        if (library == null) {
            throw ManagementSupport.failure("uninstall", "Shared library has not been installed: " + aSharedLibName);
        }
        AbstractInstaller installer = this.deployer.getInstaller(library);
        if (installer == null) {
            throw ManagementSupport.failure("uninstall", "Could not find shared library installer: " + aSharedLibName);
        }
        installer.uninstall(false);
    }

    protected ComponentInstaller doLoadNewInstaller(String location, boolean autoStart) throws Exception {
        File jarfile = new File(location);
        if (jarfile.exists()) {
            Descriptor desc = Transformer.getDescriptor(jarfile);
            if (desc.getComponent() != null) {
                String componentName = desc.getComponent().getIdentification().getName();
                ComponentInstaller installer = this.getComponentInstaller(componentName);
                if (installer == null) {
                    installer = new ComponentInstaller(this.deployer, desc, jarfile, autoStart);
                    installer.installBundle();
                    installer.init();
                    installer.register();
                    return installer;
                }
                throw new Exception("An installer already exists for " + componentName);
            }
            throw new Exception("JBI descriptor is not a component descriptor");
        }
        throw new Exception("Unable to find component " + location);
    }

    public Deployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }
}

