/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.log;

import java.io.PrintStream;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.log.DisplayLog;
import org.apache.karaf.shell.log.layout.PatternConverter;
import org.apache.karaf.shell.log.layout.PatternParser;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

@Command(scope="log", name="tail", description="Continuously display log entries.")
public class LogTail
extends DisplayLog {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        PatternConverter cnv = new PatternParser(this.overridenPattern != null ? this.overridenPattern : this.pattern).parse();
        PrintStream out = System.out;
        Iterable<PaxLoggingEvent> le = this.events.getElements(this.entries == 0 ? Integer.MAX_VALUE : this.entries);
        for (PaxLoggingEvent event : le) {
            this.display(cnv, event, out);
        }
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        PaxAppender appender = new PaxAppender(){

            public void doAppend(PaxLoggingEvent event) {
                queue.add(event);
            }
        };
        try {
            try {
                this.events.addAppender(appender);
                while (true) {
                    this.display(cnv, (PaxLoggingEvent)queue.take(), out);
                }
            }
            catch (InterruptedException e) {
                this.events.removeAppender(appender);
            }
        }
        catch (Throwable throwable) {
            this.events.removeAppender(appender);
            throw throwable;
        }
        out.println();
        return null;
    }
}

