/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.endpoints;

import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ExternalEndpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.SimpleEndpoint;
import org.apache.servicemix.common.util.URIResolver;

public abstract class ConsumerEndpoint
extends SimpleEndpoint {
    private ServiceEndpoint activated;
    private QName targetInterface;
    private QName targetService;
    private String targetEndpoint;
    private QName targetOperation;
    private String targetUri;

    public ConsumerEndpoint() {
    }

    public ConsumerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public ConsumerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component.getServiceUnit(), endpoint.getServiceName(), endpoint.getEndpointName());
    }

    public MessageExchange.Role getRole() {
        return MessageExchange.Role.CONSUMER;
    }

    public synchronized void activate() throws Exception {
        super.activate();
        ServiceMixComponent component = this.getServiceUnit().getComponent();
        ComponentContext ctx = component.getComponentContext();
        this.activated = new ExternalEndpoint(component.getEPRElementName(), this.getLocationURI(), this.getService(), this.getEndpoint(), this.getInterfaceName());
        ctx.registerExternalEndpoint(this.activated);
    }

    public synchronized void deactivate() throws Exception {
        ServiceMixComponent component = this.getServiceUnit().getComponent();
        ComponentContext ctx = component.getComponentContext();
        if (this.activated != null) {
            ServiceEndpoint se = this.activated;
            this.activated = null;
            ctx.deregisterExternalEndpoint(se);
        }
        super.deactivate();
    }

    public String getLocationURI() {
        return null;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public void setTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
    }

    public QName getTargetInterface() {
        return this.targetInterface;
    }

    public void setTargetInterface(QName targetInterface) {
        this.targetInterface = targetInterface;
    }

    public QName getTargetService() {
        return this.targetService;
    }

    public void setTargetService(QName targetService) {
        this.targetService = targetService;
    }

    public QName getTargetOperation() {
        return this.targetOperation;
    }

    public void setTargetOperation(QName targetOperation) {
        this.targetOperation = targetOperation;
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = targetUri;
    }

    protected void configureExchangeTarget(MessageExchange exchange) {
        if (this.targetUri != null) {
            URIResolver.configureExchange(exchange, this.getContext(), this.targetUri);
        }
        if (exchange.getInterfaceName() == null && this.targetInterface != null) {
            exchange.setInterfaceName(this.targetInterface);
        }
        if (exchange.getOperation() == null && this.targetOperation != null) {
            exchange.setOperation(this.targetOperation);
        }
        if (exchange.getService() == null && this.targetService != null) {
            exchange.setService(this.targetService);
            if (this.targetEndpoint != null) {
                ServiceEndpoint se = this.getContext().getEndpoint(this.targetService, this.targetEndpoint);
                if (se != null) {
                    exchange.setEndpoint(se);
                } else {
                    logger.warn("Target service (" + this.targetService + ") and endpoint (" + this.targetEndpoint + ")" + " specified, but no matching endpoint found.  Only the service will be used for routing.");
                }
            }
        }
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.targetInterface == null && this.targetService == null && this.targetUri == null) {
            throw new DeploymentException("targetInterface, targetService or targetUri should be specified");
        }
    }
}

