/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.servicemix.jbi.runtime.ComponentWrapper;
import org.apache.servicemix.jbi.runtime.impl.AbstractComponentContext;
import org.apache.servicemix.jbi.runtime.impl.ComponentRegistryImpl;
import org.apache.servicemix.jbi.runtime.impl.DeliveryChannelImpl;
import org.apache.servicemix.jbi.runtime.impl.EndpointImpl;
import org.apache.servicemix.jbi.runtime.impl.ServiceEndpointImpl;
import org.apache.servicemix.jbi.runtime.impl.utils.DOMUtil;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContextImpl
extends AbstractComponentContext {
    public static final int DEFAULT_QUEUE_CAPACITY = 1024;
    private final Logger logger = LoggerFactory.getLogger(ComponentContextImpl.class);
    protected ComponentWrapper component;
    protected Map<String, ?> properties;
    protected BlockingQueue<Exchange> queue;
    protected EndpointImpl componentEndpoint;
    protected String name;
    protected File workspaceRoot;
    protected File installRoot;
    public static final String WSDL1_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";

    public ComponentContextImpl(ComponentRegistryImpl componentRegistry, ComponentWrapper component, Map<String, ?> properties) {
        super(componentRegistry);
        this.component = component;
        this.properties = properties;
        this.queue = new ArrayBlockingQueue<Exchange>(1024);
        this.componentEndpoint = new EndpointImpl(properties);
        this.componentEndpoint.setQueue(this.queue);
        this.componentRegistry.getNmr().getEndpointRegistry().register((Endpoint)this.componentEndpoint, properties);
        this.dc = new DeliveryChannelImpl(this, this.componentEndpoint.getChannel(), this.queue);
        this.name = (String)properties.get("NAME");
        this.workspaceRoot = new File(System.getProperty("karaf.base"), System.getProperty("jbi.cache", "data/jbi/") + this.name + "/workspace");
        this.workspaceRoot.mkdirs();
        this.installRoot = new File(System.getProperty("karaf.base"), System.getProperty("jbi.cache", "data/jbi/") + this.name + "/install");
        this.installRoot.mkdirs();
    }

    public void destroy() {
        try {
            this.dc.close();
        }
        catch (MessagingException e) {
            this.logger.warn("Error when closing the delivery channel", (Throwable)e);
        }
        this.componentRegistry.getNmr().getEndpointRegistry().unregister((Endpoint)this.componentEndpoint, this.properties);
    }

    public synchronized ServiceEndpoint activateEndpoint(QName serviceName, String endpointName) throws JBIException {
        try {
            ServiceEndpointImpl se = new ServiceEndpointImpl(serviceName, endpointName);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("NAME", serviceName.toString() + ":" + endpointName);
            props.put("SERVICE_NAME", serviceName.toString());
            props.put("ENDPOINT_NAME", endpointName);
            props.put("jbi.internal", Boolean.TRUE.toString());
            Document doc = this.component.getComponent().getServiceDescription((ServiceEndpoint)se);
            if (doc != null) {
                QName[] interfaceNames = this.getInterfaces(doc, se);
                if (interfaceNames != null) {
                    StringBuilder sb = new StringBuilder();
                    for (QName itf : interfaceNames) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(itf.toString());
                    }
                    props.put("INTERFACE_NAME", sb.toString());
                }
                String data = DOMUtil.asXML(doc);
                String url = this.componentRegistry.getDocumentRepository().register(data.getBytes());
                props.put("WSDL_URL", url);
            }
            EndpointImpl endpoint = new EndpointImpl(props);
            endpoint.setQueue(this.queue);
            this.componentRegistry.getNmr().getEndpointRegistry().register((Endpoint)endpoint, props);
            return endpoint;
        }
        catch (TransformerException e) {
            throw new JBIException((Throwable)e);
        }
    }

    public synchronized void deactivateEndpoint(ServiceEndpoint endpoint) throws JBIException {
        List<Endpoint> eps = this.doQueryEndpoints(ServiceHelper.createMap((String[])new String[]{"SERVICE_NAME", endpoint.getServiceName().toString(), "ENDPOINT_NAME", endpoint.getEndpointName()}), false);
        if (eps != null && eps.size() == 1) {
            Endpoint ep = eps.get(0);
            this.componentRegistry.getNmr().getEndpointRegistry().unregister(ep, null);
        }
    }

    public void registerExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
        try {
            Document doc;
            QName serviceName = externalEndpoint.getServiceName();
            String endpointName = externalEndpoint.getEndpointName();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("NAME", serviceName.toString() + ":" + endpointName);
            props.put("SERVICE_NAME", serviceName.toString());
            props.put("ENDPOINT_NAME", endpointName);
            props.put("UNTARGETABLE", Boolean.TRUE.toString());
            props.put("jbi.external", Boolean.TRUE.toString());
            props.put(ServiceEndpoint.class.getName(), (String)externalEndpoint);
            QName[] interfaceNames = externalEndpoint.getInterfaces();
            if (interfaceNames != null) {
                StringBuilder sb = new StringBuilder();
                for (QName itf : interfaceNames) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(itf.toString());
                }
                props.put("INTERFACE_NAME", sb.toString());
            }
            if ((doc = this.component.getComponent().getServiceDescription(externalEndpoint)) != null) {
                String data = DOMUtil.asXML(doc);
                String url = this.componentRegistry.getDocumentRepository().register(data.getBytes());
                props.put("WSDL_URL", url);
            }
            EndpointImpl endpoint = new EndpointImpl(props);
            endpoint.setQueue(this.queue);
            this.componentRegistry.getNmr().getEndpointRegistry().register((Endpoint)endpoint, props);
        }
        catch (TransformerException e) {
            throw new JBIException((Throwable)e);
        }
    }

    public void deregisterExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
        List<Endpoint> eps = this.doQueryEndpoints(ServiceHelper.createMap((String[])new String[]{"SERVICE_NAME", externalEndpoint.getServiceName().toString(), "ENDPOINT_NAME", externalEndpoint.getEndpointName()}), true);
        if (eps != null && eps.size() == 1) {
            Endpoint ep = eps.get(0);
            this.componentRegistry.getNmr().getEndpointRegistry().unregister(ep, null);
        }
    }

    public String getComponentName() {
        return this.name;
    }

    public String getInstallRoot() {
        return this.installRoot.getAbsolutePath();
    }

    public String getWorkspaceRoot() {
        return this.workspaceRoot.getAbsolutePath();
    }

    public ComponentWrapper getComponent() {
        return this.component;
    }

    protected QName[] getInterfaces(Document document, ServiceEndpoint serviceEndpoint) {
        try {
            if (document == null || document.getDocumentElement() == null) {
                this.logger.debug("Endpoint {} has no service description", (Object)serviceEndpoint);
                return null;
            }
            if (!WSDL1_NAMESPACE.equals(document.getDocumentElement().getNamespaceURI())) {
                this.logger.debug("Endpoint {} has a non WSDL1 service description", (Object)serviceEndpoint);
                return null;
            }
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            Definition definition = reader.readWSDL(null, document);
            if (definition.getPortTypes().keySet().size() == 1 && definition.getServices().keySet().size() == 0) {
                PortType portType = (PortType)definition.getPortTypes().values().iterator().next();
                QName interfaceName = portType.getQName();
                this.logger.debug("Endpoint {} implements interface {}", (Object)serviceEndpoint, (Object)interfaceName);
                return new QName[]{interfaceName};
            }
            Service service = definition.getService(serviceEndpoint.getServiceName());
            if (service == null) {
                this.logger.info("Endpoint {} has a service description, but no matching service found in {}", (Object)serviceEndpoint, definition.getServices().keySet());
                return null;
            }
            Port port = service.getPort(serviceEndpoint.getEndpointName());
            if (port == null) {
                this.logger.info("Endpoint {} has a service description, but no matching endpoint found in {}", (Object)serviceEndpoint, service.getPorts().keySet());
                return null;
            }
            if (port.getBinding() == null) {
                this.logger.info("Endpoint {} has a service description, but no binding found", (Object)serviceEndpoint);
                return null;
            }
            if (port.getBinding().getPortType() == null) {
                this.logger.info("Endpoint {} has a service description, but no port type found", (Object)serviceEndpoint);
                return null;
            }
            QName interfaceName = port.getBinding().getPortType().getQName();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Endpoint {} implements interface {}", (Object)serviceEndpoint, (Object)interfaceName);
            }
            return new QName[]{interfaceName};
        }
        catch (Throwable e) {
            this.logger.warn("Error retrieving interfaces from service description: {}", (Object)e.getMessage());
            this.logger.debug("Error retrieving interfaces from service description", e);
            return null;
        }
    }
}

