/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.xbean;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jbi.messaging.MessageExchange;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.packaging.Consumes;
import org.apache.servicemix.common.packaging.Provides;
import org.apache.servicemix.common.packaging.ServiceUnitAnalyzer;
import org.apache.xbean.spring.context.FileSystemXmlApplicationContext;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXBeanServiceUnitAnalyzer
implements ServiceUnitAnalyzer {
    List<Consumes> consumes = new ArrayList<Consumes>();
    List<Provides> provides = new ArrayList<Provides>();

    @Override
    public List<Consumes> getConsumes() {
        return this.consumes;
    }

    protected abstract List<Consumes> getConsumes(Endpoint var1);

    @Override
    public List<Provides> getProvides() {
        return this.provides;
    }

    protected List<Provides> getProvides(Endpoint endpoint) {
        ArrayList<Provides> providesList = new ArrayList<Provides>();
        if (endpoint.getRole().equals(MessageExchange.Role.PROVIDER)) {
            Provides newProvide = new Provides();
            newProvide.setEndpointName(endpoint.getEndpoint());
            newProvide.setInterfaceName(endpoint.getInterfaceName());
            newProvide.setServiceName(endpoint.getService());
            providesList.add(newProvide);
        }
        return providesList;
    }

    protected abstract String getXBeanFile();

    @Override
    public void init(File explodedServiceUnitRoot) {
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(new String[]{"file:///" + explodedServiceUnitRoot.getAbsolutePath() + "/" + this.getXBeanFile()}, false);
        List beanFactoryPostProcessors = this.getBeanFactoryPostProcessors(explodedServiceUnitRoot.getAbsolutePath());
        for (BeanFactoryPostProcessor processor : beanFactoryPostProcessors) {
            context.addBeanFactoryPostProcessor(processor);
        }
        context.refresh();
        for (int i = 0; i < context.getBeanDefinitionNames().length; ++i) {
            Object bean = context.getBean(context.getBeanDefinitionNames()[i]);
            if (!this.isValidEndpoint(bean)) continue;
            Endpoint endpoint = (Endpoint)bean;
            this.provides.addAll(this.getProvides(endpoint));
            this.consumes.addAll(this.getConsumes(endpoint));
        }
    }

    protected List getBeanFactoryPostProcessors(String absolutePath) {
        return Collections.EMPTY_LIST;
    }

    protected abstract boolean isValidEndpoint(Object var1);
}

