/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.cluster.requestor;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.JmsException;
import org.springframework.jms.listener.AbstractJmsListeningContainer;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.CachingDestinationResolver;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.Assert;

public abstract class AbstractJmsRequestorPool
extends AbstractMessageListenerContainer {
    public static final String DEFAULT_THREAD_NAME_PREFIX = "JmsRequestorPool-";
    public static final long DEFAULT_RECOVERY_INTERVAL = 5000L;
    private long recoveryInterval = 5000L;
    private TaskExecutor taskExecutor;
    protected int concurrentConsumers = 1;
    protected int maxConcurrentConsumers = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.taskExecutor = taskExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutor getTaskExecutor() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.taskExecutor == null) {
                this.taskExecutor = this.createDefaultTaskExecutor();
            }
        }
        return this.taskExecutor;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void initialize() {
        this.getTaskExecutor();
        super.initialize();
    }

    protected TaskExecutor createDefaultTaskExecutor() {
        String beanName = this.getBeanName();
        String threadNamePrefix = beanName != null ? beanName + "-" : DEFAULT_THREAD_NAME_PREFIX;
        return new SimpleAsyncTaskExecutor(threadNamePrefix);
    }

    protected void doRescheduleTask(Object task) {
        this.getTaskExecutor().execute((Runnable)task);
    }

    protected void establishSharedConnection() {
        try {
            super.establishSharedConnection();
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Could not establish shared JMS Connection - leaving it up to asynchronous invokers to establish a Connection as soon as possible", (Throwable)ex);
        }
    }

    protected void startSharedConnection() {
        try {
            super.startSharedConnection();
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Connection start failed - relying on listeners to perform recovery", (Throwable)ex);
        }
    }

    protected void stopSharedConnection() {
        try {
            super.stopSharedConnection();
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Connection stop failed - relying on listeners to perform recovery after restart", (Throwable)ex);
        }
    }

    protected void handleListenerSetupFailure(Throwable ex, boolean alreadyRecovered) {
        if (ex instanceof JMSException) {
            this.invokeExceptionListener((JMSException)ex);
        }
        if (ex instanceof AbstractJmsListeningContainer.SharedConnectionNotInitializedException) {
            if (!alreadyRecovered) {
                this.logger.debug((Object)"JMS message listener invoker needs to establish shared Connection");
            }
        } else if (alreadyRecovered) {
            this.logger.debug((Object)"Setup of JMS message listener invoker failed - already recovered by other invoker", ex);
        } else {
            StringBuffer msg = new StringBuffer();
            msg.append("Setup of JMS message listener invoker failed for destination '");
            msg.append(this.getDestinationDescription()).append("' - trying to recover. Cause: ");
            msg.append(ex instanceof JMSException ? JmsUtils.buildExceptionMessage((JMSException)this.fixForSpring5470((JMSException)ex)) : ex.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.info((Object)msg, ex);
            } else {
                this.logger.info((Object)msg);
            }
        }
    }

    protected void recoverAfterListenerSetupFailure() {
        this.refreshConnectionUntilSuccessful();
        this.refreshDestination();
    }

    protected void refreshConnectionUntilSuccessful() {
        while (this.isRunning()) {
            try {
                if (this.sharedConnectionEnabled()) {
                    this.refreshSharedConnection();
                } else {
                    Connection con = this.createConnection();
                    JmsUtils.closeConnection((Connection)con);
                }
                this.logger.info((Object)"Successfully refreshed JMS Connection");
                break;
            }
            catch (Exception ex) {
                StringBuffer msg = new StringBuffer();
                msg.append("Could not refresh JMS Connection for destination '");
                msg.append(this.getDestinationDescription()).append("' - retrying in ");
                msg.append(this.recoveryInterval).append(" ms. Cause: ");
                msg.append(ex instanceof JMSException ? JmsUtils.buildExceptionMessage((JMSException)this.fixForSpring5470((JMSException)ex)) : ex.getMessage());
                if (this.logger.isDebugEnabled()) {
                    this.logger.info((Object)msg, (Throwable)ex);
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)msg);
                }
                this.sleepInbetweenRecoveryAttempts();
            }
        }
    }

    protected void refreshDestination() {
        DestinationResolver destResolver;
        String destName = this.getDestinationName();
        if (destName != null && (destResolver = this.getDestinationResolver()) instanceof CachingDestinationResolver) {
            ((CachingDestinationResolver)destResolver).removeFromCache(destName);
        }
    }

    protected void sleepInbetweenRecoveryAttempts() {
        if (this.recoveryInterval > 0L) {
            try {
                Thread.sleep(this.recoveryInterval);
            }
            catch (InterruptedException interEx) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected MessageConsumer createConsumer(Session session) throws JMSException {
        Destination destination = this.getDestination();
        if (destination == null) {
            destination = this.resolveDestinationName(session, this.getDestinationName());
        }
        return this.createConsumer(session, destination);
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        return session.createConsumer(destination, this.getMessageSelector());
    }

    protected MessageProducer createProducer(Session session) throws JMSException {
        Destination destination = this.getDestination();
        if (destination == null) {
            destination = this.resolveDestinationName(session, this.getDestinationName());
        }
        return this.createProducer(session, destination);
    }

    protected MessageProducer createProducer(Session session, Destination destination) throws JMSException {
        return session.createProducer(destination);
    }

    protected JmsException convertJmsAccessException(JMSException ex) {
        return JmsUtils.convertJmsAccessException((JMSException)this.fixForSpring5470(ex));
    }

    private JMSException fixForSpring5470(JMSException ex) {
        if (ex.getCause() != null && ex.getCause().getMessage() == null) {
            ex.setLinkedException(new Exception("Unknown", ex.getCause()));
        }
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue((concurrentConsumers > 0 ? 1 : 0) != 0, (String)"'concurrentConsumers' value must be at least 1 (one)");
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.concurrentConsumers = concurrentConsumers;
            if (this.maxConcurrentConsumers < concurrentConsumers) {
                this.maxConcurrentConsumers = concurrentConsumers;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getConcurrentConsumers() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.concurrentConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        Assert.isTrue((maxConcurrentConsumers > 0 ? 1 : 0) != 0, (String)"'maxConcurrentConsumers' value must be at least 1 (one)");
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.maxConcurrentConsumers = maxConcurrentConsumers > this.concurrentConsumers ? maxConcurrentConsumers : this.concurrentConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMaxConcurrentConsumers() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.maxConcurrentConsumers;
        }
    }
}

