/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.monitor.MonitoringService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorServiceImpl
implements MonitoringService,
BundleListener {
    private final Felix felix;
    private final ThreadGroup rootThreadGroup;
    private final Map<String, ExecutorService> executors;
    private final Map<String, ThreadGroup> threadGroups;
    private final Map<ThreadGroup, Boolean> allThreadGroups;
    private final Map<ClassLoader, Boolean> classLoaders;

    public MonitorServiceImpl(Felix felix) {
        this.felix = felix;
        this.rootThreadGroup = new ThreadGroup("bundles");
        this.executors = new HashMap<String, ExecutorService>();
        this.threadGroups = new HashMap<String, ThreadGroup>();
        this.allThreadGroups = new WeakHashMap<ThreadGroup, Boolean>();
        this.classLoaders = new WeakHashMap<ClassLoader, Boolean>();
    }

    @Override
    public Future<?> runInContext(Bundle bundle, Runnable run) {
        return this.getExecutor(bundle).submit(run);
    }

    @Override
    public <T> Future<T> runInContext(Bundle bundle, Callable<T> callable) {
        return this.getExecutor(bundle).submit(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getExecutor(Bundle bundle) {
        ExecutorService executor;
        Map<String, ExecutorService> map = this.executors;
        synchronized (map) {
            String key = new StringBuffer().append(bundle.getSymbolicName()).append("-").append(bundle.getVersion()).toString();
            executor = this.executors.get(key);
            if (executor == null) {
                executor = Executors.newCachedThreadPool(new MonitoringThreadFactory(bundle));
            }
            this.executors.put(key, executor);
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadGroup getThreadGroup(Bundle bundle) {
        Map<String, ThreadGroup> map = this.threadGroups;
        synchronized (map) {
            String key = new StringBuffer().append(bundle.getSymbolicName()).append("-").append(bundle.getVersion()).toString();
            ThreadGroup tg = this.threadGroups.get(key);
            if (tg == null) {
                tg = new ThreadGroup(this.rootThreadGroup, key);
                this.threadGroups.put(key, tg);
                this.allThreadGroups.put(tg, new Boolean(true));
            }
            return tg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ThreadGroup> getThreadGroups() {
        Map<String, ThreadGroup> map = this.threadGroups;
        synchronized (map) {
            return this.allThreadGroups.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstallBundle(Bundle bundle) {
        String key = new StringBuffer().append(bundle.getSymbolicName()).append("-").append(bundle.getVersion()).toString();
        Map<String, Object> map = this.executors;
        synchronized (map) {
            ExecutorService executor = this.executors.remove(key);
            if (executor != null) {
                executor.shutdown();
            }
        }
        map = this.threadGroups;
        synchronized (map) {
            ThreadGroup tg = this.threadGroups.remove(key);
            if (tg != null) {
                tg.setDaemon(true);
                try {
                    tg.destroy();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClassLoader> getClassLoaders() {
        Map<ClassLoader, Boolean> map = this.classLoaders;
        synchronized (map) {
            return this.classLoaders.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClassLoader(ClassLoader classLoader) {
        Map<ClassLoader, Boolean> map = this.classLoaders;
        synchronized (map) {
            this.classLoaders.put(classLoader, new Boolean(true));
        }
    }

    public void start() {
        this.felix.addBundleListener(this.felix, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<Object, Object> map = this.executors;
        synchronized (map) {
            for (ExecutorService ex : this.executors.values()) {
                ex.shutdown();
            }
            this.executors.clear();
        }
        map = this.threadGroups;
        synchronized (map) {
            for (ThreadGroup tg : this.threadGroups.values()) {
                tg.setDaemon(true);
                try {
                    tg.destroy();
                }
                catch (Throwable t) {}
            }
            this.threadGroups.clear();
        }
        map = this.classLoaders;
        synchronized (map) {
            this.classLoaders.clear();
        }
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 8 || event.getType() == 16) {
            this.uninstallBundle(event.getBundle());
        }
    }

    class MonitoringThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        MonitoringThreadFactory(Bundle bundle) {
            this.group = MonitorServiceImpl.this.getThreadGroup(bundle);
            this.namePrefix = "pool-" + bundle.getSymbolicName() + "-" + bundle.getVersion().toString() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

