/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management.stats;

import java.util.concurrent.atomic.AtomicLong;

public abstract class Statistic
implements org.fusesource.commons.management.Statistic {
    private String name;
    private String unit;
    private String description;
    private long startTime;
    private long lastSampleTime;
    protected final AtomicLong updateCount = new AtomicLong(0L);

    public Statistic(String name, String unit, String description) {
        this.name = name;
        this.unit = unit;
        this.description = description;
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    public long getUpdateCount() {
        return this.updateCount.get();
    }

    public synchronized void reset() {
        this.updateCount.set(0L);
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    protected synchronized void updateSampleTime() {
        this.lastSampleTime = System.currentTimeMillis();
    }

    protected void updateUpdateCount() {
        this.updateCount.incrementAndGet();
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append("{");
        this.appendFieldDescription(buffer);
        buffer.append(" }");
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized long getLastSampleTime() {
        return this.lastSampleTime;
    }

    protected synchronized void appendFieldDescription(StringBuffer buffer) {
        buffer.append(" unit: ");
        buffer.append(this.unit);
        buffer.append(" startTime: ");
        buffer.append(this.startTime);
        buffer.append(" lastSampleTime: ");
        buffer.append(this.lastSampleTime);
        buffer.append(" description: ");
        buffer.append(this.description);
    }
}

